/*
 * Decompiled with CFR 0.152.
 */
package com.airdsp.buzztouch;

import android.app.Activity;
import android.content.Context;
import android.content.res.Configuration;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Handler;
import android.os.Message;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.View;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.view.animation.Interpolator;
import android.view.animation.TranslateAnimation;
import android.widget.FrameLayout;
import com.airdsp.buzztouch.AdCallbackListener;
import com.airdsp.buzztouch.AirSDK;
import com.airdsp.buzztouch.AsyncTaskCompleteListener;
import com.airdsp.buzztouch.BrowserActivity;
import com.airdsp.buzztouch.FormatAds;
import com.airdsp.buzztouch.ImageBanner;
import com.airdsp.buzztouch.MraidView;
import com.airdsp.buzztouch.NetworkThread;
import com.airdsp.buzztouch.SetPreferences;
import com.airdsp.buzztouch.UserDetails;
import com.airdsp.buzztouch.Util;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;
import org.json.JSONException;
import org.json.JSONObject;

public class AdView
extends FrameLayout {
    private final String TAG = "AirMraid";
    boolean debug = false;
    private boolean isAnyIssue = false;
    public static final String BANNER_TYPE_IMAGE = "image";
    static final String BANNER_TYPE_TEXT = "text";
    public static final String BANNER_TYPE_MEDIUM_RECTANGLE = "medium_rectangle";
    public static final String BANNER_TYPE_RICH_MEDIA = "rich_media";
    public static final String BANNER_TYPE_IN_APP_AD = "inappad";
    public static final String PLACEMENT_TYPE_INLINE = "inline";
    public static final String PLACEMENT_TYPE_INTERSTITIAL = "interstitial";
    public static final String ANIMATION_TYPE_LEFT_TO_RIGHT = "left_to_right";
    public static final String ANIMATION_TYPE_TOP_DOWN = "top_down";
    public static final String ANIMATION_TYPE_FADE = "fade";
    static final int REFRESH_AD = 45;
    static final int TEXT_COLOR_DEFAULT = -1;
    static final int BACKGROUND_COLOR_DEFAULT = 0;
    static final int BANNER_WIDTH_TABLET = 728;
    static final int BANNER_WIDTH_MOBILE = 468;
    static final int BANNER_HEIGHT_TABLET = 90;
    static final int BANNER_HEIGHT_MOBILE = 60;
    static final int BANNER_MEDIUM_RECTANGLE_WIDTH = 300;
    static final int BANNER_MEDIUM_RECTANGLE_HEIGHT = 250;
    static final String AD_TYPE_BAU = "BAU";
    static final String AD_TYPE_BACM = "BACM";
    static final String AD_TYPE_BACC = "BACC";
    static AdCallbackListener.MraidCallbackListener adListener;
    private boolean isTestMode = false;
    private int adRefreshTime = 45;
    private String placementType;
    private boolean isAdRequestInProgress = false;
    private long lastAdfetchedTime = 0L;
    boolean canFetchAd = true;
    private Timer timer;
    private Thread adThread;
    FormatAds.ParseMraidJson parseMraidJson;
    private FormatAds.ParseBannerAd bannerAd;
    private int width = 468;
    private int height = 60;
    private int widthDp;
    private int heightDp;
    private List<View> oldViews = new ArrayList<View>();
    private String bannerAnimation = "fade";
    private String banner_type = "inappad";
    private Drawable bannerBgDrawable;
    private boolean canShowMR = false;
    private AnimationDrawListener animationDrawListener = new AnimationDrawListener(){

        @Override
        public void onAnimationDrawEnd() {
            AdView.this.handler.sendEmptyMessage(2);
        }
    };
    Handler handler = new Handler(){

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 0: {
                    AdView.this.setVisibility(0);
                    break;
                }
                case 8: {
                    AdView.this.setVisibility(8);
                    break;
                }
                case 4: {
                    AdView.this.setVisibility(4);
                    break;
                }
                case 2: {
                    AdView.this.removeOldViews();
                    break;
                }
            }
        }
    };
    AsyncTaskCompleteListener<Boolean> getDoc = new AsyncTaskCompleteListener<Boolean>(){

        @Override
        public void onTaskComplete(final Boolean result) {
            try {
                AdView.this.post(new Runnable(){

                    @Override
                    public void run() {
                        if (result.booleanValue()) {
                            AdView.this.loadRichMediaAd();
                        } else {
                            Log.e((String)"AirMraid", (String)"Not able to get mraid.");
                        }
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Override
        public void launchNewHttpTask() {
            Util.NativeMraid mraid = new Util.NativeMraid(AdView.this.getContext(), this);
            new Thread((Runnable)mraid, "native_mraid").start();
        }
    };

    public AdView(Activity activity, String banner_type, String placementType, boolean isTestMode, boolean canShowMRInAPP, String animationForBanner) {
        super((Context)activity);
        this.isTestMode = isTestMode;
        if (banner_type != null && (banner_type.equals(BANNER_TYPE_IMAGE) || banner_type.equals(BANNER_TYPE_TEXT) || banner_type.equals(BANNER_TYPE_RICH_MEDIA) || banner_type.equals(BANNER_TYPE_MEDIUM_RECTANGLE) || banner_type.equals(BANNER_TYPE_IN_APP_AD))) {
            this.banner_type = banner_type;
            Log.i((String)"AirMraid", (String)("Banner Type: " + banner_type));
        } else {
            this.banner_type = BANNER_TYPE_IN_APP_AD;
            Log.e((String)"AirMraid", (String)"Invalid banner type. Setting to default: inappad");
        }
        if (this.banner_type != null && this.banner_type.equals(BANNER_TYPE_RICH_MEDIA)) {
            if (placementType != null && (placementType.equals(PLACEMENT_TYPE_INLINE) || placementType.equals(PLACEMENT_TYPE_INTERSTITIAL))) {
                this.placementType = placementType;
            } else {
                this.placementType = PLACEMENT_TYPE_INLINE;
                Log.e((String)"AirMraid", (String)"Invalid placement type. Setting to default: inline");
            }
        }
        this.adRefreshTime = 45;
        this.canShowMR = canShowMRInAPP;
        this.bannerAnimation = animationForBanner != null ? animationForBanner : ANIMATION_TYPE_FADE;
        Log.i((String)"AirMraid", (String)"Initializing AdView ");
        if (!AirSDK.getDataFromManifest((Context)activity) || !AirSDK.checkRequiredPermission((Context)activity)) {
            this.isAnyIssue = true;
            return;
        }
        try {
            if (!Util.isIntentAvailable((Context)activity, BrowserActivity.class)) {
                Log.e((String)"AirMraid", (String)"Required BrowserActivty not found in Manifest please add.");
                this.isAnyIssue = true;
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setVisibility(8);
        UserDetails userDetails = new UserDetails((Context)activity);
        if (!userDetails.setImeiInMd5()) {
            if (adListener != null) {
                adListener.onErrorListener("Can not serve ad on this device. Device details not found.");
            }
            this.isAnyIssue = true;
            return;
        }
        new SetPreferences((Context)activity).setPreferencesData();
        this.bannerBgDrawable = this.getBackground();
        this.setClickable(true);
        this.setFocusable(true);
        this.setDescendantFocusability(131072);
        Util.setSESSION_ID();
        if (this.adThread == null || !this.adThread.isAlive()) {
            this.getAd();
        }
        Util.startBusense((Context)activity);
    }

    public AdView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        Log.i((String)"AirMraid", (String)"Initializing AdView from xml");
        if (attributeSet == null) {
            if (adListener != null) {
                adListener.onErrorListener("AttributeSet can not be null. If you are creating layout from dynamic code then use the other consturctor.");
            }
            Log.e((String)"AirMraid", (String)"AttributeSet can not be null. If you are creating layout from dynamic code then use the other consturctor.");
            this.isAnyIssue = true;
            return;
        }
        if (!AirSDK.getDataFromManifest(context) || !AirSDK.checkRequiredPermission(context)) {
            this.isAnyIssue = true;
            return;
        }
        this.setVisibility(8);
        try {
            if (!Util.isIntentAvailable(context, BrowserActivity.class)) {
                Log.e((String)"AirMraid", (String)"Required BrowserActivty not found in Manifest please add.");
                if (adListener != null) {
                    adListener.onErrorListener("Required BrowserActivty not found in Manifest please add.");
                }
                this.isAnyIssue = true;
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        UserDetails userDetails = new UserDetails(context);
        if (!userDetails.setImeiInMd5()) {
            if (adListener != null) {
                adListener.onErrorListener("Can not serve ad on this device. Device details not found.");
            }
            this.isAnyIssue = true;
            return;
        }
        new SetPreferences(context).setPreferencesData();
        this.bannerBgDrawable = this.getBackground();
        this.setClickable(true);
        this.setFocusable(true);
        this.setDescendantFocusability(131072);
        this.getAttrParameters(attributeSet);
        Util.setSESSION_ID();
        if (this.adThread == null || !this.adThread.isAlive()) {
            this.getAd();
        }
        Util.startBusense(context);
    }

    private void getAttrParameters(AttributeSet attributeSet) {
        try {
            if (attributeSet != null) {
                String packageName = "http://schemas.android.com/apk/res-auto";
                this.isTestMode = attributeSet.getAttributeBooleanValue(packageName, "test_mode", false);
                String banner_type = attributeSet.getAttributeValue(packageName, "banner_type");
                if (banner_type != null && (banner_type.equals(BANNER_TYPE_IMAGE) || banner_type.equals(BANNER_TYPE_RICH_MEDIA) || banner_type.equals(BANNER_TYPE_MEDIUM_RECTANGLE) || banner_type.equals(BANNER_TYPE_IN_APP_AD))) {
                    this.banner_type = banner_type;
                    Log.i((String)"AirMraid", (String)("Banner Type: " + banner_type));
                } else {
                    this.banner_type = BANNER_TYPE_IN_APP_AD;
                    Log.w((String)"AirMraid", (String)"Invalid banner type. Setting to default: inappad");
                }
                if (banner_type != null && banner_type.equals(BANNER_TYPE_RICH_MEDIA)) {
                    if (attributeSet.getAttributeValue(packageName, "placementType") != null) {
                        this.placementType = attributeSet.getAttributeValue(packageName, "placementType");
                    } else {
                        Log.w((String)"AirMraid", (String)"Invalid placement type. Setting to default placementType: inline.");
                        this.placementType = PLACEMENT_TYPE_INLINE;
                    }
                }
                this.bannerAnimation = attributeSet.getAttributeValue(packageName, "animation") != null ? attributeSet.getAttributeValue(packageName, "animation") : ANIMATION_TYPE_FADE;
                this.canShowMR = attributeSet.getAttributeBooleanValue(packageName, "canShowMR", false);
                this.adRefreshTime = 45;
            } else {
                Util.printDebugLog("AttributeSet is null. Using default parameters");
                this.banner_type = BANNER_TYPE_IN_APP_AD;
                this.canShowMR = false;
                this.bannerAnimation = ANIMATION_TYPE_FADE;
                this.adRefreshTime = 45;
                this.placementType = PLACEMENT_TYPE_INLINE;
                this.isTestMode = false;
            }
        }
        catch (Exception e) {
            Log.e((String)"AirMraid", (String)"Error occurred in adview", (Throwable)e);
        }
    }

    private void loadRichMediaAd() {
        try {
            this.setBackGround();
            if (this.parseMraidJson != null) {
                if (this.parseMraidJson.isHtmlAd() || this.parseMraidJson.isInlineScript() || this.parseMraidJson.isJsAd()) {
                    if (this.parseMraidJson.getTag() == null || this.parseMraidJson.equals("")) {
                        Log.i((String)"AirMraid", (String)"Tag data is null");
                        return;
                    }
                } else if (this.parseMraidJson.getAd_url() == null || this.parseMraidJson.equals("")) {
                    Log.i((String)"AirMraid", (String)"Ad url is null");
                    return;
                }
                Log.i((String)"AirMraid", (String)"Loading Mraid ad..");
                MraidView view = new MraidView(this.getContext(), this, adListener, this.handler, this.animationDrawListener);
                int childViewCounter = this.getChildCount();
                if (childViewCounter > 0) {
                    int i = 0;
                    while (i < childViewCounter) {
                        if (this.getChildAt(i) != null) {
                            this.oldViews.add(this.getChildAt(i));
                        }
                        ++i;
                    }
                }
                this.addView((View)view);
            } else {
                this.removeAllViews();
                this.setVisibility(8);
                Log.i((String)"AirMraid", (String)"Ad not loaded. Mraid data is null.");
                if (adListener != null) {
                    adListener.onErrorListener("Ad not loaded. Url is null.");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void loadBannerAd() {
        try {
            this.setBackGround();
            if (this.bannerAd != null) {
                if (this.bannerAd.isHtmlAd() || this.bannerAd.isInlineScript() || this.bannerAd.isJsAd() || this.bannerAd.isPlainUrl()) {
                    if (this.bannerAd.getTag().equals("")) {
                        Log.i((String)"AirMraid", (String)"Tag data is null");
                        return;
                    }
                } else if (this.bannerAd.getAdimage() == null || this.bannerAd.getAdimage().equals("")) {
                    Log.i((String)"AirMraid", (String)"image url is null");
                    return;
                }
                Log.i((String)"AirMraid", (String)"Loading banner ad");
                ImageBanner imageView = new ImageBanner(this.getContext().getApplicationContext(), this.widthDp, this.heightDp, this.handler, this.bannerAd, this.animationDrawListener, this.isTestMode, this);
                this.animateOldViews();
                this.addView((View)imageView);
                Animation animation = this.createAnimation(false);
                if (animation != null) {
                    imageView.startAnimation(animation);
                }
                Log.i((String)"AirMraid", (String)"Ad loaded successfully");
                if (adListener != null) {
                    adListener.onAdLoadedListener();
                }
            } else {
                this.removeAllViews();
                Log.i((String)"AirMraid", (String)"Ad not loaded. Banner data is null.");
                this.setVisibility(8);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void getAd() {
        if (!this.canFetchAd || this.debug) {
            Util.printDebugLog("Ad request is disabled.");
            return;
        }
        if (this.isAdRequestInProgress) {
            Log.i((String)"AirMraid", (String)"Ad request is already in progress.");
            if (adListener != null) {
                this.post(new Runnable(){

                    @Override
                    public void run() {
                        adListener.onErrorListener("Another ad request is already in progress. Please wait...");
                    }
                });
            }
            return;
        }
        if (System.currentTimeMillis() - this.lastAdfetchedTime < (long)this.adRefreshTime) {
            Log.i((String)"AirMraid", (String)"Ad requested beforing refresh time. Aborting request... ");
            if (adListener != null) {
                this.post(new Runnable(){

                    @Override
                    public void run() {
                        adListener.onErrorListener("Ad requested beforing refresh time. Aborting request... ");
                    }
                });
            }
            return;
        }
        AdView adView = this;
        synchronized (adView) {
            AsyncTaskCompleteListener<String> taskCompleteListener = new AsyncTaskCompleteListener<String>(){

                @Override
                public void launchNewHttpTask() {
                    AdView.this.isAdRequestInProgress = true;
                    String url = "";
                    if (AdView.this.banner_type != null && AdView.this.banner_type.equals(AdView.BANNER_TYPE_RICH_MEDIA)) {
                        url = "https://api.airpush.com/mraid/mraidadcall.php";
                        if (AdView.this.isTestMode) {
                            url = "https://api.airpush.com/mraid/adcall.php";
                        }
                    } else if (AdView.this.banner_type != null && AdView.this.banner_type.equals(AdView.BANNER_TYPE_IN_APP_AD)) {
                        url = "https://api.airpush.com/inappads/inappadcall.php";
                        if (AdView.this.isTestMode) {
                            url = "https://api.airpush.com/inappads/testinappadcall.php";
                        }
                    } else {
                        url = "https://api.airpush.com/bannerads/banneradcall.php";
                        if (AdView.this.isTestMode) {
                            url = "https://api.airpush.com/bannerads/testbanner.php";
                        }
                    }
                    ArrayList<NameValuePair> list = new ArrayList<NameValuePair>();
                    list.add((NameValuePair)new BasicNameValuePair("banner_type", AdView.this.banner_type));
                    list.add((NameValuePair)new BasicNameValuePair("supports", "" + Util.getSupportsJson(AdView.this.getContext())));
                    list.add((NameValuePair)new BasicNameValuePair("placement_type", AdView.this.placementType));
                    list.add((NameValuePair)new BasicNameValuePair("canShowMR", String.valueOf(AdView.this.canShowMR)));
                    NetworkThread networkThread = new NetworkThread(AdView.this.getContext(), this, list, url, 0L, true);
                    AdView.this.adThread = new Thread((Runnable)networkThread, "AdView");
                    AdView.this.adThread.start();
                }

                /*
                 * Unable to fully structure code
                 */
                @Override
                public void onTaskComplete(String result) {
                    block20: {
                        try {
                            Log.i((String)"AirMraid", (String)("Ad json:" + result));
                            AdView.access$9(AdView.this, System.currentTimeMillis());
                            if (result == null || result.equals("")) break block20;
                            jsonObject = new JSONObject(result);
                            v0 = jsonBannerType = jsonObject.isNull("banner_type") != false ? "" : jsonObject.getString("banner_type");
                            if (jsonBannerType == null || jsonBannerType.equals("")) {
                                Log.i((String)"AirMraid", (String)"No banner type present in response.");
                                staus = jsonObject.isNull("status") != false ? 0 : jsonObject.getInt("status");
                                message = jsonObject.isNull("message") != false ? "" : jsonObject.getString("message");
                                AdView.this.post(new Runnable(){

                                    @Override
                                    public void run() {
                                        AdView.this.validateStatusCode(staus, message);
                                    }
                                });
                                return;
                            }
                            if (!AdView.access$3(AdView.this).equals("inappad")) ** GOTO lbl44
                            if (!jsonBannerType.equals("rich_media")) ** GOTO lbl31
                            adtype = jsonObject.getString("adtype");
                            if (adtype.equals("MIT")) {
                                AdView.access$11(AdView.this, "interstitial");
                            } else if (adtype.equals("MIN")) {
                                AdView.access$11(AdView.this, "inline");
                            } else {
                                Log.i((String)"AirMraid", (String)"Invalid placement type for rich media.");
                                return;
                            }
                            try {
                                AdView.access$12(AdView.this, AdView.this.getContext(), jsonObject);
                                break block20;
lbl31:
                                // 1 sources

                                if (jsonBannerType.equals("image") || jsonBannerType.equals("text")) {
                                    AdView.access$13(AdView.this, jsonObject);
                                } else if (jsonBannerType.equals("medium_rectangle")) {
                                    if (AdView.access$6(AdView.this)) {
                                        AdView.access$13(AdView.this, jsonObject);
                                    } else {
                                        Log.w((String)"AirMraid", (String)"Can not show this ad.");
                                    }
                                } else {
                                    Log.i((String)"AirMraid", (String)("Invalid banner type in inappad json: " + jsonBannerType));
                                }
                                break block20;
lbl44:
                                // 1 sources

                                if (AdView.access$3(AdView.this).equals("rich_media")) {
                                    AdView.access$12(AdView.this, AdView.this.getContext(), jsonObject);
                                    break block20;
                                }
                                if (AdView.access$3(AdView.this).equals("image") || AdView.access$3(AdView.this).equals("text") || AdView.access$3(AdView.this).equals("medium_rectangle")) {
                                    AdView.access$13(AdView.this, jsonObject);
                                    break block20;
                                }
                                Log.i((String)"AirMraid", (String)("Invalid banner type in json: " + jsonBannerType));
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                        finally {
                            AdView.access$2(AdView.this, false);
                        }
                    }
                }
            };
            if (Util.checkInternetConnection(this.getContext())) {
                taskCompleteListener.launchNewHttpTask();
            } else if (adListener != null) {
                adListener.onErrorListener("Ad request failed. Internet connection not found.");
            }
        }
    }

    private void parseMraidJson(Context context, JSONObject result) {
        try {
            String doc;
            this.parseMraidJson = new FormatAds.ParseMraidJson(this.getContext(), result);
            if (this.parseMraidJson.getRefreshTime() > 0) {
                Log.i((String)"AirMraid", (String)"Refresh time changed.");
                this.adRefreshTime = this.parseMraidJson.getRefreshTime();
            }
            if ((doc = Util.getDoc(this.getContext())) != null && !doc.equals("")) {
                this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        AdView.this.loadRichMediaAd();
                    }
                });
            } else if (Util.checkInternetConnection(this.getContext())) {
                this.getDoc.launchNewHttpTask();
            }
        }
        catch (JSONException e) {
            Log.e((String)"AirMraid", (String)("JSONExection occured while parsing MRAID json: " + e.getMessage()));
        }
        catch (IOException e) {
            Log.e((String)"AirMraid", (String)"Message: ", (Throwable)e);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void parseBannerAd(JSONObject jsonObject) {
        try {
            String bt = jsonObject.getString("banner_type");
            this.resizeBanner(bt);
            this.bannerAd = new FormatAds.ParseBannerAd();
            if (this.bannerAd.isParseBannerAd(this.getContext(), jsonObject, this.banner_type)) {
                this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        AdView.this.loadBannerAd();
                    }
                });
                if (this.bannerAd.getRefreshTime() > 0) {
                    Log.i((String)"AirMraid", (String)"Refresh time changed.");
                    this.adRefreshTime = this.bannerAd.getRefreshTime();
                }
            }
        }
        catch (JSONException e) {
            Log.e((String)"AirMraid", (String)"JSONExection occured while parsing Banner ad json: ", (Throwable)e);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVisibility(int visibility) {
        int parentVisibility = super.getVisibility();
        if (parentVisibility != visibility) {
            AdView adView = this;
            synchronized (adView) {
                int childViewCounter = this.getChildCount();
                int i = 0;
                while (i < childViewCounter) {
                    View child = this.getChildAt(i);
                    child.setVisibility(visibility);
                    ++i;
                }
                super.setVisibility(visibility);
            }
        }
    }

    public void onWindowFocusChanged(boolean hasWindowFocus) {
        this.actionOnViewChanges(hasWindowFocus);
        super.onWindowFocusChanged(hasWindowFocus);
        this.getParent();
    }

    protected void onAttachedToWindow() {
        this.actionOnViewChanges(false);
        super.onAttachedToWindow();
    }

    protected void onDetachedFromWindow() {
        this.actionOnViewChanges(false);
        super.onDetachedFromWindow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void actionOnViewChanges(boolean isViewable) {
        AdView adView = this;
        synchronized (adView) {
            try {
                if (this.isAnyIssue) {
                    return;
                }
                if (isViewable) {
                    if (this.timer == null) {
                        this.timer = new Timer();
                        TimerTask task = new TimerTask(){

                            @Override
                            public void run() {
                                Util.printDebugLog("Getting new ad....");
                                AdView.this.getAd();
                            }
                        };
                        this.timer.scheduleAtFixedRate(task, (long)this.adRefreshTime * 1000L, (long)this.adRefreshTime * 1000L);
                    }
                } else if (this.timer != null) {
                    this.timer.cancel();
                    this.timer = null;
                    Log.i((String)"AirMraid", (String)"Lost foucus. Removing thread>>>");
                    this.canFetchAd = true;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void animateOldViews() {
        int childViewCounter = this.getChildCount();
        if (childViewCounter > 0) {
            Animation animation = this.createAnimation(true);
            int i = 0;
            while (i < childViewCounter) {
                if (animation != null && this.getChildAt(i) != null) {
                    this.getChildAt(i).setAnimation(animation);
                    this.oldViews.add(this.getChildAt(i));
                }
                ++i;
            }
        }
    }

    private Animation createAnimation(boolean isOutAnimation) {
        AlphaAnimation animation = null;
        if (isOutAnimation) {
            if (this.bannerAnimation != null && this.bannerAnimation.equals(ANIMATION_TYPE_FADE)) {
                animation = new AlphaAnimation(1.0f, 0.0f);
                animation.setDuration(700L);
            } else if (this.bannerAnimation != null && this.bannerAnimation.equals(ANIMATION_TYPE_LEFT_TO_RIGHT)) {
                animation = new TranslateAnimation(2, 0.0f, 2, 1.0f, 2, 0.0f, 2, 0.0f);
                animation.setDuration(900L);
                animation.setInterpolator((Interpolator)new AccelerateInterpolator());
            } else if (this.bannerAnimation != null && this.bannerAnimation.equals(ANIMATION_TYPE_TOP_DOWN)) {
                animation = new TranslateAnimation(2, 0.0f, 2, 0.0f, 2, 0.0f, 2, 1.0f);
                animation.setDuration(900L);
                animation.setInterpolator((Interpolator)new AccelerateInterpolator());
            }
        } else if (this.bannerAnimation != null && this.bannerAnimation.equals(ANIMATION_TYPE_FADE)) {
            animation = new AlphaAnimation(0.0f, 1.0f);
            animation.setDuration(1200L);
        } else if (this.bannerAnimation != null && this.bannerAnimation.equals(ANIMATION_TYPE_LEFT_TO_RIGHT)) {
            animation = new TranslateAnimation(2, -1.0f, 2, 0.0f, 2, 0.0f, 2, 0.0f);
            animation.setDuration(900L);
            animation.setInterpolator((Interpolator)new AccelerateInterpolator());
        } else if (this.bannerAnimation != null && this.bannerAnimation.equals(ANIMATION_TYPE_TOP_DOWN)) {
            animation = new TranslateAnimation(2, 0.0f, 2, 0.0f, 2, -1.0f, 2, 0.0f);
            animation.setDuration(900L);
            animation.setInterpolator((Interpolator)new AccelerateInterpolator());
        }
        return animation;
    }

    private void resizeBanner(String banner_type) {
        float widthRatio;
        float heightRatio;
        DisplayMetrics displayMetrics = this.getContext().getResources().getDisplayMetrics();
        float scale = displayMetrics.density;
        if (banner_type != null && banner_type.contains(BANNER_TYPE_IMAGE) || banner_type.contains(BANNER_TYPE_TEXT)) {
            if (Util.isTablet(this.getContext())) {
                this.height = (int)(scale * 90.0f + 0.5f);
                this.heightDp = 90;
                this.width = (int)(scale * 728.0f + 0.5f);
                this.widthDp = 728;
            } else {
                this.height = (int)(scale * 60.0f + 0.5f);
                this.heightDp = 60;
                this.width = (int)(scale * 468.0f + 0.5f);
                this.widthDp = 468;
            }
        } else if (banner_type != null && banner_type.contains(BANNER_TYPE_MEDIUM_RECTANGLE)) {
            this.height = (int)(scale * 250.0f + 0.5f);
            this.width = (int)(scale * 300.0f + 0.5f);
            this.heightDp = 250;
            this.widthDp = 300;
        }
        int tempHeight = this.height;
        int tempWidth = this.width;
        if (displayMetrics.heightPixels < this.height) {
            tempHeight = displayMetrics.heightPixels;
        }
        if (displayMetrics.widthPixels < this.width) {
            tempWidth = displayMetrics.widthPixels;
        }
        if ((heightRatio = (float)this.height / (float)tempHeight) > (widthRatio = (float)this.width / (float)tempWidth)) {
            this.width = (int)((float)this.width / heightRatio);
            this.widthDp = (int)((float)this.width / scale);
            Util.printDebugLog("if: " + heightRatio + " " + widthRatio + " " + this.width + " " + this.height + " " + this.widthDp + " " + this.heightDp);
        } else {
            this.width = tempWidth;
            this.widthDp = (int)((float)tempWidth / scale);
            Util.printDebugLog("else: " + heightRatio + " " + widthRatio + " " + this.width + " " + this.height + " " + this.widthDp + " " + this.heightDp);
        }
    }

    private void removeOldViews() {
        for (View view : this.oldViews) {
            this.removeView(view);
        }
    }

    protected void onConfigurationChanged(Configuration newConfig) {
        String banner_type;
        if (Build.VERSION.SDK_INT >= 8) {
            super.onConfigurationChanged(newConfig);
        }
        if (this.bannerAd != null && ((banner_type = this.bannerAd.getBanner_type()).equals(BANNER_TYPE_IMAGE) || banner_type.equals(BANNER_TYPE_TEXT) || banner_type.equals(BANNER_TYPE_MEDIUM_RECTANGLE))) {
            this.handler.sendEmptyMessage(2);
            this.resizeBanner(banner_type);
            this.loadBannerAd();
        }
    }

    private void setBackGround() {
        try {
            if (Build.VERSION.SDK_INT >= 16) {
                this.setBackground(this.bannerBgDrawable);
            } else {
                this.setBackgroundDrawable(this.bannerBgDrawable);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setAdListener(AdCallbackListener.MraidCallbackListener adListener) {
        AdView.adListener = adListener;
    }

    public AdCallbackListener.MraidCallbackListener getAdListener() {
        return adListener;
    }

    public String getBanner_type() {
        return this.banner_type;
    }

    public boolean isTestMode() {
        return this.isTestMode;
    }

    public int getAdRefreshTime() {
        return this.adRefreshTime;
    }

    public String getPlacementType() {
        return this.placementType;
    }

    public int getadWidth() {
        return this.width;
    }

    public int getadHeight() {
        return this.height;
    }

    private void validateStatusCode(int status, String message) {
        if (message == null || message.equals("")) {
            return;
        }
        switch (status) {
            case 100: {
                if (adListener != null) {
                    adListener.onErrorListener(message);
                    break;
                }
                Log.e((String)"AirMraid", (String)message);
                break;
            }
            case 120: {
                if (adListener != null) {
                    adListener.onErrorListener(message);
                    break;
                }
                Log.e((String)"AirMraid", (String)message);
                break;
            }
            case 130: {
                if (adListener != null) {
                    adListener.onErrorListener(message);
                    break;
                }
                Log.e((String)"AirMraid", (String)message);
                break;
            }
            case 204: {
                if (adListener == null) break;
                adListener.noAdAvailableListener();
                break;
            }
        }
    }

    static /* synthetic */ void access$9(AdView adView, long l) {
        adView.lastAdfetchedTime = l;
    }

    static /* synthetic */ void access$11(AdView adView, String string) {
        adView.placementType = string;
    }

    static /* synthetic */ void access$12(AdView adView, Context context, JSONObject jSONObject) {
        adView.parseMraidJson(context, jSONObject);
    }

    static /* synthetic */ void access$13(AdView adView, JSONObject jSONObject) {
        adView.parseBannerAd(jSONObject);
    }

    static interface AnimationDrawListener {
        public void onAnimationDrawEnd();
    }
}

