/*
 * Decompiled with CFR 0.152.
 */
package com.airdsp.buzztouch;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.webkit.CookieSyncManager;
import android.webkit.WebChromeClient;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.Toast;
import com.airdsp.buzztouch.CalendarEvent;
import com.airdsp.buzztouch.MraidView;
import com.airdsp.buzztouch.Util;

public class BrowserActivity
extends Activity
implements View.OnClickListener {
    static final String INTENT_ACTION_PLAY_VIDEO = "playVideo";
    static final String INTENT_ACTION_BROWSE = "browser";
    static final String INTENT_ACTION_CREATE_CALENDAR_EVENT = "newCalendarEvent";
    static final int CALENDER_CREATE_EVENT_REQUEST_CODE = 7;
    private static final int BUTTON_BACK_ID = 11;
    private static final int BUTTON_FORWARD_ID = 12;
    private static final int BUTTON_REFRESH_ID = 13;
    private static final int BUTTON_CLOSE_ID = 14;
    private float scale;
    private Button backButton;
    private Button forwardButton;
    private Button refreshButton;
    private Button closeButton;
    private BrowserView webView;
    private LinearLayout fullScreenLayout;
    private MraidView mraidView;
    Handler handler = new Handler(){

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 0: {
                    BrowserActivity.this.setContentView((View)BrowserActivity.this.mraidView);
                    BrowserActivity.this.mraidView.setVisibility(0);
                    Toast.makeText((Context)BrowserActivity.this, (CharSequence)"Ad is showing on screen.", (int)0).show();
                    break;
                }
                case -3: {
                    BrowserActivity.this.finish();
                    break;
                }
            }
        }
    };

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        try {
            Intent intent = this.getIntent();
            String action = intent.getAction();
            if (action.equals(INTENT_ACTION_BROWSE)) {
                String url = intent.getStringExtra("url");
                if (url.startsWith("market://") || url.startsWith("tel:")) {
                    Intent intent2 = new Intent("android.intent.action.VIEW", Uri.parse((String)url));
                    this.startActivity(intent2);
                    this.finish();
                } else {
                    this.showBrowser(url);
                }
            } else if (action.equals(INTENT_ACTION_PLAY_VIDEO)) {
                String url = intent.getStringExtra("url");
                this.requestWindowFeature(1);
                this.setTheme(0x1030010);
                super.onCreate(savedInstanceState);
                Intent intent1 = new Intent("android.intent.action.VIEW", Uri.parse((String)url));
                intent1.setDataAndType(Uri.parse((String)url), "video/*");
                this.startActivityForResult(intent1, 8);
            } else if (action.equals(INTENT_ACTION_CREATE_CALENDAR_EVENT)) {
                this.requestWindowFeature(1);
                this.setTheme(0x1030010);
                super.onCreate(savedInstanceState);
                try {
                    String json = intent.getStringExtra("json");
                    if (json == null || json.equals("")) {
                        MraidView.airpushMraidView.triggerErrorEvent("createCalendarEvent", "Calendar json is empty");
                        MraidView.airpushMraidView.canFetchAd(true);
                        this.finish();
                        return;
                    }
                    CalendarEvent.createCalenderEvent(this, json);
                }
                catch (ActivityNotFoundException e) {
                    e.printStackTrace();
                    MraidView.airpushMraidView.sendEventData("error");
                    MraidView.airpushMraidView.triggerErrorEvent("createCalendarEvent", "Calendar activity not found.");
                    MraidView.airpushMraidView.canFetchAd(true);
                    this.finish();
                }
                catch (Exception exception) {
                    MraidView.airpushMraidView.sendEventData("error");
                    exception.printStackTrace();
                    MraidView.airpushMraidView.triggerErrorEvent("createCalendarEvent", "Calendar json parsing error");
                    MraidView.airpushMraidView.canFetchAd(true);
                    this.finish();
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.finish();
        }
        catch (Throwable e) {
            e.printStackTrace();
            this.finish();
        }
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        try {
            if (requestCode == 7) {
                if (resultCode == -1) {
                    Util.printDebugLog("Calender event added");
                    MraidView.airpushMraidView.sendEventData("92");
                    MraidView.airpushMraidView.canFetchAd(true);
                    this.finish();
                } else if (resultCode == 0) {
                    MraidView.airpushMraidView.canFetchAd(true);
                    MraidView.airpushMraidView.triggerErrorEvent("createCalendarEvent", "Creating calendar event canceled by user.");
                    this.finish();
                } else {
                    this.finish();
                }
            }
            if (requestCode == 8) {
                if (resultCode == -1) {
                    Util.printDebugLog("Video played added");
                    MraidView.airpushMraidView.sendEventData("91");
                    MraidView.airpushMraidView.canFetchAd(true);
                    this.finish();
                } else if (resultCode == 0) {
                    MraidView.airpushMraidView.canFetchAd(true);
                    MraidView.airpushMraidView.triggerErrorEvent(INTENT_ACTION_PLAY_VIDEO, "Play video is canceled by user.");
                    this.finish();
                } else {
                    this.finish();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void showBrowser(String url) {
        this.requestWindowFeature(2);
        this.scale = this.getResources().getDisplayMetrics().density;
        try {
            if (url != null && !url.equals("")) {
                this.buildLayout(url);
            } else {
                Log.i((String)"AirSDK", (String)"Url is null.");
                this.finish();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.finish();
        }
    }

    private void buildLayout(String url) {
        this.fullScreenLayout = new LinearLayout((Context)this);
        this.fullScreenLayout.setOrientation(1);
        this.fullScreenLayout.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -1));
        RelativeLayout buttonLayout = new RelativeLayout((Context)this);
        RelativeLayout.LayoutParams buttonLayoutParams = new RelativeLayout.LayoutParams(-1, (int)(40.0f * this.scale));
        buttonLayout.setLayoutParams((ViewGroup.LayoutParams)buttonLayoutParams);
        this.backButton = new Button((Context)this);
        RelativeLayout.LayoutParams backParams = new RelativeLayout.LayoutParams(-2, -2);
        backParams.addRule(9, -1);
        backParams.addRule(15, -1);
        this.backButton.setLayoutParams((ViewGroup.LayoutParams)backParams);
        this.backButton.setText((CharSequence)"Back");
        this.backButton.setTypeface(null, 1);
        this.backButton.setTextColor(-1);
        this.backButton.setId(11);
        buttonLayout.addView((View)this.backButton);
        this.forwardButton = new Button((Context)this);
        RelativeLayout.LayoutParams forwardParams = new RelativeLayout.LayoutParams(-2, -2);
        forwardParams.addRule(1, 11);
        forwardParams.addRule(15, -1);
        this.forwardButton.setLayoutParams((ViewGroup.LayoutParams)forwardParams);
        this.forwardButton.setText((CharSequence)"Forward");
        this.forwardButton.setTypeface(null, 1);
        this.forwardButton.setTextColor(-1);
        this.forwardButton.setId(12);
        buttonLayout.addView((View)this.forwardButton);
        this.refreshButton = new Button((Context)this);
        RelativeLayout.LayoutParams refreshParams = new RelativeLayout.LayoutParams(-2, -2);
        refreshParams.addRule(1, 12);
        refreshParams.addRule(15, -1);
        this.refreshButton.setLayoutParams((ViewGroup.LayoutParams)refreshParams);
        this.refreshButton.setText((CharSequence)"Refresh");
        this.refreshButton.setTypeface(null, 1);
        this.refreshButton.setTextColor(-1);
        this.refreshButton.setId(13);
        buttonLayout.addView((View)this.refreshButton);
        this.closeButton = new Button((Context)this);
        RelativeLayout.LayoutParams closeParams = new RelativeLayout.LayoutParams(-2, -2);
        closeParams.addRule(11, -1);
        closeParams.addRule(15, -1);
        this.closeButton.setLayoutParams((ViewGroup.LayoutParams)closeParams);
        this.closeButton.setText((CharSequence)"Close");
        this.closeButton.setTypeface(null, 1);
        this.closeButton.setTextColor(-1);
        this.closeButton.setId(14);
        buttonLayout.addView((View)this.closeButton);
        buttonLayout.setGravity(17);
        this.fullScreenLayout.addView((View)buttonLayout);
        this.webView = new BrowserView((Context)this, url);
        LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-1, -1);
        this.webView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        this.fullScreenLayout.addView((View)this.webView);
        this.setContentView((View)this.fullScreenLayout);
        this.webView.loadUrl(url);
        this.backButton.setOnClickListener((View.OnClickListener)this);
        this.forwardButton.setOnClickListener((View.OnClickListener)this);
        this.refreshButton.setOnClickListener((View.OnClickListener)this);
        this.closeButton.setOnClickListener((View.OnClickListener)this);
        this.forwardButton.setEnabled(false);
        this.backButton.setEnabled(false);
    }

    public void onClick(View v) {
        switch (v.getId()) {
            case 11: {
                if (this.webView == null || !this.webView.canGoBack()) break;
                this.webView.goBack();
                break;
            }
            case 12: {
                if (this.webView == null || !this.webView.canGoForward()) break;
                this.webView.goForward();
                break;
            }
            case 13: {
                if (this.webView == null) break;
                this.webView.reload();
                break;
            }
            case 14: {
                this.finish();
                break;
            }
        }
    }

    public void onAttachedToWindow() {
        super.onAttachedToWindow();
        Window window = this.getWindow();
        window.setFormat(1);
    }

    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
    }

    protected void onPause() {
        super.onPause();
        try {
            CookieSyncManager.getInstance().stopSync();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void onResume() {
        super.onResume();
        try {
            CookieSyncManager.getInstance().startSync();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void onDestroy() {
        try {
            if (this.webView != null) {
                this.webView.stopLoading();
                this.fullScreenLayout.removeView((View)this.webView);
                this.webView.removeAllViews();
                this.webView.destroy();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        super.onDestroy();
    }

    public void onBackPressed() {
        try {
            if (this.getIntent().getAction().equals(INTENT_ACTION_PLAY_VIDEO)) {
                return;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        super.onBackPressed();
    }

    class BrowserView
    extends WebView {
        @SuppressLint(value={"SetJavaScriptEnabled"})
        public BrowserView(Context context, String url) {
            super(context);
            this.setHorizontalScrollBarEnabled(false);
            this.setVerticalScrollBarEnabled(false);
            this.setScrollBarStyle(0x2000000);
            this.setBackgroundColor(0);
            CookieSyncManager.createInstance((Context)BrowserActivity.this);
            CookieSyncManager.getInstance().startSync();
            this.getSettings().setJavaScriptEnabled(true);
            final BrowserActivity activity = BrowserActivity.this;
            this.setWebChromeClient(new WebChromeClient(){

                public void onProgressChanged(WebView view, int progress) {
                    activity.setTitle((CharSequence)"loading....");
                    activity.setProgress(progress * 100);
                    if (progress == 100) {
                        activity.setTitle((CharSequence)view.getUrl());
                    }
                }
            });
            this.setWebViewClient(new WebViewClient(){

                public void onPageFinished(WebView view, String url) {
                    super.onPageFinished(view, url);
                    if (view != null & view.canGoBack()) {
                        BrowserActivity.this.backButton.setEnabled(true);
                    } else {
                        BrowserActivity.this.backButton.setEnabled(false);
                    }
                    if (view != null & view.canGoForward()) {
                        BrowserActivity.this.forwardButton.setEnabled(true);
                    } else {
                        BrowserActivity.this.forwardButton.setEnabled(false);
                    }
                }

                public boolean shouldOverrideUrlLoading(WebView view, String url) {
                    if (url.startsWith("market://")) {
                        view.loadUrl(url);
                        return true;
                    }
                    return super.shouldOverrideUrlLoading(view, url);
                }

                public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
                    super.onReceivedError(view, errorCode, description, failingUrl);
                    Log.i((String)"AirSDK", (String)("Error code: " + errorCode + " ,description: " + description));
                    try {
                        Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)failingUrl));
                        BrowserActivity.this.startActivity(intent);
                        BrowserActivity.this.finish();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
        }
    }
}

