/*
 * Decompiled with CFR 0.152.
 */
package com.airdsp.buzztouch;

import android.content.Context;
import android.content.SharedPreferences;
import com.airdsp.buzztouch.AdCallbackListener;

class Caching {
    private final String AD_CACHING = "ad_cache";
    private SharedPreferences sharedPreferences;
    private SharedPreferences.Editor editor;

    public Caching(Context context) throws NullPointerException {
        this.sharedPreferences = context.getSharedPreferences("ad_cache", 0);
    }

    boolean saveJson(AdCallbackListener.AdType adType, String json) throws Exception {
        this.editor = this.sharedPreferences.edit();
        this.editor.putString("" + (Object)((Object)adType), json);
        return this.editor.commit();
    }

    boolean saveVideoJson(AdCallbackListener.AdType adType, String json, String videoUrl) throws Exception {
        this.editor = this.sharedPreferences.edit();
        this.editor.putString("" + (Object)((Object)adType), json);
        this.editor.putString("video_url", videoUrl);
        return this.editor.commit();
    }

    String getJson(AdCallbackListener.AdType adType) throws NullPointerException {
        return this.sharedPreferences.getString(adType.toString(), null);
    }

    String[] getVideoAdJson(AdCallbackListener.AdType adType) throws Exception {
        String[] v = new String[]{this.sharedPreferences.getString(adType.toString(), null), this.sharedPreferences.getString("video_url", null)};
        return v;
    }

    void deleteJson(AdCallbackListener.AdType adType) throws Exception {
        this.editor = this.sharedPreferences.edit();
        this.editor.remove("" + (Object)((Object)adType));
        this.editor.commit();
    }

    void deleteVideoJson(AdCallbackListener.AdType adType) throws Exception {
        this.editor = this.sharedPreferences.edit();
        this.editor.remove(adType.toString());
        this.editor.remove("video_url");
        this.editor.commit();
    }

    void setSmartWallAd(boolean ad) {
        this.editor = this.sharedPreferences.edit();
        this.editor.putBoolean("thisSmartWall", ad);
        this.editor.commit();
    }

    boolean isSmartwallAd() {
        return this.sharedPreferences.getBoolean("thisSmartWall", false);
    }
}

