/*
 * Decompiled with CFR 0.152.
 */
package com.airdsp.buzztouch;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.Intent;
import com.airdsp.buzztouch.Util;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

abstract class CalendarEvent {
    final String CALENDAR_ID = "id";
    final String CALENDAR_TITLE = "summary";
    final String LOCATION = "location";
    final String DESCRIPTION = "description";
    final String START_TIME = "start";
    final String END_TIME = "end";
    final String STATUS = "status";
    final String TRANSPARENCY = "transparency";
    final String RECURRENCE = "recurrence";
    final String REMINDER = "reminder";
    static final String EVENT_TRANSPARENCY = "transparency";
    static final String EVENT_RECURRENCE = "rrule";
    static final String EVENT_REMINDER = "reminder";

    CalendarEvent() {
    }

    @TargetApi(value=14)
    public static void createCalenderEvent(Activity activity, String jsonString) throws ActivityNotFoundException, Exception {
        JSONObject jsonObject = new JSONObject(jsonString);
        String id = jsonObject.isNull("id") ? "" : jsonObject.getString("id");
        String title = jsonObject.isNull("summary") ? "" : jsonObject.getString("summary");
        String location = jsonObject.isNull("location") ? "" : jsonObject.getString("location");
        String description = jsonObject.isNull("description") ? "" : jsonObject.getString("description");
        String start = jsonObject.isNull("start") ? "" : jsonObject.getString("start");
        String end = jsonObject.isNull("end") ? "" : jsonObject.getString("end");
        String status = jsonObject.isNull("status") ? "" : jsonObject.getString("status");
        String transparency = jsonObject.isNull(EVENT_TRANSPARENCY) ? "" : jsonObject.getString(EVENT_TRANSPARENCY);
        String reminder = jsonObject.isNull(EVENT_REMINDER) ? "" : jsonObject.getString(EVENT_REMINDER);
        String recurrenceJson = jsonObject.isNull("recurrence") ? "" : jsonObject.getString("recurrence");
        Recurrence recurrence = new Recurrence(recurrenceJson);
        Intent calIntent = new Intent("android.intent.action.INSERT");
        calIntent.setAction("android.intent.action.EDIT");
        calIntent.setType("vnd.android.cursor.item/event");
        calIntent.putExtra("calendar_id", id);
        calIntent.putExtra("title", title);
        calIntent.putExtra("eventLocation", location);
        calIntent.putExtra("description", description);
        calIntent.putExtra("beginTime", CalendarEvent.convertUTC(start));
        calIntent.putExtra("endTime", CalendarEvent.convertUTC(end));
        calIntent.putExtra("eventStatus", status);
        calIntent.putExtra(EVENT_TRANSPARENCY, transparency);
        calIntent.putExtra(EVENT_RECURRENCE, recurrence.getRrule());
        calIntent.putExtra("exdate", recurrence.getEXdate());
        try {
            if (reminder != null && !reminder.equals("")) {
                calIntent.putExtra("event_id", id);
                calIntent.putExtra("method", 0);
                if (reminder.startsWith("-")) {
                    calIntent.putExtra("minutes", reminder);
                } else {
                    calIntent.putExtra("minutes", CalendarEvent.convertUTC(reminder));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        activity.startActivityForResult(calIntent, 7);
    }

    static long convertUTC(String date) throws Exception {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
        formatter.setTimeZone(TimeZone.getTimeZone("UTC"));
        Date value = null;
        value = formatter.parse(date);
        System.out.println(value);
        SimpleDateFormat dateFormatter = new SimpleDateFormat();
        dateFormatter.setTimeZone(TimeZone.getTimeZone("UTC"));
        String dt = dateFormatter.format(value);
        long d = DateFormat.getInstance().parse(dt).getTime();
        return d;
    }

    public static class Recurrence {
        String[] days = new String[]{"SU", "MO", "TU", "WE", "TH", "FR", "SA"};
        final String RECURRENCE_FREQUENCY = "frequency";
        final String RECURRENCE_INTERVAL = "interval";
        final String RECURRENCE_EXPIRES = "expires";
        final String RECURRENCE_EXCEPTION_DATES = "exceptionDates";
        final String RECURRENCE_DAYS_IN_WEEK = "daysInWeek";
        final String RECURRENCE_DAYS_IN_MONTH = "daysInMonth";
        final String RECURRENCE_DAYS_IN_YEAR = "daysInYear";
        final String RECURRENCE_WEEKS_IN_MONTH = "weeksInMonth";
        final String RECURRENCE_MONTHS_IN_YEAR = "monthsInYear";
        String frequency;
        short interval;
        String expires;
        String[] exceptionDates;
        short[] daysInWeek;
        short[] daysInMonth;
        short[] daysInYear;
        short[] weeksInMonth;
        short[] monthsInYear;
        final JSONObject jsonObject;

        public Recurrence(String jsonString) throws NullPointerException, JSONException {
            JSONArray array;
            this.jsonObject = new JSONObject(jsonString);
            this.frequency = this.jsonObject.isNull("frequency") ? "" : this.jsonObject.getString("frequency");
            this.interval = this.jsonObject.isNull("interval") ? (short)0 : Short.parseShort(this.jsonObject.getString("interval"));
            this.expires = this.jsonObject.isNull("expires") ? "" : this.jsonObject.getString("expires");
            JSONArray jSONArray = array = this.jsonObject.isNull("exceptionDates") ? null : this.jsonObject.getJSONArray("exceptionDates");
            if (array != null) {
                this.exceptionDates = new String[array.length()];
                int i = 0;
                while (i < this.exceptionDates.length) {
                    this.exceptionDates[i] = array.getString(i);
                    ++i;
                }
            }
            this.daysInWeek = this.parseJson("daysInWeek");
            this.daysInMonth = this.parseJson("daysInMonth");
            this.daysInYear = this.parseJson("daysInYear");
            this.weeksInMonth = this.parseJson("weeksInMonth");
            this.monthsInYear = this.parseJson("monthsInYear");
        }

        final short[] parseJson(String key) throws NullPointerException, JSONException {
            JSONArray array;
            JSONArray jSONArray = array = this.jsonObject.isNull(key) ? null : this.jsonObject.getJSONArray(key);
            if (array != null) {
                short[] data = new short[array.length()];
                int i = 0;
                while (i < data.length) {
                    data[i] = (short)array.getInt(i);
                    ++i;
                }
                return data;
            }
            return null;
        }

        public String getDate(short[] any) {
            String data = "";
            int i = 0;
            while (i < any.length) {
                short d;
                if (i == 0) {
                    d = any[i];
                    data = this.days[d];
                } else {
                    d = any[i];
                    data = String.valueOf(data) + "," + this.days[d];
                }
                ++i;
            }
            return data;
        }

        public String getDate(String[] any) throws Exception {
            String data = "";
            int i = 0;
            while (i < any.length) {
                String dt;
                SimpleDateFormat format;
                Date date;
                SimpleDateFormat dateFormat;
                if (i == 0) {
                    dateFormat = new SimpleDateFormat("yyyy-MM-dd");
                    date = dateFormat.parse(any[i]);
                    System.out.println("dt: " + date);
                    format = new SimpleDateFormat("yyyyMMdd'T'HHmmss'Z'");
                    dt = format.format(date);
                    data = dt;
                } else {
                    dateFormat = new SimpleDateFormat("yyyy-MM-dd");
                    date = dateFormat.parse(any[i]);
                    System.out.println("dt: " + date);
                    format = new SimpleDateFormat("yyyyMMdd'T'HHmmss'Z'");
                    dt = format.format(date);
                    data = String.valueOf(data) + "," + dt;
                }
                ++i;
            }
            return data;
        }

        public String getDate(String any) throws Exception {
            String data = "";
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            Date date = dateFormat.parse(any);
            System.out.println("dt: " + date);
            SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd'T'HHmmss'Z'");
            data = format.format(date);
            return data;
        }

        String getEXdate() throws Exception {
            if (this.exceptionDates != null) {
                return this.getDate(this.exceptionDates);
            }
            return "";
        }

        public String getRrule() {
            StringBuilder builder = new StringBuilder();
            try {
                if (this.frequency != null && !this.frequency.equals("")) {
                    builder.append("FREQ=" + this.frequency + ";");
                }
                if (this.interval != 0) {
                    builder.append("INTERVAL=" + this.interval + ";");
                }
                if (this.expires != null && !this.expires.equals("")) {
                    builder.append("UNTIL=" + this.getDate(this.expires) + ";");
                }
                if (this.daysInWeek != null) {
                    builder.append("BYDAY=" + this.getDate(this.daysInWeek) + ";");
                }
                if (this.daysInMonth != null) {
                    builder.append("BYMONTHDAY=" + this.daysInMonth + ";");
                }
                if (this.daysInYear != null) {
                    builder.append("BYYEARDAY=" + this.daysInYear + ";");
                }
                if (this.weeksInMonth != null) {
                    builder.append("BYWEEKNO=" + this.weeksInMonth + ";");
                }
                if (this.monthsInYear != null) {
                    builder.append("BYMONTH=" + this.monthsInYear + ";");
                }
                Util.printDebugLog("Rrule: " + builder.toString());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return builder.toString();
        }
    }
}

