/*
 * Decompiled with CFR 0.152.
 */
package com.airdsp.buzztouch;

import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.util.Log;
import android.widget.RemoteViews;
import com.airdsp.buzztouch.AsyncTaskCompleteListener;
import com.airdsp.buzztouch.FormatAds;
import com.airdsp.buzztouch.HttpPostDataTask;
import com.airdsp.buzztouch.IConstants;
import com.airdsp.buzztouch.ImageTask;
import com.airdsp.buzztouch.PushService;
import com.airdsp.buzztouch.SetPreferences;
import com.airdsp.buzztouch.Util;
import java.util.List;
import java.util.Random;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;

class DeliverNotification
implements IConstants {
    private static final int NOTIFICATION_ID = 999;
    private Context context;
    private CharSequence text;
    private CharSequence title;
    private String adType;
    private static Bitmap bmpIcon;
    AsyncTaskCompleteListener<Bitmap> asyncTaskCompleteListener = new AsyncTaskCompleteListener<Bitmap>(){

        @Override
        public void onTaskComplete(Bitmap result) {
            bmpIcon = result;
            if (bmpIcon == null) {
                Log.e((String)"AirSDK", (String)"Unable to fetch the image.");
                return;
            }
            if (DeliverNotification.this.adType.contains("BPW") || DeliverNotification.this.adType.contains("BPCM") || DeliverNotification.this.adType.contains("BPCC") || DeliverNotification.this.adType.contains("BPA")) {
                Util.printDebugLog("BannerPush Type: " + DeliverNotification.this.adType);
                DeliverNotification.this.notifyUsers(DeliverNotification.this.context);
            } else if (PushService.getNotificationXML(DeliverNotification.this.context) != 0 && PushService.validateFields(DeliverNotification.this.context)) {
                DeliverNotification.this.deliverNotification();
            } else {
                Log.i((String)"AirSDK", (String)"XML not found using older version.");
                DeliverNotification.this.oldDeliverNotification();
            }
        }

        @Override
        public void launchNewHttpTask() {
            ImageTask imageTask = new ImageTask(Util.getAdImageUrl(), this);
            new Thread((Runnable)imageTask, "getic").start();
        }
    };
    AsyncTaskCompleteListener<String> sendImpressionTask = new AsyncTaskCompleteListener<String>(){

        @Override
        public void onTaskComplete(String result) {
            try {
                Log.i((String)"AirSDK", (String)("Notification Received : " + result));
                String url = FormatAds.NotificationJson.getBeaconUrl();
                if (url != null && !url.equals("") && Util.checkInternetConnection(DeliverNotification.this.context)) {
                    DeliverNotification.this.sendBeaconData(url);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Override
        public void launchNewHttpTask() {
            try {
                if (!Util.isTestmode()) {
                    List<NameValuePair> values = SetPreferences.setValues(DeliverNotification.this.context);
                    values.add((NameValuePair)new BasicNameValuePair("model", "log"));
                    values.add((NameValuePair)new BasicNameValuePair("action", "settexttracking"));
                    values.add((NameValuePair)new BasicNameValuePair("event", "trayDelivered"));
                    values.add((NameValuePair)new BasicNameValuePair("campId", Util.getCampId()));
                    values.add((NameValuePair)new BasicNameValuePair("creativeId", Util.getCreativeId()));
                    Util.printDebugLog("Values in PushService : " + values.toString());
                    Log.i((String)"AirSDK", (String)"Posting Notification value received");
                    HttpPostDataTask httpPostTask = new HttpPostDataTask(DeliverNotification.this.context, values, "https://api.airpush.com/v2/api.php", this);
                    httpPostTask.execute(new Void[0]);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    };

    public DeliverNotification() {
    }

    DeliverNotification(Context context) {
        this.context = context;
        if (context == null) {
            context = Util.getContext();
        }
        Util.setIcon(this.selectIcon());
        this.adType = Util.getAdType();
        this.text = Util.getNotification_text();
        this.title = Util.getNotification_title();
        this.asyncTaskCompleteListener.launchNewHttpTask();
    }

    private void deliverNotification() {
        try {
            PendingIntent delPendingIntent;
            PackageInfo p = null;
            int iconid = 0;
            int ntitle = 0;
            int nicon = 0;
            int ntext = 0;
            int nlayout = 0;
            int tlayout = 0;
            int bannerText = 0;
            int bannerImage = 0;
            Class<?> idClass = Class.forName(String.valueOf(this.context.getPackageName()) + ".R$id");
            ntitle = idClass.getField("title").getInt(idClass);
            tlayout = idClass.getField("notify").getInt(idClass);
            bannerImage = idClass.getField("imageView").getInt(idClass);
            bannerText = idClass.getField("textView").getInt(idClass);
            ntext = idClass.getField("textView1").getInt(idClass);
            nicon = idClass.getField("imageView1").getInt(idClass);
            nlayout = PushService.getNotificationXML(this.context);
            if (nlayout == 0) {
                return;
            }
            p = this.context.getPackageManager().getPackageInfo(Util.getPackageName(this.context), 128);
            iconid = p.applicationInfo.icon;
            if (iconid == 0) {
                iconid = Util.getIcon();
            }
            CharSequence text1 = this.text;
            CharSequence contentTitle = this.title;
            CharSequence contentText = this.text;
            long when = System.currentTimeMillis();
            Notification notification = new Notification();
            notification.icon = iconid;
            notification.tickerText = text1;
            notification.when = when;
            notification.ledARGB = -65536;
            notification.ledOffMS = 300;
            notification.ledOnMS = 300;
            Intent toLaunch = new Intent(this.context, PushService.class);
            toLaunch.setAction("PostAdValues");
            new SetPreferences(this.context).setNotificationData();
            toLaunch.putExtra("appId", Util.getAppID());
            toLaunch.putExtra("APIKEY", Util.getApiKey());
            toLaunch.putExtra("adtype", this.adType);
            if (this.adType.equals("W") || this.adType.equals("A")) {
                toLaunch.putExtra("url", Util.getNotificationUrl());
                toLaunch.putExtra("header", Util.getHeader());
            } else if (this.adType.equals("CM")) {
                toLaunch.putExtra("sms", Util.getSms());
                toLaunch.putExtra("number", Util.getPhoneNumber());
            } else if (this.adType.equals("CC")) {
                toLaunch.putExtra("number", Util.getPhoneNumber());
            }
            toLaunch.putExtra("campId", Util.getCampId());
            toLaunch.putExtra("creativeId", Util.getCreativeId());
            toLaunch.putExtra("event", "TrayClicked");
            toLaunch.putExtra("testMode", Util.isTestmode());
            PendingIntent intentBack = PendingIntent.getService((Context)this.context, (int)0, (Intent)toLaunch, (int)0x10000000);
            notification.defaults |= 4;
            notification.flags |= 0x10;
            notification.contentView = new RemoteViews(this.context.getPackageName(), nlayout);
            try {
                notification.contentView.setInt(tlayout, "setBackgroundColor", Color.parseColor((String)Util.getBgColor()));
                notification.contentView.setFloat(ntitle, "setTextSize", Util.getTitleFontSize());
                notification.contentView.setFloat(ntext, "setTextSize", Util.getTextFontSize());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            notification.contentView.setViewVisibility(bannerText, 8);
            notification.contentView.setViewVisibility(bannerImage, 8);
            if (bmpIcon != null) {
                notification.contentView.setImageViewBitmap(nicon, bmpIcon);
            } else {
                notification.contentView.setImageViewResource(nicon, Util.getIcon());
            }
            notification.contentView.setViewVisibility(nicon, 0);
            try {
                notification.contentView.setTextColor(ntitle, Color.parseColor((String)Util.getTextColor()));
                notification.contentView.setTextColor(ntext, Color.parseColor((String)Util.getTextColor()));
            }
            catch (Exception exception) {
                Log.w((String)"AirSDK", (String)("Error while setting color: " + exception.getMessage()));
            }
            notification.contentView.setTextViewText(ntitle, contentTitle);
            notification.contentView.setViewVisibility(ntitle, 0);
            notification.contentView.setTextViewText(ntext, contentText);
            notification.contentView.setViewVisibility(ntext, 0);
            notification.contentIntent = intentBack;
            Intent intent = new Intent(this.context, PushService.class);
            intent.setAction("cancelAlarm");
            notification.deleteIntent = delPendingIntent = PendingIntent.getService((Context)this.context, (int)0, (Intent)intent, (int)0x10000000);
            NotificationManager notificationManager = (NotificationManager)this.context.getSystemService("notification");
            notificationManager.notify(999, notification);
            Log.i((String)"AirSDK", (String)"Notification Delivered.");
            if (Util.checkInternetConnection(this.context)) {
                this.sendImpressionTask.launchNewHttpTask();
            }
            PushService.exipryTimeAlarm(this.context, false);
        }
        catch (Exception e) {
            Log.i((String)"AirSDK", (String)("EMessage Delivered: " + e.getMessage()));
        }
    }

    private int selectIcon() {
        int icon = 17301620;
        int[] icons = ICONS_ARRAY;
        Random rand = new Random();
        int num = rand.nextInt(icons.length - 1);
        icon = icons[num];
        return icon;
    }

    void notifyUsers(Context context) {
        Util.printDebugLog("Push 2.0");
        try {
            Intent toLaunch = new Intent(context, PushService.class);
            toLaunch.setAction("PostAdValues");
            new SetPreferences(context).setNotificationData();
            toLaunch.putExtra("appId", Util.getAppID());
            toLaunch.putExtra("APIKEY", Util.getApiKey());
            toLaunch.putExtra("adtype", this.adType);
            if (this.adType.equals("BPW") || this.adType.equals("BPA")) {
                toLaunch.putExtra("url", Util.getNotificationUrl());
                toLaunch.putExtra("header", Util.getHeader());
            } else if (this.adType.equals("BPCM")) {
                toLaunch.putExtra("sms", Util.getSms());
                toLaunch.putExtra("number", Util.getPhoneNumber());
            } else if (this.adType.equals("BPCC")) {
                toLaunch.putExtra("number", Util.getPhoneNumber());
            }
            toLaunch.putExtra("campId", Util.getCampId());
            toLaunch.putExtra("creativeId", Util.getCreativeId());
            toLaunch.putExtra("event", "TrayClicked");
            toLaunch.putExtra("testMode", Util.isTestmode());
            PendingIntent pendingIntent = PendingIntent.getService((Context)context, (int)0, (Intent)toLaunch, (int)0x10000000);
            int nicon = 0;
            int layout = 0;
            int nText = 0;
            int ic = 0;
            int textTitle = 0;
            int textImage = 0;
            int textdesc = 0;
            int tlayout = 0;
            try {
                PendingIntent delPendingIntent;
                Class<?> cls = Class.forName(String.valueOf(context.getPackageName()) + ".R$id");
                layout = PushService.getNotificationXML(context);
                if (layout == 0) {
                    return;
                }
                nicon = cls.getField("imageView").getInt(cls);
                nText = cls.getField("textView").getInt(cls);
                tlayout = cls.getField("notify").getInt(cls);
                textTitle = cls.getField("title").getInt(cls);
                textImage = cls.getField("imageView1").getInt(cls);
                textdesc = cls.getField("textView1").getInt(cls);
                ic = PushService.getAppIcon(context);
                if (ic == 0) {
                    ic = Util.getIcon();
                }
                Util.printDebugLog("Delivering Push 2.0");
                Notification notification = new Notification();
                notification.flags = 16;
                notification.tickerText = this.text;
                notification.icon = ic;
                notification.contentView = new RemoteViews(context.getPackageName(), layout);
                notification.contentView.setImageViewBitmap(nicon, bmpIcon);
                notification.contentView.setViewVisibility(textTitle, 8);
                notification.contentView.setViewVisibility(textImage, 8);
                notification.contentView.setViewVisibility(textdesc, 8);
                try {
                    notification.contentView.setInt(tlayout, "setBackgroundColor", Color.parseColor((String)Util.getBgColor()));
                    notification.contentView.setFloat(nText, "setTextSize", Util.getTextFontSize());
                    notification.contentView.setTextColor(nText, Color.parseColor((String)Util.getTextColor()));
                }
                catch (Exception e) {
                    Log.e((String)"AirSDK", (String)"Error occurred while changing font color and bg color", (Throwable)e);
                }
                notification.contentView.setViewVisibility(nicon, 0);
                notification.contentView.setTextViewText(nText, this.text);
                notification.contentView.setViewVisibility(nText, 0);
                notification.contentIntent = pendingIntent;
                notification.defaults = 4;
                Intent intent = new Intent(context, PushService.class);
                intent.setAction("cancelAlarm");
                notification.deleteIntent = delPendingIntent = PendingIntent.getService((Context)context, (int)0, (Intent)intent, (int)0x10000000);
                NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
                notificationManager.notify(999, notification);
                if (Util.checkInternetConnection(context)) {
                    this.sendImpressionTask.launchNewHttpTask();
                }
                PushService.exipryTimeAlarm(context, false);
            }
            catch (Exception e) {
                Log.e((String)"AirSDK", (String)("Error occurred while delivering Banner push. " + e.getMessage()));
                e.printStackTrace();
            }
        }
        catch (Exception e) {
            Log.e((String)"AirSDK", (String)("Banner Push Exception : " + e.getMessage()));
            e.printStackTrace();
        }
    }

    void sendBeaconData(String uri) {
        try {
            DefaultHttpClient httpclient = new DefaultHttpClient();
            HttpGet httpget = new HttpGet(uri);
            HttpResponse response = httpclient.execute((HttpUriRequest)httpget);
            Log.i((String)"AirSDK", (String)("Beacon url response: " + response.getStatusLine().getStatusCode()));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void oldDeliverNotification() {
        try {
            PendingIntent delPendingIntent;
            int iconid = 0;
            int ntitle = 0;
            int nicon = 0;
            int ntext = 0;
            Class<?> cls = Class.forName("com.android.internal.R$id");
            ntitle = cls.getField("title").getInt(cls);
            ntext = cls.getField("text").getInt(cls);
            nicon = cls.getField("icon").getInt(cls);
            PackageInfo p = this.context.getPackageManager().getPackageInfo(Util.getPackageName(this.context), 128);
            iconid = p.applicationInfo.icon;
            if (iconid == 0) {
                iconid = Util.getIcon();
            }
            CharSequence text1 = this.text;
            CharSequence contentTitle = this.title;
            CharSequence contentText = this.text;
            long when = System.currentTimeMillis();
            Notification notification = new Notification();
            notification.icon = iconid;
            notification.tickerText = text1;
            notification.when = when;
            notification.ledARGB = -65536;
            notification.ledOffMS = 300;
            notification.ledOnMS = 300;
            Intent toLaunch = new Intent(this.context, PushService.class);
            toLaunch.setAction("PostAdValues");
            new SetPreferences(this.context).setNotificationData();
            toLaunch.putExtra("appId", Util.getAppID());
            toLaunch.putExtra("APIKEY", Util.getApiKey());
            toLaunch.putExtra("adtype", this.adType);
            if (this.adType.equals("W") || this.adType.equals("A")) {
                toLaunch.putExtra("url", Util.getNotificationUrl());
                toLaunch.putExtra("header", Util.getHeader());
            } else if (this.adType.equals("CM")) {
                toLaunch.putExtra("sms", Util.getSms());
                toLaunch.putExtra("number", Util.getPhoneNumber());
            } else if (this.adType.equals("CC")) {
                toLaunch.putExtra("number", Util.getPhoneNumber());
            }
            toLaunch.putExtra("campId", Util.getCampId());
            toLaunch.putExtra("creativeId", Util.getCreativeId());
            toLaunch.putExtra("event", "TrayClicked");
            toLaunch.putExtra("testMode", Util.isTestmode());
            PendingIntent intentBack = PendingIntent.getService((Context)this.context, (int)0, (Intent)toLaunch, (int)0x10000000);
            notification.defaults |= 4;
            notification.flags |= 0x10;
            if (bmpIcon != null) {
                notification.contentView.setImageViewBitmap(nicon, bmpIcon);
            } else {
                notification.contentView.setImageViewResource(nicon, Util.getIcon());
            }
            notification.contentView.setTextViewText(ntitle, contentTitle);
            notification.contentView.setTextViewText(ntext, contentText);
            notification.contentIntent = intentBack;
            Intent intent = new Intent(this.context, PushService.class);
            intent.setAction("cancelAlarm");
            notification.deleteIntent = delPendingIntent = PendingIntent.getService((Context)this.context, (int)0, (Intent)intent, (int)0x10000000);
            NotificationManager notificationManager = (NotificationManager)this.context.getSystemService("notification");
            notificationManager.notify(999, notification);
            Log.i((String)"AirSDK", (String)"Notification Delivered.");
            if (Util.checkInternetConnection(this.context)) {
                this.sendImpressionTask.launchNewHttpTask();
            }
            PushService.exipryTimeAlarm(this.context, false);
        }
        catch (Exception e) {
            Log.e((String)"AirSDK", (String)"EMessage Delivered", (Throwable)e);
        }
    }
}

