/*
 * Decompiled with CFR 0.152.
 */
package com.airdsp.buzztouch;

import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.util.Log;
import com.airdsp.buzztouch.AsyncTaskCompleteListener;
import com.airdsp.buzztouch.DeliverNotification;
import com.airdsp.buzztouch.FormatAds;
import com.airdsp.buzztouch.HttpPostDataTask;
import com.airdsp.buzztouch.IConstants;
import com.airdsp.buzztouch.ImageTask;
import com.airdsp.buzztouch.PushService;
import com.airdsp.buzztouch.SetPreferences;
import com.airdsp.buzztouch.Util;
import java.util.List;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;

class Extras
implements IConstants,
AsyncTaskCompleteListener<Bitmap> {
    protected static final int NOTIFICATION_ID = 999;
    private Context context;
    private final String big_image_url;
    private final String optout;
    private final String adType;
    private Bitmap bannerBitmap;
    private Bitmap iconBitmap;
    private String icon_url;
    private NotificationManager notificationManager;
    private AsyncTaskCompleteListener<Bitmap> iconTaskCompleteListener = new AsyncTaskCompleteListener<Bitmap>(){

        @Override
        public void onTaskComplete(Bitmap result) {
            if (result != null) {
                Extras.this.iconBitmap = result;
                Extras.this.sendBigPictureStyleNotification();
            } else {
                Log.e((String)"AirSDK", (String)"Unable to fetch icon image");
            }
        }

        @Override
        public void launchNewHttpTask() {
            if (Extras.this.icon_url == null || Extras.this.icon_url.equals("")) {
                Log.e((String)"AirSDK", (String)"Icon image url is null");
                return;
            }
            new Thread((Runnable)new ImageTask(Extras.this.icon_url, this), "bpn_ic").start();
        }
    };
    private AsyncTaskCompleteListener<String> sendImpressionTaskCompleteListener = new AsyncTaskCompleteListener<String>(){

        @Override
        public void onTaskComplete(String result) {
            try {
                Log.i((String)"AirSDK", (String)("BPN Notification Received: " + result));
                String url = FormatAds.NotificationJson.getBeaconUrl();
                if (url != null && !url.equals("") && Util.checkInternetConnection(Extras.this.context)) {
                    new DeliverNotification().sendBeaconData(url);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @Override
        public void launchNewHttpTask() {
            try {
                if (!Util.isTestmode()) {
                    List<NameValuePair> values = SetPreferences.setValues(Extras.this.context);
                    values.add((NameValuePair)new BasicNameValuePair("model", "log"));
                    values.add((NameValuePair)new BasicNameValuePair("action", "settexttracking"));
                    values.add((NameValuePair)new BasicNameValuePair("event", "trayDelivered"));
                    values.add((NameValuePair)new BasicNameValuePair("campId", Util.getCampId()));
                    values.add((NameValuePair)new BasicNameValuePair("creativeId", Util.getCreativeId()));
                    Util.printDebugLog("Values in BPN impression : " + values.toString());
                    Log.i((String)"AirSDK", (String)"Posting BPN value received");
                    HttpPostDataTask httpPostTask = new HttpPostDataTask(Extras.this.context, values, "https://api.airpush.com/v2/api.php", this);
                    httpPostTask.execute(new Void[0]);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    };

    public Extras(Context context, String adtype, String optout, String icon_url) {
        this.context = context;
        this.big_image_url = Util.getAdImageUrl();
        this.icon_url = icon_url;
        this.adType = adtype;
        this.optout = optout;
    }

    public void sendBigPictureStyleNotification() {
        try {
            Intent toLaunch = new Intent(this.context, PushService.class);
            toLaunch.setAction("PostAdValues");
            new SetPreferences(this.context).setNotificationData();
            toLaunch.putExtra("appId", Util.getAppID());
            toLaunch.putExtra("APIKEY", Util.getApiKey());
            toLaunch.putExtra("adtype", this.adType);
            if (this.adType.equals("BPNW") || this.adType.equals("BPNA")) {
                toLaunch.putExtra("url", Util.getNotificationUrl());
                toLaunch.putExtra("header", Util.getHeader());
            } else if (this.adType.equals("BPNCM")) {
                toLaunch.putExtra("sms", Util.getSms());
                toLaunch.putExtra("number", Util.getPhoneNumber());
            } else if (this.adType.equals("BPNCC")) {
                toLaunch.putExtra("number", Util.getPhoneNumber());
            }
            toLaunch.putExtra("campId", Util.getCampId());
            toLaunch.putExtra("creativeId", Util.getCreativeId());
            toLaunch.putExtra("event", "TrayClicked");
            toLaunch.putExtra("testMode", Util.isTestmode());
            PendingIntent pi = PendingIntent.getService((Context)this.context, (int)0, (Intent)toLaunch, (int)0x10000000);
            Notification.Builder builder = new Notification.Builder(this.context);
            builder.setTicker((CharSequence)Util.getNotification_text());
            builder.setContentTitle((CharSequence)Util.getNotification_title());
            builder.setContentText((CharSequence)this.optout);
            builder.setSubText((CharSequence)"Please expand to view it.");
            builder.setWhen(System.currentTimeMillis());
            builder.setAutoCancel(true);
            builder.setContentIntent(pi);
            Intent intent = new Intent(this.context, PushService.class);
            intent.setAction("cancelAlarm");
            PendingIntent pendingIntent = PendingIntent.getService((Context)this.context, (int)0, (Intent)intent, (int)0x10000000);
            builder.setDeleteIntent(pendingIntent);
            builder.setSmallIcon(PushService.getAppIcon(this.context)).setLargeIcon(this.iconBitmap);
            Notification notification = new Notification.BigPictureStyle(builder).setBigContentTitle((CharSequence)Util.getNotification_title()).setSummaryText((CharSequence)Util.getNotification_text()).bigPicture(this.bannerBitmap).build();
            notification.flags |= 0x10;
            this.notificationManager = (NotificationManager)this.context.getSystemService("notification");
            this.notificationManager.notify(999, notification);
            if (Util.checkInternetConnection(this.context)) {
                this.sendImpressionTaskCompleteListener.launchNewHttpTask();
            }
            Log.i((String)"AirSDK", (String)"Big picture delivered.");
            PushService.exipryTimeAlarm(this.context, false);
        }
        catch (Exception exception) {
            Log.e((String)"AirSDK", (String)"An error occured while delivering big picture notification.");
        }
    }

    @Override
    public void launchNewHttpTask() {
        if (this.big_image_url == null || this.big_image_url.equals("")) {
            Log.e((String)"AirSDK", (String)"Big picture url is null");
            return;
        }
        if (Util.checkInternetConnection(this.context)) {
            new Thread((Runnable)new ImageTask(this.big_image_url, this), "bpn").start();
        }
    }

    @Override
    public void onTaskComplete(Bitmap result) {
        if (result != null) {
            this.bannerBitmap = result;
            if (Util.checkInternetConnection(this.context)) {
                this.iconTaskCompleteListener.launchNewHttpTask();
            }
        } else {
            Log.e((String)"AirSDK", (String)"Unable to fetch big image");
        }
    }
}

