/*
 * Decompiled with CFR 0.152.
 */
package com.airdsp.buzztouch;

import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.util.Log;
import com.airdsp.buzztouch.DeliverNotification;
import com.airdsp.buzztouch.Extras;
import com.airdsp.buzztouch.IConstants;
import com.airdsp.buzztouch.PushService;
import com.airdsp.buzztouch.SetPreferences;
import com.airdsp.buzztouch.Util;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.json.JSONException;
import org.json.JSONObject;

abstract class FormatAds
implements IConstants {
    private static final String STATUS_KEY = "status";
    private static final String URL_KEY = "url";
    private static final String ERROR_KEY = "error";

    FormatAds() {
    }

    static final class NotificationJson {
        String APP_NAME;
        String PACKAGE_NAME;
        private Context context;
        private long nextMessageCheckValue;
        private static String adType;
        private static String beaconUrl;

        public NotificationJson(Context context, String jsonString) {
            block7: {
                this.APP_NAME = "#APPNAME";
                this.PACKAGE_NAME = "#PACKAGENAME";
                this.context = context;
                this.nextMessageCheckValue = 14400000L;
                JSONObject json = null;
                if (jsonString.contains("nextmessagecheck")) {
                    try {
                        boolean isBlackListed;
                        json = new JSONObject(jsonString);
                        this.nextMessageCheckValue = this.getNextMessageCheckTime(json);
                        String string = adType = json.isNull("adtype") ? "invalid" : json.getString("adtype");
                        if (!adType.equals("invalid")) {
                            Util.setAdType(adType);
                            this.getAds(json);
                            break block7;
                        }
                        boolean bl = isBlackListed = json.isNull("isBlackListed") ? false : json.getBoolean("isBlackListed");
                        if (isBlackListed) {
                            SetPreferences.setDeviceBlacklisted(context);
                        }
                        SetPreferences.setSDKStartTime(context, this.nextMessageCheckValue);
                        PushService.reStartSDK(context, true);
                    }
                    catch (JSONException je) {
                        Util.printLog("Error in push JSON: " + je.getMessage());
                        Util.printDebugLog("Message Parsing.....Failed : " + je.toString());
                    }
                    catch (Exception e) {
                        Util.printLog("Epush parse: " + e.getMessage());
                    }
                } else {
                    Util.printDebugLog("nextmessagecheck is not present in json");
                }
            }
        }

        private long getNextMessageCheckTime(JSONObject json) {
            Long nextMsgCheckTime = 14400000L;
            try {
                nextMsgCheckTime = Long.parseLong(json.get("nextmessagecheck").toString()) * 1000L;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return nextMsgCheckTime;
        }

        /*
         * Unable to fully structure code
         */
        private void getAds(JSONObject json) {
            block31: {
                try {
                    title = json.isNull("title") != false ? "New Message" : json.getString("title");
                    text = json.isNull("text") != false ? "Click here for details!" : json.getString("text");
                    try {
                        if (title.contains(this.APP_NAME)) {
                            title = title.replace(this.APP_NAME, Util.getAppName(this.context));
                        }
                        if (title.contains(this.PACKAGE_NAME)) {
                            title = title.replace(this.PACKAGE_NAME, Util.getPackageName(this.context));
                        }
                        if (text.contains(this.APP_NAME)) {
                            text = text.replace(this.APP_NAME, Util.getAppName(this.context));
                        }
                        if (text.contains(this.PACKAGE_NAME)) {
                            text = text.replace(this.PACKAGE_NAME, Util.getPackageName(this.context));
                        }
                    }
                    catch (Exception var4_5) {
                        // empty catch block
                    }
                    creativeid = json.isNull("creativeid") != false ? "" : json.getString("creativeid");
                    campaignid = json.isNull("campaignid") != false ? "" : json.getString("campaignid");
                    Util.setNotification_title(title);
                    Util.setNotification_text(text);
                    Util.setCampId(campaignid);
                    Util.setCreativeId(creativeid);
                    if (NotificationJson.adType.equals("W") || NotificationJson.adType.equals("BPW") || NotificationJson.adType.equals("BPNW")) {
                        url = json.getString("url");
                        header = json.isNull("header") != false ? "Advertisment" : json.getString("header");
                        Util.setNotificationUrl(url);
                        Util.setHeader(header);
                    } else if (NotificationJson.adType.equals("A") || NotificationJson.adType.equals("BPA") || NotificationJson.adType.equals("BPNA")) {
                        url = json.isNull("url") != false ? "nothing" : json.getString("url");
                        header = json.isNull("header") != false ? "Advertisment" : json.getString("header");
                        Util.setNotificationUrl(url);
                        Util.setHeader(header);
                    } else if (NotificationJson.adType.equals("CM") || NotificationJson.adType.equals("BPCM") || NotificationJson.adType.equals("BPNCM")) {
                        number = json.isNull("number") != false ? "0" : json.getString("number");
                        sms = json.isNull("sms") != false ? "" : json.getString("sms");
                        Util.setPhoneNumber(number);
                        Util.setSms(sms);
                    } else if (NotificationJson.adType.equals("CC") || NotificationJson.adType.equals("BPCC") || NotificationJson.adType.equals("BPNCC")) {
                        number = json.isNull("number") != false ? "0" : json.getString("number");
                        Util.setPhoneNumber(number);
                    }
                    try {
                        textColor = json.isNull("textColor") != false ? "#000000" : json.getString("textColor");
                        bgColor = json.isNull("bgColor") != false ? "#FFFFFF" : json.getString("bgColor");
                        titleFontSize = json.isNull("titleFontSize") != false ? 12.0f : Float.valueOf(json.getString("titleFontSize")).floatValue();
                        textFontSize = json.isNull("textFontSize") != false ? 12.0f : Float.valueOf(json.getString("textFontSize")).floatValue();
                        Util.setTextColor(textColor);
                        Util.setBgColor(bgColor);
                        Util.setTitleFontSize(titleFontSize);
                        Util.setTextFontSize(textFontSize);
                    }
                    catch (Exception e) {
                        Log.e((String)"AirSDK", (String)"Error while parsing colors", (Throwable)e);
                    }
                    delivery_time = json.isNull("delivery_time") != false ? "0" : json.getString("delivery_time");
                    expirytime = json.isNull("expirytime") != false ? Long.parseLong("86400000") : json.getLong("expirytime");
                    adimageurl = json.isNull("adimage") != false ? "http://beta.airpush.com/images/adsthumbnail/48.png" : json.getString("adimage");
                    NotificationJson.beaconUrl = json.isNull("beacon") != false ? "" : json.getString("beacon");
                    Util.setDelivery_time(delivery_time);
                    Util.setExpiry_time(expirytime);
                    Util.setAdImageUrl(adimageurl);
                    if (!Util.getDelivery_time().equals(null) && !Util.getDelivery_time().equals("0")) {
                        format0 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                        format0.setTimeZone(TimeZone.getTimeZone("GMT"));
                        format0.format(new Date());
                    }
                    if (!NotificationJson.adType.equals("BPNW") && !NotificationJson.adType.equals("BPNA") && !NotificationJson.adType.equals("BPNCM") && !NotificationJson.adType.equals("BPNCC")) ** GOTO lbl82
                    icon = json.getString("icon");
                    v0 = optout = json.isNull("optout") != false ? "Optout: xapush.com, Ad by: " + Util.getAppName(this.context) : json.getString("optout");
                    if (Build.VERSION.SDK_INT < 16) ** GOTO lbl79
                    if (adimageurl.equals("") || adimageurl.equals("http://beta.airpush.com/images/adsthumbnail/48.png")) {
                        Log.w((String)"AirSDK", (String)"Invalid image url for this type.");
                        return;
                    }
                    try {
                        new Extras(this.context, NotificationJson.adType, optout, icon).launchNewHttpTask();
                        break block31;
lbl79:
                        // 1 sources

                        Log.e((String)"AirSDK", (String)"Can not serve ad on this mobile.");
                        break block31;
lbl82:
                        // 1 sources

                        new DeliverNotification(this.context);
                    }
                    catch (Exception e) {
                        Util.printLog("Push parsing error: " + e.getMessage());
                        Util.printDebugLog("Push Message Parsing.....Failed ");
                    }
                }
                finally {
                    try {
                        SetPreferences.setSDKStartTime(this.context, this.nextMessageCheckValue);
                        PushService.reStartSDK(this.context, true);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }

        public static String getBeaconUrl() {
            return beaconUrl;
        }
    }

    public static final class ParseBannerAd {
        private Context context;
        private String url;
        private String adimage;
        private String text;
        private String title;
        private String bannerType;
        private String adtype;
        private String creativeId;
        private String campaignId;
        private String textColor;
        private String banner_bg;
        private String sms;
        private String number;
        private boolean isErrorReport;
        private String api_url;
        private boolean isJsAd;
        private boolean isHtmlAd;
        private boolean isPlainUrl;
        private boolean isInlineScript;
        private int refreshTime;
        private String tag;

        boolean isParseBannerAd(Context context, JSONObject jsonObject, String bannerType) throws JSONException, Exception {
            this.context = context;
            Util.printDebugLog("Parsing banner json");
            String invalid = "invalid";
            this.isErrorReport = jsonObject.isNull(FormatAds.ERROR_KEY) ? false : jsonObject.getBoolean(FormatAds.ERROR_KEY);
            int status_code = jsonObject.isNull(FormatAds.STATUS_KEY) ? 0 : jsonObject.getInt(FormatAds.STATUS_KEY);
            String msg = jsonObject.isNull("message") ? invalid : jsonObject.getString("message");
            this.adtype = jsonObject.isNull("adtype") ? invalid : jsonObject.getString("adtype");
            this.bannerType = jsonObject.getString("banner_type");
            if (status_code == 200 && msg.equalsIgnoreCase("Success")) {
                String data;
                String string = data = jsonObject.isNull("data") ? "nodata" : jsonObject.getString("data");
                if (data.equals("nodata")) {
                    Log.i((String)"AirSDK", (String)"No data is not found in JSON.");
                    return false;
                }
                JSONObject jsonObject2 = new JSONObject(data);
                this.url = jsonObject2.isNull(FormatAds.URL_KEY) ? invalid : jsonObject2.getString(FormatAds.URL_KEY);
                this.title = jsonObject2.isNull("title") ? invalid : jsonObject2.getString("title");
                this.adimage = jsonObject2.isNull("adimage") ? "" : jsonObject2.getString("adimage");
                this.creativeId = jsonObject2.isNull("creativeid") ? "" : jsonObject2.getString("creativeid");
                this.campaignId = jsonObject2.isNull("campaignid") ? "" : jsonObject2.getString("campaignid");
                this.sms = jsonObject2.isNull("sms") ? "" : jsonObject2.getString("sms");
                this.number = jsonObject2.isNull("number") ? "" : jsonObject2.getString("number");
                this.banner_bg = jsonObject2.isNull("banner_bg") ? "#000000" : jsonObject2.getString("banner_bg");
                String string2 = this.textColor = jsonObject2.isNull("text_color") ? "#FFFFFF" : jsonObject2.getString("text_color");
                if (bannerType.endsWith("text")) {
                    if (this.textColor.equals("")) {
                        this.textColor = "#FFFFFF";
                        this.banner_bg = "#000000";
                        Log.w((String)"AirMraid", (String)"Text color missing");
                    }
                    if (this.banner_bg.equals("")) {
                        this.textColor = "#FFFFFF";
                        this.banner_bg = "#000000";
                        Log.w((String)"AirMraid", (String)"Banner bg missing");
                    }
                }
                this.text = jsonObject2.isNull("text") ? "" : jsonObject2.getString("text");
                this.api_url = jsonObject2.isNull("api_url") ? "" : jsonObject2.getString("api_url");
                int istag = jsonObject2.isNull("istag") ? 0 : jsonObject2.getInt("istag");
                switch (istag) {
                    case 0: {
                        this.isJsAd = false;
                        this.isHtmlAd = false;
                        this.isInlineScript = false;
                        this.isPlainUrl = false;
                        break;
                    }
                    case 1: {
                        this.isJsAd = false;
                        this.isHtmlAd = true;
                        this.isInlineScript = false;
                        this.isPlainUrl = false;
                        break;
                    }
                    case 2: {
                        this.isJsAd = true;
                        this.isHtmlAd = false;
                        this.isInlineScript = false;
                        this.isPlainUrl = false;
                        break;
                    }
                    case 3: {
                        this.isJsAd = false;
                        this.isHtmlAd = false;
                        this.isInlineScript = true;
                        this.isPlainUrl = false;
                        break;
                    }
                    case 4: {
                        this.isJsAd = false;
                        this.isHtmlAd = false;
                        this.isInlineScript = false;
                        this.isPlainUrl = true;
                        break;
                    }
                    default: {
                        this.isJsAd = false;
                        this.isHtmlAd = false;
                        this.isInlineScript = false;
                        this.isPlainUrl = false;
                    }
                }
                this.tag = jsonObject2.isNull("tag") ? "" : jsonObject2.getString("tag");
                this.refreshTime = jsonObject2.isNull("refreshtime") ? 45 : jsonObject2.getInt("refreshtime");
                return true;
            }
            return false;
        }

        public void handleClicks() {
            block18: {
                try {
                    if (this.adtype.equalsIgnoreCase("BAU")) {
                        Log.i((String)"AirSDK", (String)"Banner url Ads.....");
                        try {
                            try {
                                String packageName = "com.android.browser";
                                String className = "com.android.browser.BrowserActivity";
                                Intent internetIntent = new Intent("android.intent.action.VIEW", Uri.parse((String)this.url));
                                internetIntent.setFlags(0x10000000);
                                internetIntent.addFlags(0x800000);
                                internetIntent.addCategory("android.intent.category.LAUNCHER");
                                internetIntent.setClassName(packageName, className);
                                this.context.startActivity(internetIntent);
                                return;
                            }
                            catch (ActivityNotFoundException e) {
                                try {
                                    Log.i((String)"AirSDK", (String)"Browser not found.");
                                    Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)this.url));
                                    intent.setFlags(0x10000000);
                                    intent.addFlags(0x800000);
                                    this.context.startActivity(intent);
                                    break block18;
                                }
                                catch (ActivityNotFoundException e2) {
                                    Log.e((String)"AirSDK", (String)("Error whlie displaying url...: " + e2.getMessage()));
                                }
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        break block18;
                    }
                    if (this.adtype.equalsIgnoreCase("BACC")) {
                        Log.i((String)"AirSDK", (String)"Banner CC Ads.....");
                        try {
                            Uri uri = Uri.parse((String)("tel:" + this.number));
                            Intent intent = new Intent("android.intent.action.DIAL", uri);
                            intent.addFlags(0x10000000);
                            this.context.startActivity(intent);
                        }
                        catch (ActivityNotFoundException e) {
                            e.printStackTrace();
                        }
                        catch (Exception e) {}
                    } else if (this.adtype.equalsIgnoreCase("BACM")) {
                        try {
                            Log.i((String)"AirSDK", (String)"Banner CM Ads.....");
                            Intent intent = new Intent("android.intent.action.VIEW");
                            intent.addFlags(0x10000000);
                            intent.setType("vnd.android-dir/mms-sms");
                            intent.putExtra("address", this.number);
                            intent.putExtra("sms_body", this.sms);
                            this.context.startActivity(intent);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    } else {
                        Util.printLog("Invalid ad type for banner ad." + this.adtype);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }

        boolean isInlineScript() {
            return this.isInlineScript;
        }

        boolean isPlainUrl() {
            return this.isPlainUrl;
        }

        String getClick_url() {
            return this.url;
        }

        public String getAdimage() {
            return this.adimage;
        }

        String getText() {
            return this.text;
        }

        String getTitle() {
            return this.title;
        }

        String getBanner_type() {
            return this.bannerType;
        }

        String getAdtype() {
            return this.adtype;
        }

        String getCreativeId() {
            return this.creativeId;
        }

        String getCampaignId() {
            return this.campaignId;
        }

        String getTextColor() {
            return this.textColor;
        }

        String getBanner_bg() {
            return this.banner_bg;
        }

        String getSms() {
            return this.sms;
        }

        String getNumber() {
            return this.number;
        }

        boolean isErrorReport() {
            return this.isErrorReport;
        }

        public String getApi_url() {
            return this.api_url;
        }

        public boolean isJsAd() {
            return this.isJsAd;
        }

        public int getRefreshTime() {
            return this.refreshTime;
        }

        public boolean isHtmlAd() {
            return this.isHtmlAd;
        }

        public String getTag() {
            return this.tag;
        }
    }

    public static final class ParseMraidJson {
        private String ad_url;
        private boolean isInlineScript;
        private String campId;
        private String creativeId;
        private String guid;
        private boolean isErrorReporting;
        private String impression_url;
        private int refreshTime;
        private boolean isJsAd;
        private boolean isHtmlAd;
        private String tag;

        public ParseMraidJson(Context context, JSONObject jsonObject) throws JSONException, Exception {
            JSONObject dataJson;
            int status = jsonObject.getInt(FormatAds.STATUS_KEY);
            String message = jsonObject.getString("message");
            boolean bl = this.isErrorReporting = jsonObject.isNull(FormatAds.ERROR_KEY) ? false : jsonObject.getBoolean(FormatAds.ERROR_KEY);
            if (status == 200 && message.equalsIgnoreCase("Success")) {
                String data = jsonObject.getString("data");
                dataJson = new JSONObject(data);
                this.guid = dataJson.isNull("guid") ? "" : dataJson.getString("guid");
                this.ad_url = dataJson.isNull(FormatAds.URL_KEY) ? "" : dataJson.getString(FormatAds.URL_KEY);
                this.refreshTime = dataJson.isNull("refreshtime") ? 45 : dataJson.getInt("refreshtime");
                this.impression_url = dataJson.isNull("impurl") ? "" : dataJson.getString("impurl");
                int istag = dataJson.isNull("istag") ? 0 : dataJson.getInt("istag");
                switch (istag) {
                    case 0: {
                        this.isJsAd = false;
                        this.isHtmlAd = false;
                        this.isInlineScript = false;
                        break;
                    }
                    case 1: {
                        this.isJsAd = false;
                        this.isHtmlAd = true;
                        this.isInlineScript = false;
                        break;
                    }
                    case 2: {
                        this.isJsAd = true;
                        this.isHtmlAd = false;
                        this.isInlineScript = false;
                        break;
                    }
                    case 3: {
                        this.isJsAd = false;
                        this.isHtmlAd = false;
                        this.isInlineScript = true;
                        break;
                    }
                    default: {
                        this.isJsAd = false;
                        this.isHtmlAd = false;
                        this.isInlineScript = false;
                    }
                }
            } else {
                throw new IOException(message);
            }
            this.tag = dataJson.isNull("tag") ? "" : dataJson.getString("tag");
        }

        public String getTag() {
            return this.tag;
        }

        public boolean isHtmlAd() {
            return this.isHtmlAd;
        }

        public boolean isJsAd() {
            return this.isJsAd;
        }

        public String getAd_url() {
            return this.ad_url;
        }

        public boolean isInlineScript() {
            return this.isInlineScript;
        }

        public String getCampId() {
            return this.campId;
        }

        public String getCreativeId() {
            return this.creativeId;
        }

        public String getGuid() {
            return this.guid;
        }

        public boolean isErrorReporting() {
            return this.isErrorReporting;
        }

        public String getImpression_url() {
            return this.impression_url;
        }

        public int getRefreshTime() {
            return this.refreshTime;
        }
    }
}

