/*
 * Decompiled with CFR 0.152.
 */
package com.airdsp.buzztouch;

import android.content.Context;
import android.os.AsyncTask;
import android.util.Log;
import com.airdsp.buzztouch.AsyncTaskCompleteListener;
import com.airdsp.buzztouch.Util;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.util.List;
import java.util.zip.GZIPInputStream;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.NameValuePair;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.HttpEntityWrapper;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicHttpResponse;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;

final class HttpPostDataTask
extends AsyncTask<Void, Void, Boolean> {
    private final AsyncTaskCompleteListener<String> callback;
    private static final String HEADER_ACCEPT_ENCODING = "Accept-Encoding";
    private static final String ENCODING_GZIP = "gzip";
    private List<NameValuePair> valuePairs;
    private final String URL_TO_CALL;
    private String responseString;
    private Context mContext;

    public HttpPostDataTask(Context context, List<NameValuePair> values, String api_url, AsyncTaskCompleteListener<String> asyncTaskCompleteListener) {
        Util.printDebugLog("Calling URL:> " + api_url);
        this.mContext = context;
        this.valuePairs = values;
        this.URL_TO_CALL = api_url;
        this.callback = asyncTaskCompleteListener;
    }

    protected synchronized Boolean doInBackground(Void ... params) {
        if (Util.checkInternetConnection(this.mContext)) {
            try {
                HttpPost httpPost = new HttpPost(this.URL_TO_CALL);
                httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(this.valuePairs));
                BasicHttpParams httpParameters = new BasicHttpParams();
                int timeoutConnection = 7000;
                HttpConnectionParams.setConnectionTimeout((HttpParams)httpParameters, (int)timeoutConnection);
                int timeoutSocket = 7000;
                HttpConnectionParams.setSoTimeout((HttpParams)httpParameters, (int)timeoutSocket);
                DefaultHttpClient httpClient = new DefaultHttpClient((HttpParams)httpParameters);
                httpClient.addRequestInterceptor(new HttpRequestInterceptor(){

                    public void process(HttpRequest request, HttpContext context) {
                        if (!request.containsHeader(HttpPostDataTask.HEADER_ACCEPT_ENCODING)) {
                            request.addHeader(HttpPostDataTask.HEADER_ACCEPT_ENCODING, HttpPostDataTask.ENCODING_GZIP);
                        }
                    }
                });
                httpClient.addResponseInterceptor(new HttpResponseInterceptor(){

                    public void process(HttpResponse response, HttpContext context) {
                        HttpEntity entity = response.getEntity();
                        Header encoding = entity.getContentEncoding();
                        if (encoding != null) {
                            HeaderElement[] headerElementArray = encoding.getElements();
                            int n = headerElementArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                HeaderElement element = headerElementArray[n2];
                                if (element.getName().equalsIgnoreCase(HttpPostDataTask.ENCODING_GZIP)) {
                                    response.setEntity((HttpEntity)new InflatingEntity(response.getEntity()));
                                    break;
                                }
                                ++n2;
                            }
                        }
                    }
                });
                BasicHttpResponse httpResponse = (BasicHttpResponse)httpClient.execute((HttpUriRequest)httpPost);
                int code = httpResponse.getStatusLine().getStatusCode();
                Log.i((String)"AirSDK", (String)("Status Code: " + code));
                if (code == 200) {
                    this.responseString = EntityUtils.toString((HttpEntity)httpResponse.getEntity());
                    Util.printDebugLog("Response String:" + this.responseString);
                    if (this.responseString != null && !this.responseString.equals("")) {
                        return Boolean.TRUE;
                    }
                } else {
                    Log.i((String)"AirSDK", (String)("HTTP response Reason: " + httpResponse.getStatusLine().getReasonPhrase()));
                }
            }
            catch (SocketTimeoutException e) {
                Log.d((String)"SocketTimeoutException Thrown", (String)e.toString());
            }
            catch (ClientProtocolException e) {
                Log.d((String)"ClientProtocolException Thrown", (String)e.toString());
            }
            catch (MalformedURLException e) {
                Log.d((String)"MalformedURLException Thrown", (String)e.toString());
            }
            catch (IOException e) {
                Log.d((String)"IOException Thrown", (String)e.toString());
            }
            catch (Exception iex) {
                Log.d((String)"Exception Thrown: ", (String)iex.getMessage());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return Boolean.FALSE;
    }

    protected synchronized void onPostExecute(Boolean result) {
        try {
            if (result.booleanValue()) {
                this.callback.onTaskComplete(this.responseString);
            } else {
                this.callback.onTaskComplete(this.responseString);
                Util.printDebugLog("Call Failed due to Network error. ");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static class InflatingEntity
    extends HttpEntityWrapper {
        public InflatingEntity(HttpEntity wrapped) {
            super(wrapped);
        }

        public InputStream getContent() throws IOException {
            return new GZIPInputStream(this.wrappedEntity.getContent());
        }

        public long getContentLength() {
            return -1L;
        }
    }
}

