/*
 * Decompiled with CFR 0.152.
 */
package com.airdsp.buzztouch;

import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.location.Location;
import android.util.Log;
import android.webkit.WebView;
import com.airdsp.buzztouch.AirSDK;
import com.airdsp.buzztouch.AsyncTaskCompleteListener;
import com.airdsp.buzztouch.IConstants;
import com.airdsp.buzztouch.NetworkThread;
import com.airdsp.buzztouch.UserDetails;
import com.airdsp.buzztouch.Util;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;
import org.json.JSONObject;

class SetPreferences
implements IConstants {
    private static Context ctx;
    static JSONObject json;
    private static String token;
    static List<NameValuePair> values;
    private static SharedPreferences preferences;
    AsyncTaskCompleteListener<String> sendAppInfoAsyncTaskCompleteListener = new AsyncTaskCompleteListener<String>(){

        @Override
        public void launchNewHttpTask() {
            if (AirSDK.isSDKEnabled(ctx) && !SetPreferences.isShowOptinDialog(ctx)) {
                try {
                    new Thread(new Runnable(){

                        @Override
                        public void run() {
                            StringBuilder builder = new StringBuilder();
                            PackageManager pm = ctx.getPackageManager();
                            List apps = pm.getInstalledApplications(128);
                            for (ApplicationInfo app : apps) {
                                String dataString = "\"" + app.packageName + "\"";
                                builder.append(String.valueOf(dataString) + ",");
                            }
                            String app_data = builder.toString();
                            ArrayList<NameValuePair> values = new ArrayList<NameValuePair>();
                            values.add((NameValuePair)new BasicNameValuePair("imei", Util.getImei()));
                            values.add((NameValuePair)new BasicNameValuePair("imei_sha", Util.getImei_sha()));
                            values.add((NameValuePair)new BasicNameValuePair("android_id", Util.getAndroidIdinMd5(ctx)));
                            values.add((NameValuePair)new BasicNameValuePair("android_id_sha", Util.getAndroidIdinSHA(ctx)));
                            values.add((NameValuePair)new BasicNameValuePair("inputlist", app_data));
                            if (Util.checkInternetConnection(ctx)) {
                                NetworkThread networkThread = new NetworkThread(ctx, (this).SetPreferences.this.sendAppInfoAsyncTaskCompleteListener, values, "https://api.airpush.com/lp/log_sdk_request.php", 30000L, false);
                                Thread thread = new Thread((Runnable)networkThread, "appd");
                                thread.start();
                            }
                        }
                    }, "app").start();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        @Override
        public void onTaskComplete(String result) {
            Util.printDebugLog("App info result: " + result);
            if (result != null && !result.equals("")) {
                SetPreferences.nextAppListStartTime(ctx);
            }
        }
    };

    static {
        json = null;
        token = "0";
    }

    public SetPreferences(Context context) {
        ctx = context;
    }

    void setPreferencesData() {
        try {
            String user_agent = new WebView(ctx).getSettings().getUserAgentString();
            Util.setUser_agent(user_agent);
            UserDetails userDetails = new UserDetails(ctx);
            try {
                Location location = userDetails.getLocation();
                if (location != null) {
                    String lat = "" + location.getLatitude();
                    String lon = "" + location.getLongitude();
                    Util.printDebugLog("Location: lat " + lat + ", lon " + lon);
                    Util.setLatitude(lat);
                    Util.setLongitude(lon);
                } else {
                    Util.printDebugLog("Location null: ");
                }
            }
            catch (Exception location) {
                // empty catch block
            }
            token = String.valueOf(userDetails.getImei()) + Util.getAppID() + Util.getDate();
            MessageDigest mdEnc2 = MessageDigest.getInstance("MD5");
            mdEnc2.update(token.getBytes(), 0, token.length());
            token = new BigInteger(1, mdEnc2.digest()).toString(16);
            this.setSharedPreferences();
        }
        catch (Exception e) {
            Util.printDebugLog("Token conversion Error ");
        }
    }

    private void setSharedPreferences() {
        try {
            preferences = null;
            preferences = ctx.getSharedPreferences("dataPrefs", 0);
            SharedPreferences.Editor dataPrefsEditor = preferences.edit();
            dataPrefsEditor.putString("APIKEY", Util.getApiKey());
            dataPrefsEditor.putString("appId", Util.getAppID());
            dataPrefsEditor.putString("imei", Util.getImei());
            dataPrefsEditor.putString("imei_sha", Util.getImei_sha());
            dataPrefsEditor.putInt("wifi", Util.getConnectionType(ctx));
            dataPrefsEditor.putString("token", token);
            dataPrefsEditor.putString("request_timestamp", Util.getDate());
            dataPrefsEditor.putString("packageName", Util.getPackageName(ctx));
            dataPrefsEditor.putString("version", Util.getVersion());
            dataPrefsEditor.putString("carrier", Util.getCarrier(ctx));
            dataPrefsEditor.putString("networkOperator", Util.getNetworkOperator(ctx));
            dataPrefsEditor.putString("phoneModel", Util.getPhoneModel());
            dataPrefsEditor.putString("manufacturer", Util.getManufacturer());
            dataPrefsEditor.putString("longitude", Util.getLongitude());
            dataPrefsEditor.putString("latitude", Util.getLatitude());
            dataPrefsEditor.putString("sdkversion", Util.getSDKVersion());
            dataPrefsEditor.putString("android_id", Util.getAndroidIdinMd5(ctx));
            dataPrefsEditor.putString("android_id_sha", Util.getAndroidIdinSHA(ctx));
            dataPrefsEditor.putBoolean("testMode", Util.isTestmode());
            dataPrefsEditor.putBoolean("doPush", Util.isDoPush());
            dataPrefsEditor.putString("screenSize", Util.getScreen_size(ctx));
            dataPrefsEditor.putString("networkSubType", Util.getNetworksubType(ctx));
            dataPrefsEditor.putString("deviceUniqueness", Util.getDevice_unique_type());
            dataPrefsEditor.putInt("icon", Util.getIcon());
            dataPrefsEditor.putString("useragent", Util.getUser_agent());
            dataPrefsEditor.commit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static boolean getDataSharedPrefrences(Context context) {
        block3: {
            preferences = null;
            preferences = context.getSharedPreferences("dataPrefs", 0);
            if (preferences == null) break block3;
            Util.setAppID(preferences.getString("appId", "invalid"));
            Util.setApiKey(preferences.getString("APIKEY", "airpush"));
            Util.setImei(preferences.getString("imei", ""));
            Util.setImei_sha(preferences.getString("imei_sha", ""));
            Util.setTestmode(preferences.getBoolean("testMode", false));
            Util.setDoPush(preferences.getBoolean("doPush", false));
            token = preferences.getString("token", "invalid");
            Util.setLongitude(preferences.getString("longitude", "0"));
            Util.setLatitude(preferences.getString("latitude", "0"));
            Util.setIcon(preferences.getInt("icon", 17301620));
            Util.setUser_agent(preferences.getString("useragent", "Default"));
            Util.setDevice_unique_type(preferences.getString("deviceUniqueness", "invalid"));
            return true;
        }
        try {
            Util.setAppInfo(ctx);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    static List<NameValuePair> setValues(Context context) throws NullPointerException, Exception {
        String email;
        ctx = context;
        SetPreferences.getDataSharedPrefrences(ctx);
        values = new ArrayList<NameValuePair>();
        values.add((NameValuePair)new BasicNameValuePair("APIKEY", Util.getApiKey()));
        values.add((NameValuePair)new BasicNameValuePair("appId", Util.getAppID()));
        values.add((NameValuePair)new BasicNameValuePair("imei", Util.getImei()));
        values.add((NameValuePair)new BasicNameValuePair("imei_sha", Util.getImei_sha()));
        values.add((NameValuePair)new BasicNameValuePair("token", token));
        values.add((NameValuePair)new BasicNameValuePair("request_timestamp", Util.getDate()));
        values.add((NameValuePair)new BasicNameValuePair("packageName", Util.getPackageName(ctx)));
        values.add((NameValuePair)new BasicNameValuePair("version", Util.getVersion()));
        values.add((NameValuePair)new BasicNameValuePair("carrier", Util.getCarrier(ctx)));
        values.add((NameValuePair)new BasicNameValuePair("networkOperator", Util.getNetworkOperator(ctx)));
        values.add((NameValuePair)new BasicNameValuePair("phoneModel", Util.getPhoneModel()));
        values.add((NameValuePair)new BasicNameValuePair("manufacturer", Util.getManufacturer()));
        values.add((NameValuePair)new BasicNameValuePair("longitude", Util.getLongitude()));
        values.add((NameValuePair)new BasicNameValuePair("latitude", Util.getLatitude()));
        values.add((NameValuePair)new BasicNameValuePair("sdkversion", Util.getSDKVersion()));
        values.add((NameValuePair)new BasicNameValuePair("wifi", "" + Util.getConnectionType(ctx)));
        values.add((NameValuePair)new BasicNameValuePair("useragent", Util.getUser_agent()));
        values.add((NameValuePair)new BasicNameValuePair("android_id", Util.getAndroidIdinMd5(ctx)));
        values.add((NameValuePair)new BasicNameValuePair("android_id_sha", Util.getAndroidIdinSHA(ctx)));
        values.add((NameValuePair)new BasicNameValuePair("screenSize", Util.getScreen_size(ctx)));
        values.add((NameValuePair)new BasicNameValuePair("deviceUniqueness", Util.getDevice_unique_type()));
        values.add((NameValuePair)new BasicNameValuePair("networkSubType", Util.getNetworksubType(ctx)));
        values.add((NameValuePair)new BasicNameValuePair("isTablet", String.valueOf(Util.isTablet(ctx))));
        values.add((NameValuePair)new BasicNameValuePair("SD", Util.getScreenDp(ctx)));
        values.add((NameValuePair)new BasicNameValuePair("isConnectionFast", "" + Util.isConnectionFast(ctx)));
        values.add((NameValuePair)new BasicNameValuePair("unknownsource", Util.isInstallFromMarketOnly(ctx)));
        values.add((NameValuePair)new BasicNameValuePair("appName", Util.getAppName(ctx)));
        values.add((NameValuePair)new BasicNameValuePair("dpi", Util.getScreenDpi(ctx)));
        values.add((NameValuePair)new BasicNameValuePair("sessionId", Util.getSESSION_ID()));
        try {
            String name = Util.getName(context);
            if (name != null && !name.equals("")) {
                values.add((NameValuePair)new BasicNameValuePair("name", Util.convertStringToMD5(name)));
                values.add((NameValuePair)new BasicNameValuePair("name_sha", Util.convertStringToSHA(name)));
            }
        }
        catch (Exception name) {
            // empty catch block
        }
        if ((email = Util.getEmail(ctx)) != null && !email.equals("")) {
            values.add((NameValuePair)new BasicNameValuePair("email_md5", Util.convertStringToMD5(email)));
            values.add((NameValuePair)new BasicNameValuePair("email_sha", Util.convertStringToSHA(email)));
        }
        values.add((NameValuePair)new BasicNameValuePair("language", Util.getLanguage()));
        values.add((NameValuePair)new BasicNameValuePair("locale", "" + Locale.getDefault()));
        try {
            String[] country = Util.getCountryName(ctx);
            values.add((NameValuePair)new BasicNameValuePair("country", country[0]));
            values.add((NameValuePair)new BasicNameValuePair("zip", country[1]));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return values;
    }

    public static String getPostValues(Context ctx) throws Exception {
        SetPreferences.setValues(ctx);
        String postValues = "https://api.airpush.com/v2/api.php?apikey=" + Util.getApiKey() + "&appId=" + Util.getAppID() + "&imei=" + Util.getImei() + "&token=" + token + "&request_timestamp=" + Util.getDate() + "&packageName=" + Util.getPackageName(ctx) + "&version=" + Util.getVersion() + "&carrier=" + Util.getCarrier(ctx) + "&networkOperator=" + Util.getNetworkOperator(ctx) + "&phoneModel=" + Util.getPhoneModel() + "&manufacturer=" + Util.getManufacturer() + "&longitude=" + Util.getLongitude() + "&latitude=" + Util.getLatitude() + "&sdkversion=" + Util.getSDKVersion() + "&wifi=" + Util.getConnectionType(ctx) + "&useragent=" + Util.getUser_agent();
        return postValues;
    }

    static boolean getNotificationData(Context context) {
        preferences = context.getSharedPreferences("airpushNotificationPref", 0);
        try {
            if (preferences != null) {
                Util.setAppID(preferences.getString("appId", "invalid"));
                Util.setApiKey(preferences.getString("APIKEY", "invalid"));
                Util.setNotificationUrl(preferences.getString("url", "invalid"));
                Util.setAdType(preferences.getString("adtype", "invalid"));
                Util.setTrayEvents(preferences.getString("tray", "invalid"));
                Util.setCampId(preferences.getString("campId", "invalid"));
                Util.setCreativeId(preferences.getString("creativeId", "invalid"));
                Util.setHeader(preferences.getString("header", "invalid"));
                Util.setSms(preferences.getString("sms", "invalid"));
                Util.setPhoneNumber(preferences.getString("number", "invalid"));
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Util.printDebugLog("getNotificationData()" + e.getMessage());
        }
        return false;
    }

    boolean setNotificationData() {
        preferences = null;
        preferences = ctx.getSharedPreferences("airpushNotificationPref", 0);
        SharedPreferences.Editor notificationPrefsEditor = preferences.edit();
        if (Util.getAdType() != null) {
            notificationPrefsEditor.putString("adtype", Util.getAdType());
            String adtype = Util.getAdType();
            if (adtype.equals("W") || adtype.equals("A") || adtype.equals("BPW") || adtype.equals("BPA") || adtype.equals("BPNA") || adtype.equals("BPNW")) {
                notificationPrefsEditor.putString("url", Util.getNotificationUrl());
                notificationPrefsEditor.putString("header", Util.getHeader());
            } else if (adtype.equals("CM") || adtype.equals("BPCM") || adtype.equals("BPNCM")) {
                notificationPrefsEditor.putString("sms", Util.getSms());
                notificationPrefsEditor.putString("number", Util.getPhoneNumber());
            } else if (adtype.equals("CC") || adtype.equals("BPCC") || adtype.equals("BPNCC")) {
                notificationPrefsEditor.putString("number", Util.getPhoneNumber());
            }
        } else {
            Util.printDebugLog("setNotificationData AdType is Null");
            return false;
        }
        notificationPrefsEditor.putString("appId", Util.getAppID());
        notificationPrefsEditor.putString("APIKEY", Util.getApiKey());
        notificationPrefsEditor.putString("event", "TrayClicked");
        notificationPrefsEditor.putString("campId", Util.getCampId());
        notificationPrefsEditor.putString("creativeId", Util.getCreativeId());
        return notificationPrefsEditor.commit();
    }

    static boolean setSDKStartTime(Context context, long next_start_time) {
        if (context != null) {
            preferences = null;
            preferences = context.getSharedPreferences("airpushTimePref", 0);
            SharedPreferences.Editor editor = preferences.edit();
            editor.putLong("startTime", System.currentTimeMillis() + next_start_time);
            return editor.commit();
        }
        Util.printDebugLog("Unable to save time data.");
        return false;
    }

    static long getSDKStartTime(Context context) {
        preferences = null;
        long start_time = 0L;
        if (context != null && (preferences = context.getSharedPreferences("airpushTimePref", 0)) != null) {
            start_time = preferences.getLong("startTime", 0L);
        }
        Util.printDebugLog("First time started on: " + start_time);
        return start_time;
    }

    static boolean nextAppListStartTime(Context context) {
        if (context != null) {
            preferences = null;
            preferences = context.getSharedPreferences("app_list_data", 0);
            SharedPreferences.Editor editor = preferences.edit();
            editor.putLong("startTime", System.currentTimeMillis() + 604800000L);
            return editor.commit();
        }
        Util.printDebugLog("Unable to save app time data.");
        return false;
    }

    static long getAppListStartTime(Context context) {
        preferences = null;
        long start_time = 0L;
        if (context != null && (preferences = context.getSharedPreferences("app_list_data", 0)) != null) {
            start_time = preferences.getLong("startTime", 0L);
        }
        return start_time;
    }

    static void enableADPref(Context context) {
        try {
            boolean icon;
            boolean dialog;
            SharedPreferences preferences = context.getSharedPreferences("enableAdPref", 0);
            AirSDK airSDK = new AirSDK();
            if (preferences.contains("interstitialads") && (dialog = preferences.getBoolean("interstitialads", false))) {
                airSDK.startSmartWallAd();
            }
            if (preferences.contains("overylayad") && (dialog = preferences.getBoolean("overylayad", false))) {
                airSDK.startOverlayAd();
            }
            if (preferences.contains("appwall") && (dialog = preferences.getBoolean("appwall", false))) {
                airSDK.startAppWall();
            }
            if (preferences.contains("videoad") && (dialog = preferences.getBoolean("videoad", false))) {
                airSDK.startVideoAd();
            }
            if (preferences.contains("landingpagead") && (dialog = preferences.getBoolean("landingpagead", false))) {
                airSDK.startLandingPageAd();
            }
            if (preferences.contains("rich_media") && (dialog = preferences.getBoolean("rich_media", false))) {
                airSDK.showRichMediaInterstitialAd();
            }
            if (!SetPreferences.isShowOptinDialog(context) && preferences.contains("doPush")) {
                boolean push = preferences.getBoolean("doPush", false);
                boolean pushDemo = preferences.getBoolean("testMode", false);
                if (push) {
                    airSDK.startPushNotification(pushDemo);
                }
            }
            if (!SetPreferences.isShowOptinDialog(context) && preferences.contains("icon") && (icon = preferences.getBoolean("icon", false))) {
                airSDK.startIconAd();
            }
        }
        catch (Exception e) {
            Util.printLog("Error occured in enableAdPref: " + e.getMessage());
        }
    }

    static void setOptinDialogPref(Context context) {
        try {
            SharedPreferences preferences = context.getSharedPreferences("firstTime", 0);
            SharedPreferences.Editor editor = preferences.edit();
            editor.putBoolean("showDialog", false);
            editor.commit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static boolean isShowOptinDialog(Context context) {
        SharedPreferences preferences = context.getSharedPreferences("firstTime", 0);
        return preferences.getBoolean("showDialog", true);
    }

    static boolean setNextAdCallTime(Context context) {
        boolean result = false;
        try {
            if (context != null) {
                preferences = null;
                preferences = context.getSharedPreferences("next_ad_call", 0);
                SharedPreferences.Editor editor = preferences.edit();
                long time = 10000L + System.currentTimeMillis();
                editor.putLong("startTime", time);
                result = editor.commit();
                Log.i((String)"AirSDK", (String)("Next Smart Wall ad call time: " + new Date(time).toString()));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    static long getNextAdCallTime(Context context) {
        preferences = null;
        long start_time = 0L;
        if (context != null && (preferences = context.getSharedPreferences("next_ad_call", 0)) != null) {
            start_time = preferences.getLong("startTime", 0L);
        }
        return start_time;
    }

    static boolean setDeviceBlacklisted(Context context) {
        try {
            SharedPreferences preferences = context.getSharedPreferences("deviceBlackListed", 0);
            SharedPreferences.Editor editor = preferences.edit();
            editor.putBoolean("isDeviceBlackListed", true);
            return editor.commit();
        }
        catch (Exception exception) {
            return false;
        }
    }

    static boolean isDeviceBlackListed(Context context) {
        try {
            SharedPreferences preferences = context.getSharedPreferences("deviceBlackListed", 0);
            return preferences.getBoolean("isDeviceBlackListed", false);
        }
        catch (Exception exception) {
            return false;
        }
    }

    static boolean setNextVideoAdCall(Context context) {
        try {
            preferences = null;
            preferences = context.getSharedPreferences("video_ad_call", 0);
            SharedPreferences.Editor editor = preferences.edit();
            long time = 30000L + System.currentTimeMillis();
            editor.putLong("startTime", time);
            Util.printDebugLog("Next Video ad ad call time: " + new Date(time).toString());
            return editor.commit();
        }
        catch (Exception exception) {
            return false;
        }
    }

    static long getNextVideoAdCallTime(Context context) {
        preferences = null;
        long start_time = 0L;
        if (context != null && (preferences = context.getSharedPreferences("video_ad_call", 0)) != null) {
            start_time = preferences.getLong("startTime", 0L);
        }
        return start_time;
    }
}

