/*
 * Decompiled with CFR 0.152.
 */
package com.airdsp.buzztouch;

import android.content.ContentResolver;
import android.content.Context;
import android.content.SharedPreferences;
import android.location.Criteria;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationManager;
import android.net.wifi.WifiManager;
import android.os.Bundle;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import android.util.Log;
import com.airdsp.buzztouch.Util;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.UUID;

class UserDetails {
    private Context context;
    private Location location;

    public UserDetails(Context context) {
        this.context = context;
    }

    String getImei() {
        try {
            String imeinumber = ((TelephonyManager)this.context.getSystemService("phone")).getDeviceId();
            if (imeinumber == null || imeinumber.equals("")) {
                Class<?> c = Class.forName("android.os.SystemProperties");
                Method get = c.getMethod("get", String.class);
                imeinumber = (String)get.invoke(c, "ro.serialno");
                Util.setDevice_unique_type("SERIAL");
                if (imeinumber == null || imeinumber.equals("")) {
                    if (this.context.getPackageManager().checkPermission("android.permission.ACCESS_WIFI_STATE", Util.getPackageName(this.context)) == 0) {
                        WifiManager manager = (WifiManager)this.context.getSystemService("wifi");
                        System.out.println("WIFI " + manager.isWifiEnabled());
                        imeinumber = manager.getConnectionInfo().getMacAddress();
                        Util.setDevice_unique_type("WIFI_MAC");
                    } else {
                        imeinumber = new DeviceUuidFactory(this.context).getDeviceUuid().toString();
                        Util.setDevice_unique_type("UUID");
                    }
                }
            } else {
                Util.setDevice_unique_type("IMEI");
            }
            return imeinumber;
        }
        catch (Exception ignored) {
            ignored.printStackTrace();
            return "invalid";
        }
    }

    boolean setImeiInMd5() {
        String imeinumber;
        block4: {
            imeinumber = this.getImei();
            if (imeinumber != null && !imeinumber.equals("") && !imeinumber.equals("invalid")) break block4;
            Util.printDebugLog("Can not get device unique id.");
            return false;
        }
        try {
            MessageDigest mdEnc = MessageDigest.getInstance("MD5");
            mdEnc.update(imeinumber.getBytes(), 0, imeinumber.length());
            String imei = new BigInteger(1, mdEnc.digest()).toString(16);
            Util.setImei(imei);
            return this.setImeiInSHA();
        }
        catch (NoSuchAlgorithmException algorithmException) {
            Log.e((String)"AirSDK", (String)("Error occured while converting details in md5." + algorithmException.getMessage()));
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            Log.e((String)"AirSDK", (String)"Error occured while converting details in MD5.");
            return false;
        }
    }

    private boolean setImeiInSHA() {
        String imeinumber;
        block4: {
            imeinumber = this.getImei();
            if (imeinumber != null && !imeinumber.equals("") && !imeinumber.equals("invalid")) break block4;
            Util.printDebugLog("Can not get device unique id.");
            return false;
        }
        try {
            MessageDigest mdEnc = MessageDigest.getInstance("SHA-1");
            mdEnc.update(imeinumber.getBytes(), 0, imeinumber.length());
            String imei = new BigInteger(1, mdEnc.digest()).toString(16);
            Util.setImei_sha(imei);
            return true;
        }
        catch (NoSuchAlgorithmException algorithmException) {
            Log.e((String)"AirSDK", (String)("Error occured while converting details in SHA-1." + algorithmException.getMessage()));
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            Log.e((String)"AirSDK", (String)"Error occured while converting details in SHA-1.");
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Location getLocation() {
        Util.printDebugLog("fetching Location.");
        try {
            if (!Util.getLatitude().equals("0")) return null;
            if (Util.getLastLocationTime() + 900000L > System.currentTimeMillis()) {
                return null;
            }
            Context context = this.context;
            synchronized (context) {
                boolean ACCESS_FINE_LOACTION;
                if (!Util.getLatitude().equals("0") || Util.getLastLocationTime() + 900000L > System.currentTimeMillis()) {
                    Util.printDebugLog("failed in last");
                    return null;
                }
                boolean ACCESS_COARSE_LOCATION = this.context.getPackageManager().checkPermission("android.permission.ACCESS_COARSE_LOCATION", this.context.getPackageName()) == 0;
                boolean bl = ACCESS_FINE_LOACTION = this.context.getPackageManager().checkPermission("android.permission.ACCESS_FINE_LOCATION", this.context.getPackageName()) == 0;
                if (ACCESS_COARSE_LOCATION && ACCESS_FINE_LOACTION) {
                    LocationManager mlocManager = (LocationManager)this.context.getSystemService("location");
                    if (mlocManager == null) {
                        Util.printDebugLog("Location manager null");
                        return null;
                    }
                    Criteria criteria = new Criteria();
                    criteria.setCostAllowed(false);
                    String provider = null;
                    if (ACCESS_COARSE_LOCATION) {
                        criteria.setAccuracy(2);
                        provider = mlocManager.getBestProvider(criteria, true);
                    }
                    if (provider == null && ACCESS_FINE_LOACTION) {
                        criteria.setAccuracy(1);
                        provider = mlocManager.getBestProvider(criteria, true);
                    }
                    if (provider == null) {
                        Util.printDebugLog("Provider null");
                        return null;
                    }
                    this.location = mlocManager.getLastKnownLocation(provider);
                    if (this.location != null) {
                        Util.printDebugLog("Location found via get last known location.");
                        return this.location;
                    }
                    final LocationManager finalizedLocationManager = mlocManager;
                    Util.setLastLocationTime(System.currentTimeMillis());
                    mlocManager.requestLocationUpdates(provider, 0L, 0.0f, new LocationListener(){

                        public void onLocationChanged(Location location) {
                            Util.setLastLocationTime(System.currentTimeMillis());
                            UserDetails.this.location = location;
                            finalizedLocationManager.removeUpdates((LocationListener)this);
                        }

                        public void onProviderDisabled(String provider) {
                        }

                        public void onProviderEnabled(String provider) {
                        }

                        public void onStatusChanged(String provider, int status, Bundle extras) {
                        }
                    }, this.context.getMainLooper());
                } else {
                    Util.printDebugLog("Location permission not found.");
                }
                return this.location;
            }
        }
        catch (Exception e) {
            Util.printLog("Error occured while fetching location. " + e.getMessage());
            return this.location;
        }
        catch (Throwable e) {
            Log.e((String)"AirSDK", (String)("Error in location: " + e.getMessage()));
        }
        return this.location;
    }

    private class DeviceUuidFactory {
        protected static final String PREFS_FILE = "device_id.xml";
        protected static final String PREFS_DEVICE_ID = "device_id";
        protected UUID uuid;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public DeviceUuidFactory(Context context) {
            if (this.uuid != null) return;
            Class<DeviceUuidFactory> clazz = DeviceUuidFactory.class;
            synchronized (DeviceUuidFactory.class) {
                if (this.uuid != null) return;
                SharedPreferences prefs = context.getSharedPreferences(PREFS_FILE, 0);
                String id = prefs.getString(PREFS_DEVICE_ID, null);
                if (id != null) {
                    this.uuid = UUID.fromString(id);
                } else {
                    String androidId = Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
                    try {
                        String deviceId;
                        this.uuid = !"9774d56d682e549c".equals(androidId) ? UUID.nameUUIDFromBytes(androidId.getBytes("utf8")) : ((deviceId = ((TelephonyManager)context.getSystemService("phone")).getDeviceId()) != null ? UUID.nameUUIDFromBytes(deviceId.getBytes("utf8")) : UUID.randomUUID());
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new RuntimeException(e);
                    }
                    prefs.edit().putString(PREFS_DEVICE_ID, this.uuid.toString()).commit();
                }
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return;
            }
        }

        public UUID getDeviceUuid() {
            return this.uuid;
        }
    }
}

