/*
 * Decompiled with CFR 0.152.
 */
package com.airdsp.buzztouch;

import android.util.Log;
import com.airdsp.buzztouch.IVastConstant;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

class VastXmlParser
implements IVastConstant {
    private String namespace = null;
    private String id;
    private String version;
    private String adSytemName;
    private String adSystemVersion;
    private String adTitle;
    private String adId;
    private List<HashMap<String, String>> impression;
    private String adDescription;
    private String advertiserName;
    private String surveyUri;
    private String adErrorUri;
    private HashMap<String, String> pricing;
    private String extensions;
    private List<Creative> creativesList;

    void printLog(CharSequence charSequence) {
    }

    public VastXmlParser(Reader reader) throws VastException, InvalidVastXML, XmlPullParserException, Exception, Throwable {
        Log.i((String)"AirVast", (String)"Parsing vast Xml>>>>>>>..");
        this.creativesList = new ArrayList<Creative>();
        XmlPullParserFactory factory = XmlPullParserFactory.newInstance();
        factory.setNamespaceAware(true);
        XmlPullParser parser = factory.newPullParser();
        parser.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", false);
        parser.setInput(reader);
        parser.nextTag();
        parser.require(2, this.namespace, "VAST");
        this.version = parser.getAttributeValue(this.namespace, "version");
        Log.i((String)"AirVast", (String)("Vast version: " + this.version));
        parser.nextTag();
        String tag = parser.getName();
        if (tag.equals("Error")) {
            String code = parser.getAttributeValue(this.namespace, "status");
            String val = this.safeNextText(parser);
            this.printLog("Status: " + code + " Error: " + val);
            throw new VastException(val, code);
        }
        if (tag.equals("Ad")) {
            this.printLog("Inside ad tag");
            this.id = parser.getAttributeValue(this.namespace, "id");
            while (parser.next() != 3) {
                if (parser.getEventType() != 2) continue;
                String name = parser.getName();
                if (parser.isEmptyElementTag()) {
                    this.printLog("Empty Tag: " + name);
                    parser.nextTag();
                    continue;
                }
                if (name.equals("Error")) {
                    this.adErrorUri = this.safeNextText(parser);
                    this.printLog("Ad Error: " + this.adErrorUri);
                    continue;
                }
                if (name.equals("AdSystem")) {
                    this.adSystemVersion = parser.getAttributeValue(this.namespace, "version");
                    this.adSytemName = this.safeNextText(parser);
                    this.printLog("AdSytem version: " + this.adSystemVersion + ", name: " + this.adSytemName);
                    continue;
                }
                if (name.equals("AdTitle")) {
                    this.adTitle = this.safeNextText(parser);
                    this.printLog("Ad title: " + this.adTitle);
                    continue;
                }
                if (name.equals("Description")) {
                    this.adDescription = this.safeNextText(parser);
                    this.printLog("Desc :" + this.adDescription);
                    continue;
                }
                if (name.equals("Advertiser")) {
                    this.advertiserName = this.safeNextText(parser);
                    this.printLog("Advertise name: " + this.advertiserName);
                    continue;
                }
                if (name.equals("Servey")) {
                    this.surveyUri = this.safeNextText(parser);
                    this.printLog("Survey URI: " + this.surveyUri);
                    continue;
                }
                if (name.equals("Pricing")) {
                    this.pricing = new HashMap();
                    String model = parser.getAttributeValue(this.namespace, "model");
                    String currency = parser.getAttributeValue(this.namespace, "currency");
                    String am = this.safeNextText(parser);
                    this.pricing.put("model", model);
                    this.pricing.put("currency", currency);
                    this.pricing.put("Pricing", am);
                    this.printLog("model: " + model + ", cur: " + currency + ", price: " + am);
                    continue;
                }
                if (name.equals("Impression")) {
                    if (this.impression == null) {
                        this.impression = new ArrayList<HashMap<String, String>>();
                    }
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    String impressionId = parser.getAttributeValue(this.namespace, "id");
                    String impressionUri = this.safeNextText(parser);
                    hashMap.put("id", impressionId);
                    hashMap.put("Impression", impressionUri);
                    this.impression.add(hashMap);
                    this.printLog("Impression Id: " + impressionId + ", uri: " + impressionUri);
                    continue;
                }
                if (!name.equals("Creative")) continue;
                this.creativesList.add(new Creative(parser));
            }
        } else {
            throw new InvalidVastXML("Invalid vast XMl");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String safeNextText(XmlPullParser parser) throws XmlPullParserException, IOException {
        XmlPullParser xmlPullParser = parser;
        synchronized (xmlPullParser) {
            String result = parser.nextText();
            if (parser.getEventType() != 3) {
                parser.nextTag();
            }
            return result;
        }
    }

    public String getVersion() {
        return this.version;
    }

    public String getAdSytemName() {
        return this.adSytemName;
    }

    public String getAdSystemVersion() {
        return this.adSystemVersion;
    }

    public String getAdId() {
        return this.adId;
    }

    public String getAdTitle() {
        return this.adTitle;
    }

    public List<HashMap<String, String>> getImpression() {
        return this.impression;
    }

    public String getAdDescription() {
        return this.adDescription;
    }

    public String getAdvertiserName() {
        return this.advertiserName;
    }

    public String getServeyUri() {
        return this.surveyUri;
    }

    public String getAdErrorUri() {
        return this.adErrorUri;
    }

    public HashMap<String, String> getPricing() {
        return this.pricing;
    }

    public String getExtensions() {
        return this.extensions;
    }

    public List<Creative> getCreativesList() {
        return this.creativesList;
    }

    public String getId() {
        return this.id;
    }

    public String getSurveyUri() {
        return this.surveyUri;
    }

    public class Creative {
        private boolean isAdLinearSkipable;
        private String skipOffSet;
        private String id;
        private String sequence;
        private String creativeAdId;
        private String duration;
        private List<HashMap<String, Object>> icons;
        private HashMap<String, String> trackingEventMap;
        private String adParams;
        private String videoClickThrough;
        private List<HashMap<String, String>> videoClickTracking;
        private List<HashMap<String, String>> videoCustomClickTracking;
        private List<HashMap<String, Object>> mediaFiles;

        public Creative(XmlPullParser parser) throws XmlPullParserException, Exception, Throwable {
            VastXmlParser.this.printLog("Parsing Creative data");
            parser.require(2, VastXmlParser.this.namespace, "Creative");
            this.id = parser.getAttributeValue(VastXmlParser.this.namespace, "id");
            this.sequence = parser.getAttributeValue(VastXmlParser.this.namespace, "sequence");
            this.creativeAdId = parser.getAttributeValue(VastXmlParser.this.namespace, "AdID");
            while (parser.next() != 3) {
                if (parser.getEventType() != 2) continue;
                String name = parser.getName();
                VastXmlParser.this.printLog("Creative Name: " + name);
                if (parser.isEmptyElementTag()) {
                    VastXmlParser.this.printLog("Empty tag in creative: " + name);
                    parser.nextTag();
                    continue;
                }
                if (parser.getName().equals("Linear")) {
                    String offString = parser.getAttributeValue(VastXmlParser.this.namespace, "skipoffset");
                    if (offString == null) {
                        this.isAdLinearSkipable = false;
                        VastXmlParser.this.printLog("AdSkipable: " + this.isAdLinearSkipable);
                        continue;
                    }
                    this.isAdLinearSkipable = true;
                    this.skipOffSet = offString;
                    VastXmlParser.this.printLog("AdSkipable: " + this.isAdLinearSkipable + ", Skip offset: " + this.skipOffSet);
                    continue;
                }
                if (name.equals("Icon")) {
                    if (this.icons == null) {
                        this.icons = new ArrayList<HashMap<String, Object>>();
                    }
                    HashMap<String, Object> hashMap = new HashMap<String, Object>();
                    int width = this.parseInt(parser.getAttributeValue(VastXmlParser.this.namespace, "width"));
                    int height = this.parseInt(parser.getAttributeValue(VastXmlParser.this.namespace, "height"));
                    String program = parser.getAttributeValue(VastXmlParser.this.namespace, "program");
                    String xPosition = parser.getAttributeValue(VastXmlParser.this.namespace, "xPosition");
                    String yPosition = parser.getAttributeValue(VastXmlParser.this.namespace, "yPosition");
                    String duration = parser.getAttributeValue(VastXmlParser.this.namespace, "Duration");
                    String apiFramework = parser.getAttributeValue(VastXmlParser.this.namespace, "apiFramework");
                    String offset = parser.getAttributeValue(VastXmlParser.this.namespace, "offset");
                    VastXmlParser.this.printLog("ICON: width: " + width + ", height: " + height + ", program: " + program + ", xPosition: " + xPosition + ", duration:" + duration + ", apiFramework:" + apiFramework + ", offset:" + offset);
                    hashMap.put("width", width);
                    hashMap.put("height", height);
                    hashMap.put("program", program);
                    hashMap.put("xPosition", xPosition);
                    hashMap.put("yPosition", yPosition);
                    hashMap.put("apiFramework", apiFramework);
                    hashMap.put("Duration", duration);
                    hashMap.put("offset", offset);
                    while (parser.next() != 3) {
                        String icon;
                        if (parser.getEventType() != 2) continue;
                        String iconTag = parser.getName();
                        VastXmlParser.this.printLog("Icon Name: " + name);
                        if (parser.isEmptyElementTag()) {
                            VastXmlParser.this.printLog("Empty tag in creative: " + name);
                            parser.nextTag();
                            continue;
                        }
                        if (iconTag.equals("StaticResource")) {
                            String creativeType = parser.getAttributeValue(VastXmlParser.this.namespace, "creativeType");
                            String staticUrl = VastXmlParser.this.safeNextText(parser);
                            hashMap.put("creativeType", creativeType);
                            hashMap.put("StaticResource", staticUrl);
                            VastXmlParser.this.printLog("Creative type:" + creativeType + ", Static res: " + staticUrl);
                            continue;
                        }
                        if (iconTag.equals("IconClickThrough")) {
                            icon = VastXmlParser.this.safeNextText(parser);
                            hashMap.put("IconClickThrough", icon);
                            VastXmlParser.this.printLog("Icon click through: " + icon);
                            parser.nextTag();
                            continue;
                        }
                        if (iconTag.equals("IconClickTracking")) {
                            icon = VastXmlParser.this.safeNextText(parser);
                            hashMap.put("IconClickTracking", icon);
                            VastXmlParser.this.printLog("IconClickTracking: " + icon);
                            continue;
                        }
                        if (!iconTag.equals("IconViewTracking")) continue;
                        String iconView = VastXmlParser.this.safeNextText(parser);
                        hashMap.put("IconViewTracking", iconView);
                        VastXmlParser.this.printLog("IconViewTracking: " + iconView);
                    }
                    this.icons.add(hashMap);
                    parser.nextTag();
                    continue;
                }
                if (name.equals("Duration")) {
                    this.duration = VastXmlParser.this.safeNextText(parser);
                    VastXmlParser.this.printLog("Duration: " + this.duration);
                    continue;
                }
                if (name.equals("TrackingEvents")) {
                    VastXmlParser.this.printLog("inside tracking event.");
                    while (parser.next() != 3) {
                        if (parser.getEventType() != 2) continue;
                        String trackingNames = parser.getName();
                        if (parser.isEmptyElementTag()) {
                            VastXmlParser.this.printLog("Empty tag in tracking: " + trackingNames);
                            parser.nextTag();
                            continue;
                        }
                        if (!trackingNames.equals("Tracking")) continue;
                        if (this.trackingEventMap == null) {
                            this.trackingEventMap = new HashMap();
                        }
                        String id = parser.getAttributeValue(VastXmlParser.this.namespace, "event");
                        String val = VastXmlParser.this.safeNextText(parser);
                        this.trackingEventMap.put(id, val);
                        VastXmlParser.this.printLog("Tracking event: " + id + ", url: " + val);
                    }
                    continue;
                }
                if (name.equals("AdParameters")) {
                    this.adParams = VastXmlParser.this.safeNextText(parser);
                    VastXmlParser.this.printLog("AdParameters: " + this.adParams);
                    continue;
                }
                if (name.equals("VideoClicks")) {
                    while (parser.next() != 3) {
                        String tr;
                        String id;
                        HashMap<String, String> hashMap;
                        if (parser.getEventType() != 2) continue;
                        String videoClick = parser.getName();
                        if (parser.isEmptyElementTag()) {
                            VastXmlParser.this.printLog("Empty tag in creative: " + videoClick);
                            parser.nextTag();
                            continue;
                        }
                        if (videoClick.equals("ClickThrough")) {
                            this.videoClickThrough = VastXmlParser.this.safeNextText(parser);
                            VastXmlParser.this.printLog("Video click through url: " + this.videoClickThrough);
                            continue;
                        }
                        if (videoClick.equals("ClickTracking")) {
                            hashMap = new HashMap<String, String>();
                            id = parser.getAttributeValue(VastXmlParser.this.namespace, "id");
                            tr = VastXmlParser.this.safeNextText(parser);
                            hashMap.put("id", id);
                            hashMap.put("ClickTracking", tr);
                            if (this.videoClickTracking == null) {
                                this.videoClickTracking = new ArrayList<HashMap<String, String>>();
                            }
                            this.videoClickTracking.add(hashMap);
                            VastXmlParser.this.printLog("Video click tracking ID: " + id + ", url: " + tr);
                            continue;
                        }
                        if (!videoClick.equals("CustomClick")) continue;
                        hashMap = new HashMap();
                        id = parser.getAttributeValue(VastXmlParser.this.namespace, "id");
                        tr = VastXmlParser.this.safeNextText(parser);
                        hashMap.put("id", id);
                        hashMap.put("CustomClick", tr);
                        if (this.videoCustomClickTracking == null) {
                            this.videoCustomClickTracking = new ArrayList<HashMap<String, String>>();
                        }
                        this.videoCustomClickTracking.add(hashMap);
                        VastXmlParser.this.printLog("Video Custom click tracking ID: " + id + ", url: " + tr);
                    }
                    continue;
                }
                if (!name.equals("MediaFiles")) continue;
                while (parser.next() != 3) {
                    if (parser.getEventType() != 2) continue;
                    String mediaTag = parser.getName();
                    if (parser.isEmptyElementTag()) {
                        VastXmlParser.this.printLog("Empty tag in media: " + mediaTag);
                        parser.nextTag();
                        continue;
                    }
                    if (!mediaTag.equals("MediaFile")) continue;
                    String id = parser.getAttributeValue(VastXmlParser.this.namespace, "id");
                    String delivery = parser.getAttributeValue(VastXmlParser.this.namespace, "delivery");
                    String type = parser.getAttributeValue(VastXmlParser.this.namespace, "type");
                    int bitrate = this.parseInt(parser.getAttributeValue(VastXmlParser.this.namespace, "bitrate"));
                    int width = this.parseInt(parser.getAttributeValue(VastXmlParser.this.namespace, "width"));
                    int height = this.parseInt(parser.getAttributeValue(VastXmlParser.this.namespace, "height"));
                    boolean scalable = Boolean.parseBoolean(parser.getAttributeValue(VastXmlParser.this.namespace, "scalable"));
                    boolean maintainAspectRatio = Boolean.parseBoolean(parser.getAttributeValue(VastXmlParser.this.namespace, "maintainAspectRatio"));
                    String apiFramework = parser.getAttributeValue(VastXmlParser.this.namespace, "apiFramework");
                    String codec = parser.getAttributeValue(VastXmlParser.this.namespace, "codec");
                    int maxBitrate = this.parseInt(parser.getAttributeValue(VastXmlParser.this.namespace, "maxBitrate"));
                    int minBitrate = this.parseInt(parser.getAttributeValue(VastXmlParser.this.namespace, "minBitrate"));
                    String mediaUri = VastXmlParser.this.safeNextText(parser);
                    VastXmlParser.this.printLog("Media id: " + id + ", delivery: " + delivery + ", type: " + type + ", bitrate: " + bitrate + ", width: " + width + ", height: " + height + ", scalable: " + scalable + ", aspect ratio: " + maintainAspectRatio + ", apiFrameowrk: " + apiFramework + ", codec: " + codec + ", maxBitrate: " + maxBitrate + ", minBitrate: " + minBitrate + ", URI: " + mediaUri);
                    HashMap<String, Object> hashMap = new HashMap<String, Object>();
                    hashMap.put("id", id);
                    hashMap.put("delivery", delivery);
                    hashMap.put("type", type);
                    hashMap.put("bitrate", bitrate);
                    hashMap.put("width", width);
                    hashMap.put("height", height);
                    hashMap.put("scalable", scalable);
                    hashMap.put("maintainAspectRatio", maintainAspectRatio);
                    hashMap.put("apiFramework", apiFramework);
                    hashMap.put("codec", codec);
                    hashMap.put("maxBitrate", maxBitrate);
                    hashMap.put("minBitrate", minBitrate);
                    hashMap.put("MediaFile", mediaUri);
                    if (this.mediaFiles == null) {
                        this.mediaFiles = new ArrayList<HashMap<String, Object>>();
                    }
                    this.mediaFiles.add(hashMap);
                }
            }
        }

        public boolean isAdLinearSkipable() {
            return this.isAdLinearSkipable;
        }

        public String getSkipOffSet() {
            return this.skipOffSet;
        }

        public String getId() {
            return this.id;
        }

        public String getSequence() {
            return this.sequence;
        }

        public String getCreativeAdId() {
            return this.creativeAdId;
        }

        public String getDuration() {
            return this.duration;
        }

        public List<HashMap<String, Object>> getIcons() {
            return this.icons;
        }

        public HashMap<String, String> getTrackingEventMap() {
            return this.trackingEventMap;
        }

        public String getAdParams() {
            return this.adParams;
        }

        public String getVideoClickThrough() {
            return this.videoClickThrough;
        }

        public List<HashMap<String, String>> getVideoClickTracking() {
            return this.videoClickTracking;
        }

        public List<HashMap<String, String>> getVideoCustomClickTracking() {
            return this.videoCustomClickTracking;
        }

        public List<HashMap<String, Object>> getMediaFiles() {
            return this.mediaFiles;
        }

        private int parseInt(String value) {
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException numberFormatException) {
            }
            catch (Exception exception) {
                // empty catch block
            }
            return 0;
        }
    }

    public static class InvalidVastXML
    extends IOException {
        private static final long serialVersionUID = 1L;

        public InvalidVastXML(String message) {
            super(message);
        }
    }

    public static class VastException
    extends IOException {
        private static final long serialVersionUID = 1L;
        private int code;

        public VastException(String message, String code) {
            super(message);
            try {
                this.code = Integer.parseInt(code);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }

        public int getCode() {
            return this.code;
        }
    }
}

