/*
 * Decompiled with CFR 0.152.
 */
package com.airdsp.buzztouch;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.Typeface;
import android.media.AudioManager;
import android.media.MediaPlayer;
import android.net.Uri;
import android.os.Bundle;
import android.os.Environment;
import android.os.Handler;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebView;
import android.widget.Button;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.VideoView;
import com.airdsp.buzztouch.AdCallbackListener;
import com.airdsp.buzztouch.AirSDK;
import com.airdsp.buzztouch.AsyncTaskCompleteListener;
import com.airdsp.buzztouch.Caching;
import com.airdsp.buzztouch.HandleClicks;
import com.airdsp.buzztouch.IVastConstant;
import com.airdsp.buzztouch.ImageTask;
import com.airdsp.buzztouch.SmartWallActivity;
import com.airdsp.buzztouch.Util;
import com.airdsp.buzztouch.VastUtils;
import com.airdsp.buzztouch.VastXmlParser;
import com.airdsp.buzztouch.VideoAd;
import com.airdsp.buzztouch.Vpaid;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public class VideoAdActivity
extends Vpaid
implements View.OnClickListener,
MediaPlayer.OnPreparedListener,
MediaPlayer.OnCompletionListener,
MediaPlayer.OnErrorListener {
    private final String TAG = "AirVast";
    static final String ACTION_PLAY = "play_video";
    private static final int ID_ICON_IMAGE_VIEW = 102;
    private static final int ID_AD_INFO_TEXT_VIEW = 106;
    private static final int ID_PLAY_BUTTON = 107;
    private static final int ID_VIDEO_PLAYER = 108;
    private static final int ID_SEEK_BAR = 109;
    private static final int ID_SKIP_BUTTON = 110;
    private static final int ID_AD_PROGRESS_TEXT = 111;
    private static final int ID_MUTE_BUTTON = 112;
    private ProgressDialog dialog;
    private VastXmlParser vastXmlParser;
    private VideoView player;
    private boolean isErrorOccurred = true;
    private VastXmlParser.Creative creative;
    private Uri uri;
    private ProgressBar progressBar;
    private TextView adProgressTextView;
    private Button skipButton;
    private ImageButton playButton;
    private ImageButton muteButton;
    private boolean isPlaying = true;
    private int skipTime = 0;
    private boolean isMute = false;
    Handler handler;
    private int firstQuartile;
    private int secondQuartile;
    private int thirdQuartile;
    private int duration;
    View.OnTouchListener onTouchListener = new View.OnTouchListener(){

        public boolean onTouch(View v, MotionEvent event) {
            try {
                String url;
                if (v == VideoAdActivity.this.player && event.getAction() == 0 && (url = VideoAdActivity.this.creative.getVideoClickThrough()) != null && !url.equals("")) {
                    new HandleClicks(VideoAdActivity.this.getApplicationContext()).displayUrl(url);
                    VideoAdActivity.this.isErrorOccurred = false;
                    VideoAdActivity.this.dispatchEvent(Vpaid.VpaidEnum.AdClickThru);
                    VideoAdActivity.this.player.stopPlayback();
                    VideoAdActivity.this.finish();
                    return true;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                Log.e((String)"AirVast", (String)"Error occured while on video click", (Throwable)e);
                VideoAdActivity.this.isErrorOccurred = true;
                VideoAdActivity.this.stopAd(VideoAdActivity.this.ERROR_CODE_900);
            }
            return false;
        }
    };
    Runnable updateRunnable = new Runnable(){

        @Override
        public void run() {
            VideoAdActivity.this.updatePlayer(VideoAdActivity.this.isPlaying);
        }
    };

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.handler = new Handler();
        SmartWallActivity.setShowing(true);
        this.set = new HashSet();
        VideoAdActivity.setContext((Context)this);
        this.getWindow().setFormat(-3);
        this.getWindow().addFlags(128);
        try {
            this.setUserString(new WebView((Context)this).getSettings().getUserAgentString());
            Intent intent = this.getIntent();
            if (!intent.getAction().equals(ACTION_PLAY)) {
                this.finish();
                return;
            }
            this.uri = intent.getData();
            this.dispatchEvent(Vpaid.VpaidEnum.AdImpression);
            Util.printDebugLog("VideoAdActivty: url: " + this.uri);
            this.setRequestedOrientation(0);
            this.requestWindowFeature(1);
            this.getWindow().setFlags(1024, 1024);
            this.dialog = ProgressDialog.show((Context)this, null, (CharSequence)"Loading....");
            this.vastXmlParser = VideoAd.getVastXmlParser();
            this.setParser(this.vastXmlParser);
            List<VastXmlParser.Creative> creativeData = this.vastXmlParser.getCreativesList();
            if (creativeData != null && creativeData.size() > 0) {
                this.creative = creativeData.get(0);
                this.setCreative(this.creative);
                List<HashMap<String, Object>> mediaList = this.creative.getMediaFiles();
                HashMap<String, Object> media = mediaList.get(0);
                int bitrate = (Integer)media.get("bitrate");
                int width = (Integer)media.get("width");
                int height = (Integer)media.get("height");
                Object apiFrameWork = media.get("apiFramework");
                if (apiFrameWork != null && !apiFrameWork.equals("VPAID")) {
                    Log.e((String)"AirVast", (String)("Invalid apiFramwork: " + apiFrameWork));
                    this.sendErrorDetails(this.ERROR_CODE_901);
                    return;
                }
                this.initAd(width, height, "fullscreen", bitrate, this.creative.getAdParams(), null);
                return;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Log.e((String)"AirVast", (String)"Excetion occurred in video ad.", (Throwable)e);
        }
        if (this.dialog != null) {
            this.dialog.dismiss();
        }
        this.finish();
    }

    @Override
    void initAd(int width, int height, String viewMode, int desiredBitrate, String creativeData, String environmentVars) {
        try {
            VpaidLayout vpaidLayout = new VpaidLayout(this);
            this.setContentView((View)vpaidLayout);
            this.adProgressTextView = (TextView)this.findViewById(111);
            this.progressBar = (ProgressBar)this.findViewById(109);
            this.player = (VideoView)this.findViewById(108);
            this.skipButton = (Button)this.findViewById(110);
            this.skipButton.setOnClickListener((View.OnClickListener)this);
            this.playButton = (ImageButton)this.findViewById(107);
            this.playButton.setOnClickListener((View.OnClickListener)this);
            this.muteButton = (ImageButton)this.findViewById(112);
            this.muteButton.setOnClickListener((View.OnClickListener)this);
            this.player.setVideoURI(this.uri);
            this.player.setOnTouchListener(this.onTouchListener);
            this.player.setOnPreparedListener((MediaPlayer.OnPreparedListener)this);
            this.player.setOnCompletionListener((MediaPlayer.OnCompletionListener)this);
            this.player.setOnErrorListener((MediaPlayer.OnErrorListener)this);
            this.player.requestFocus();
            this.player.setKeepScreenOn(true);
            this.setVolumeControlStream(3);
            this.player.start();
            this.dispatchEvent(Vpaid.VpaidEnum.AdLoaded);
            return;
        }
        catch (Exception e) {
            Log.e((String)"AirVast", (String)"Exception occurred while initializing video", (Throwable)e);
        }
        catch (Throwable e) {
            Log.e((String)"AirVast", (String)"Error occurred while initializing video", (Throwable)e);
        }
        this.finish();
    }

    @Override
    void resizeAd(int width, int height, String viewMode) {
    }

    public void onPrepared(MediaPlayer mp) {
        try {
            if (this.dialog != null) {
                this.dialog.dismiss();
            }
            this.playButton.setBackgroundResource(17301539);
            if (this.creative.isAdLinearSkipable()) {
                String time = this.creative.getSkipOffSet();
                if (time == null || time.equals("") || time.equals("0:0:0") || time.equals("%")) {
                    this.isErrorOccurred = true;
                    this.stopAd(this.ERROR_CODE_100);
                    Log.e((String)"AirVast", (String)("Invalid skip offset: " + time));
                } else if (time.contains(":")) {
                    this.skipTime = (int)(VastUtils.convertTime(time) / 1000L);
                    this.skipButton.setText((CharSequence)("Skip in " + this.skipTime + "s"));
                } else if (time.contains("%")) {
                    time = time.replace("%", "");
                    int t1 = Integer.parseInt(time);
                    int duration = this.player.getDuration();
                    int t2 = duration * t1 / 100;
                    this.skipTime = t2 / 1000;
                    this.skipButton.setText((CharSequence)("Skip in " + this.skipTime + " sec"));
                } else {
                    this.isErrorOccurred = true;
                    this.stopAd(this.ERROR_CODE_100);
                    Log.e((String)"AirVast", (String)("Invalid skip offset: " + time));
                }
            }
            this.startAd();
        }
        catch (IllegalStateException e) {
            this.finish();
            e.printStackTrace();
        }
        catch (Exception e) {
            this.finish();
        }
    }

    @Override
    void startAd() {
        if (AirSDK.adCallbackListener != null) {
            AirSDK.adCallbackListener.onVideoAdShowing();
        }
        try {
            if (this.creative.isAdLinearSkipable()) {
                this.skipButton.setVisibility(0);
                this.skipButton.setEnabled(false);
            }
            this.duration = this.player.getDuration();
            this.progressBar.setMax(this.duration);
            this.setAdDuration(this.duration);
            this.calculateEvent(this.duration / 1000);
            this.isPlaying = true;
            this.handler.post(this.updateRunnable);
            this.dispatchEvent(Vpaid.VpaidEnum.AdVideoStart);
            return;
        }
        catch (Exception e) {
            Log.e((String)"AirVast", (String)"Exception occurred in start ad", (Throwable)e);
            this.finish();
        }
        catch (Throwable e) {
            Log.e((String)"AirVast", (String)"Error occurred in start ad", (Throwable)e);
        }
        this.isErrorOccurred = true;
        this.stopAd(this.ERROR_CODE_405);
    }

    private void updatePlayer(boolean play) {
        try {
            int duration;
            int curPostion;
            if (this.player != null && play && (curPostion = this.player.getCurrentPosition() / 1000) < (duration = this.player.getDuration() / 1000)) {
                if (this.creative.isAdLinearSkipable() && curPostion < this.skipTime) {
                    long l = this.skipTime - curPostion;
                    this.skipButton.setText((CharSequence)("Skip in " + l + "s"));
                }
                int remain = duration - curPostion;
                this.adProgressTextView.setText((CharSequence)("Ad: " + VastUtils.convertTime(remain)));
                if (this.creative.isAdLinearSkipable() && this.skipTime == curPostion) {
                    this.skipButton.setEnabled(true);
                    this.skipButton.setText((CharSequence)"Skip Ad");
                    this.skipButton.setClickable(true);
                }
                this.setAdRemainingTime(remain);
                this.progressBar.setProgress(this.player.getCurrentPosition());
                this.handler.postDelayed(this.updateRunnable, 1000L);
                if (this.firstQuartile == curPostion) {
                    this.dispatchEvent(Vpaid.VpaidEnum.AdVideoFirstQuartile);
                } else if (this.secondQuartile == curPostion) {
                    this.dispatchEvent(Vpaid.VpaidEnum.AdVideoMidpoint);
                } else if (this.thirdQuartile == curPostion) {
                    this.dispatchEvent(Vpaid.VpaidEnum.AdVideoThirdQuartile);
                }
            }
        }
        catch (Exception e) {
            Log.e((String)"AirVast", (String)"Exception occurred in updatePlayer", (Throwable)e);
        }
        catch (Throwable e) {
            Log.e((String)"AirVast", (String)"Error occurred in updatePlayer", (Throwable)e);
        }
    }

    private void calculateEvent(int duration) {
        this.firstQuartile = duration * 25 / 100;
        this.secondQuartile = duration * 50 / 100;
        this.thirdQuartile = duration * 75 / 100;
    }

    @Override
    void pauseAd() {
        try {
            if (this.player != null && this.player.isPlaying()) {
                this.player.pause();
                this.isPlaying = false;
                this.playButton.setBackgroundResource(17301540);
                this.handler.removeCallbacks(this.updateRunnable);
                this.dispatchEvent(Vpaid.VpaidEnum.AdPaused);
            }
        }
        catch (IllegalStateException e) {
            this.isErrorOccurred = true;
            this.stopAd(this.ERROR_CODE_900);
            Log.e((String)"AirVast", (String)"Error occurred in pausing", (Throwable)e);
        }
    }

    @Override
    void resumeAd() {
        try {
            if (this.player != null && !this.player.isPlaying()) {
                this.player.start();
                this.isPlaying = true;
                this.playButton.setBackgroundResource(17301539);
                this.handler.post(this.updateRunnable);
                this.dispatchEvent(Vpaid.VpaidEnum.AdPlaying);
            }
        }
        catch (IllegalStateException e) {
            this.isErrorOccurred = true;
            this.stopAd(this.ERROR_CODE_901);
            Log.e((String)"AirVast", (String)"Error occurred in resume", (Throwable)e);
        }
    }

    public void onCompletion(MediaPlayer mp) {
        try {
            if (this.player != null) {
                this.player.stopPlayback();
            }
            mp.release();
        }
        catch (Exception e) {
            Log.e((String)"AirVast", (String)"Error occurred in onCompletion", (Throwable)e);
        }
        this.isErrorOccurred = false;
        this.stopAd(this.ERROR_CODE_901);
        this.deleteData();
    }

    @Override
    void stopAd(int errorCode) {
        if (this.isErrorOccurred) {
            Log.e((String)"AirVast", (String)"Stopping ad. An error is occurred.");
            this.sendErrorDetails(errorCode);
        } else {
            Log.i((String)"AirVast", (String)"Sending impression data>>");
            this.dispatchEvent(Vpaid.VpaidEnum.AdVideoComplete);
        }
        this.finish();
    }

    @Override
    void skipAd() {
        this.isErrorOccurred = false;
        this.dispatchEvent(Vpaid.VpaidEnum.AdSkipped);
        try {
            this.player.stopPlayback();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.finish();
    }

    public boolean onError(MediaPlayer mp, int what, int extra) {
        Log.e((String)"AirVast", (String)("An error occurred while playing ad video. Error code: " + what));
        this.isErrorOccurred = true;
        this.stopAd(this.ERROR_CODE_405);
        if (AirSDK.adCallbackListener != null) {
            AirSDK.adCallbackListener.onAdError("An error occurred while playing video.");
        }
        return true;
    }

    private void deleteData() {
        try {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    File path = Environment.getExternalStorageDirectory();
                    File file = new File(path, "ap_video");
                    VastUtils.deleteRecursive(file);
                }
            }, "delete").start();
        }
        catch (Exception e) {
            Log.e((String)"AirVast", (String)"Not able to delete video.", (Throwable)e);
        }
    }

    public void onClick(View v) {
        switch (v.getId()) {
            case 107: {
                if (this.isPlaying) {
                    this.pauseAd();
                    break;
                }
                this.resumeAd();
                break;
            }
            case 110: {
                this.skipAd();
                break;
            }
            case 112: {
                if (this.isMute) {
                    AudioManager audioManager = (AudioManager)this.getSystemService("audio");
                    audioManager.setStreamMute(3, false);
                    this.isMute = false;
                    this.setAdVolume(1);
                    this.muteButton.setBackgroundResource(17301554);
                } else {
                    AudioManager audioManager = (AudioManager)this.getSystemService("audio");
                    audioManager.setStreamMute(3, true);
                    this.isMute = true;
                    this.setAdVolume(0);
                    this.muteButton.setBackgroundResource(17301553);
                }
                this.dispatchEvent(Vpaid.VpaidEnum.AdVolumeChange);
                break;
            }
        }
    }

    public void onBackPressed() {
    }

    protected void onPause() {
        super.onPause();
        try {
            if (this.player.getCurrentPosition() > 0) {
                this.dispatchEvent(Vpaid.VpaidEnum.AdUserClose);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.dialog != null) {
            this.dialog.dismiss();
        }
        this.player.stopPlayback();
        this.finish();
    }

    protected void onStop() {
        this.sendDataToAPI();
        super.onStop();
    }

    protected void onDestroy() {
        if (AirSDK.adCallbackListener != null) {
            AirSDK.adCallbackListener.onVideoAdFinished();
        }
        SmartWallActivity.setShowing(false);
        try {
            new Caching((Context)this).deleteVideoJson(AdCallbackListener.AdType.video);
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.onDestroy();
    }

    private class VpaidLayout
    extends RelativeLayout
    implements IVastConstant {
        private final float dp;
        private Context context;

        @SuppressLint(value={"InlinedApi"})
        public VpaidLayout(Activity context) throws NullPointerException, Exception {
            super((Context)context);
            this.context = context;
            this.dp = context.getResources().getDisplayMetrics().density;
            this.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, -1));
            List<VastXmlParser.Creative> creatives = VideoAdActivity.this.vastXmlParser.getCreativesList();
            VastXmlParser.Creative creative = creatives.get(0);
            final ImageView iconView = new ImageView((Context)context);
            iconView.setId(102);
            try {
                int marign;
                HashMap<String, Object> hashMap;
                List<HashMap<String, Object>> hashMaps = creative.getIcons();
                if (hashMaps == null || hashMaps.isEmpty()) {
                    Util.printDebugLog("hashmap empty");
                }
                if ((hashMap = hashMaps.get(0)).isEmpty()) {
                    Util.printDebugLog("hash map");
                }
                int icon_width = (Integer)hashMap.get("width");
                int icon_height = (Integer)hashMap.get("height");
                System.out.println("width: " + icon_width);
                String xPosition = hashMap.get("xPosition").toString();
                String yPosition = hashMap.get("yPosition").toString();
                String offset = hashMap.containsKey("offset") ? null : hashMap.get("offset").toString();
                final String duration = hashMap.containsKey("Duration") ? null : hashMap.get("Duration").toString();
                String icon_url = hashMap.get("StaticResource").toString();
                System.out.println("icon url: " + icon_url);
                this.setIcon(icon_url, iconView);
                if (offset != null && offset.contains(":")) {
                    VideoAdActivity.this.handler.postDelayed(new Runnable(){

                        @Override
                        public void run() {
                            iconView.setVisibility(0);
                            Runnable hideIcon = new Runnable(){

                                @Override
                                public void run() {
                                    iconView.setVisibility(8);
                                }
                            };
                            if (duration != null && duration.contains(":")) {
                                try {
                                    ((VpaidLayout)VpaidLayout.this).VideoAdActivity.this.handler.postDelayed(hideIcon, VastUtils.convertTime(duration));
                                }
                                catch (NumberFormatException e) {
                                    e.printStackTrace();
                                }
                                catch (NullPointerException e) {
                                    e.printStackTrace();
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                            }
                        }
                    }, VastUtils.convertTime(offset));
                }
                RelativeLayout.LayoutParams iconLayoutParams = new RelativeLayout.LayoutParams(icon_width, icon_height);
                if (xPosition.equals("left")) {
                    iconLayoutParams.addRule(9);
                } else if (xPosition.equals("right")) {
                    iconLayoutParams.addRule(11);
                } else {
                    try {
                        iconLayoutParams.leftMargin = marign = (int)Util.convertPixelsToDp(Float.parseFloat(xPosition), (Context)context);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (yPosition.equals("top")) {
                    iconLayoutParams.addRule(10);
                } else if (yPosition.equals("bottom")) {
                    iconLayoutParams.addRule(12);
                } else {
                    try {
                        iconLayoutParams.topMargin = marign = (int)Util.convertPixelsToDp(Float.parseFloat(yPosition), (Context)context);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                iconView.setLayoutParams((ViewGroup.LayoutParams)iconLayoutParams);
            }
            catch (Exception e) {
                Log.e((String)"AirVast", (String)"Error occurred while processing icon.", (Throwable)e);
            }
            StringBuilder builder = new StringBuilder();
            builder.append(String.valueOf(VideoAdActivity.this.vastXmlParser.getAdTitle()) + " ");
            builder.append(VideoAdActivity.this.vastXmlParser.getAdDescription());
            String ad = VideoAdActivity.this.vastXmlParser.getAdvertiserName();
            if (ad != null && !ad.equals("")) {
                builder.append(" - by " + ad);
            }
            TextView adInfoTextView = new TextView((Context)context);
            RelativeLayout.LayoutParams textViewParams = new RelativeLayout.LayoutParams(-2, -2);
            textViewParams.addRule(1, 102);
            textViewParams.addRule(10);
            textViewParams.leftMargin = (int)(10.0f * this.dp);
            adInfoTextView.setLayoutParams((ViewGroup.LayoutParams)textViewParams);
            adInfoTextView.setId(106);
            adInfoTextView.setSingleLine();
            adInfoTextView.setTextAppearance((Context)context, 16973892);
            adInfoTextView.setText((CharSequence)builder.toString());
            VideoView surfaceView = new VideoView((Context)context);
            surfaceView.setId(108);
            RelativeLayout.LayoutParams videoLayoutParams = new RelativeLayout.LayoutParams(-2, -2);
            videoLayoutParams.bottomMargin = (int)(this.dp * 17.0f);
            videoLayoutParams.topMargin = (int)(this.dp * 17.0f);
            videoLayoutParams.rightMargin = (int)(this.dp * 30.0f);
            videoLayoutParams.leftMargin = (int)(this.dp * 30.0f);
            videoLayoutParams.addRule(13, -1);
            surfaceView.setLayoutParams((ViewGroup.LayoutParams)videoLayoutParams);
            Button skipButton = new Button((Context)context);
            skipButton.setId(110);
            RelativeLayout.LayoutParams skipLayoutParams = new RelativeLayout.LayoutParams(-2, -2);
            skipLayoutParams.addRule(11);
            skipLayoutParams.addRule(12);
            skipLayoutParams.bottomMargin = (int)(35.0f * this.dp);
            skipButton.setLayoutParams((ViewGroup.LayoutParams)skipLayoutParams);
            skipButton.setBackgroundColor(-16777216);
            skipButton.setTextColor(-1);
            skipButton.setTypeface(Typeface.MONOSPACE, 16973892);
            skipButton.setClickable(false);
            skipButton.setVisibility(8);
            ImageButton playButton = new ImageButton((Context)context);
            playButton.setId(107);
            RelativeLayout.LayoutParams playLayoutParams = new RelativeLayout.LayoutParams(-2, -2);
            playLayoutParams.addRule(12);
            playLayoutParams.addRule(9);
            playButton.setLayoutParams((ViewGroup.LayoutParams)playLayoutParams);
            playButton.setBackgroundResource(17301539);
            ImageButton muteButton = new ImageButton((Context)context);
            muteButton.setId(112);
            RelativeLayout.LayoutParams muteLayoutParams = new RelativeLayout.LayoutParams(-2, -2);
            muteLayoutParams.addRule(12);
            muteLayoutParams.addRule(1, 107);
            muteButton.setLayoutParams((ViewGroup.LayoutParams)muteLayoutParams);
            muteButton.setBackgroundResource(17301554);
            ProgressBar seekBar = new ProgressBar((Context)context, null, 16842872);
            RelativeLayout.LayoutParams seekLayoutParams = new RelativeLayout.LayoutParams(-1, (int)(10.0f * this.dp));
            seekLayoutParams.addRule(12);
            seekLayoutParams.addRule(1, 112);
            seekLayoutParams.setMargins((int)this.dp * 5, 0, (int)this.dp * 65, (int)(this.dp * 7.0f));
            seekBar.setLayoutParams((ViewGroup.LayoutParams)seekLayoutParams);
            seekBar.setId(109);
            TextView adProgressTextView = new TextView((Context)context);
            RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-2, -2);
            layoutParams.addRule(11);
            layoutParams.addRule(12);
            adProgressTextView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            adProgressTextView.setTextColor(-1);
            adProgressTextView.setTextAppearance((Context)context, 16973894);
            adProgressTextView.setBackgroundColor(-16777216);
            adProgressTextView.setId(111);
            this.addView((View)surfaceView);
            this.addView((View)iconView);
            this.addView((View)adInfoTextView);
            this.addView((View)playButton);
            this.addView((View)muteButton);
            this.addView((View)seekBar);
            this.addView((View)skipButton);
            this.addView((View)adProgressTextView);
        }

        void setIcon(final String image_url, final ImageView imageView) throws NullPointerException {
            AsyncTaskCompleteListener<Bitmap> asyncTaskCompleteListener = new AsyncTaskCompleteListener<Bitmap>(){

                @Override
                public void onTaskComplete(final Bitmap result) {
                    if (result != null && ((VpaidLayout)VpaidLayout.this).VideoAdActivity.this.handler != null) {
                        ((VpaidLayout)VpaidLayout.this).VideoAdActivity.this.handler.post(new Runnable(){

                            @Override
                            public void run() {
                                imageView.setImageBitmap(result);
                            }
                        });
                    }
                }

                @Override
                public void launchNewHttpTask() {
                    ImageTask imageTask = new ImageTask(image_url, this);
                    new Thread((Runnable)imageTask, "vpaid_icon").start();
                }
            };
            if (Util.checkInternetConnection(this.context)) {
                asyncTaskCompleteListener.launchNewHttpTask();
            }
        }
    }
}

