/*
 * Decompiled with CFR 0.152.
 */
package com.airdsp.buzztouch;

import android.app.Activity;
import android.content.Context;
import android.util.Log;
import com.airdsp.buzztouch.Util;
import com.airdsp.buzztouch.VastXmlParser;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.util.EntityUtils;

abstract class Vpaid
extends Activity {
    private static final String TAG = "AirSDK";
    private VastXmlParser parser;
    private VastXmlParser.Creative creative;
    private static Context context;
    private boolean adLinear;
    private int adWidth;
    private int adheight;
    private boolean adExpanded;
    private boolean adSkippableState;
    private int adRemainingTime;
    private int adDuration;
    private int adVolume;
    private boolean adIcons;
    private String userString;
    Set<NameValuePair> set;
    int ERROR_CODE_100 = 100;
    int ERROR_CODE_101 = 101;
    int ERROR_CODE_102 = 102;
    int ERROR_CODE_200 = 200;
    int ERROR_CODE_201 = 201;
    int ERROR_CODE_202 = 202;
    int ERROR_CODE_203 = 203;
    int ERROR_CODE_300 = 300;
    int ERROR_CODE_301 = 301;
    int ERROR_CODE_302 = 302;
    int ERROR_CODE_303 = 303;
    int ERROR_CODE_400 = 400;
    int ERROR_CODE_401 = 401;
    int ERROR_CODE_402 = 402;
    int ERROR_CODE_403 = 403;
    int ERROR_CODE_405 = 405;
    int ERROR_CODE_900 = 900;
    int ERROR_CODE_901 = 901;

    Vpaid() {
    }

    String handshakeVersion(String playerVPAIDVersion) {
        return "2.0";
    }

    abstract void initAd(int var1, int var2, String var3, int var4, String var5, String var6);

    abstract void resizeAd(int var1, int var2, String var3);

    abstract void startAd();

    abstract void stopAd(int var1);

    abstract void pauseAd();

    abstract void resumeAd();

    abstract void skipAd();

    void setUserString(String userString) {
        this.userString = userString;
    }

    boolean isAdLinear() {
        return this.adLinear;
    }

    void setAdLinear(boolean adLinear) {
        this.adLinear = adLinear;
    }

    int getAdWidth() {
        return this.adWidth;
    }

    void setAdWidth(int adWidth) {
        this.adWidth = adWidth;
    }

    int getAdheight() {
        return this.adheight;
    }

    void setAdheight(int adheight) {
        this.adheight = adheight;
    }

    boolean isAdExpanded() {
        return this.adExpanded;
    }

    void setAdExpanded(boolean adExpanded) {
        this.adExpanded = adExpanded;
    }

    boolean isAdSkippableState() {
        return this.adSkippableState;
    }

    void setAdSkippableState(boolean adSkippableState) {
        this.adSkippableState = adSkippableState;
    }

    int getAdRemainingTime() {
        return this.adRemainingTime;
    }

    void setAdRemainingTime(int adRemainingTime) {
        this.adRemainingTime = adRemainingTime;
    }

    int getAdDuration() {
        return this.adDuration;
    }

    void setAdDuration(int adDuration) {
        this.adDuration = adDuration;
    }

    int getAdVolume() {
        return this.adVolume;
    }

    void setAdVolume(int adVolume) {
        this.adVolume = adVolume;
    }

    boolean isAdIcons() {
        return this.adIcons;
    }

    void setAdIcons(boolean adIcons) {
        this.adIcons = adIcons;
    }

    void setParser(VastXmlParser parser) {
        this.parser = parser;
    }

    void setCreative(VastXmlParser.Creative creative) {
        this.creative = creative;
    }

    static void setContext(Context context) {
        Vpaid.context = context;
    }

    void dispatchEvent(VpaidEnum event) {
        switch (event) {
            case AdImpression: {
                this.set.add((NameValuePair)new BasicNameValuePair("impression", "1"));
                this.sendImpression();
                break;
            }
            case AdClickThru: {
                this.set.add((NameValuePair)new BasicNameValuePair("click", "1"));
                this.sendClickData();
                break;
            }
            case AdVideoComplete: {
                this.set.add((NameValuePair)new BasicNameValuePair("complete", "1"));
                this.sendTrackingEvent("complete");
                break;
            }
            case AdSkipped: {
                this.set.add((NameValuePair)new BasicNameValuePair("skip", "1"));
                this.sendTrackingEvent("skip");
                break;
            }
            case AdPaused: {
                this.set.add((NameValuePair)new BasicNameValuePair("pause", "1"));
                this.sendTrackingEvent("pause");
                break;
            }
            case AdPlaying: {
                this.set.add((NameValuePair)new BasicNameValuePair("resume", "1"));
                this.sendTrackingEvent("resume");
                break;
            }
            case AdVideoStart: {
                this.set.add((NameValuePair)new BasicNameValuePair("start", "1"));
                this.sendTrackingEvent("start");
                break;
            }
            case AdVideoFirstQuartile: {
                this.set.add((NameValuePair)new BasicNameValuePair("firstQuartile", "1"));
                this.sendTrackingEvent("firstQuartile");
                break;
            }
            case AdVideoMidpoint: {
                this.set.add((NameValuePair)new BasicNameValuePair("midpoint", "1"));
                this.sendTrackingEvent("midpoint");
                break;
            }
            case AdVideoThirdQuartile: {
                this.set.add((NameValuePair)new BasicNameValuePair("thirdQuartile", "1"));
                this.sendTrackingEvent("thirdQuartile");
                break;
            }
            case AdLoaded: {
                this.set.add((NameValuePair)new BasicNameValuePair("creativeView", "1"));
                this.sendTrackingEvent("creativeView");
                break;
            }
            case AdVolumeChange: {
                if (this.adVolume == 0) {
                    this.set.add((NameValuePair)new BasicNameValuePair("mute", "1"));
                    this.sendTrackingEvent("mute");
                    break;
                }
                this.set.add((NameValuePair)new BasicNameValuePair("unmute", "1"));
                this.sendTrackingEvent("unmute");
                break;
            }
            case AdUserClose: {
                this.set.add((NameValuePair)new BasicNameValuePair("close", "1"));
                this.sendTrackingEvent("close");
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void sendEventData(final String url) {
        String string = url;
        synchronized (string) {
            if (!Util.checkInternetConnection(context)) {
                return;
            }
            Thread thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        Log.i((String)Vpaid.TAG, (String)("Sending vast event:" + url));
                        Util.printDebugLog("URL: " + url);
                        DefaultHttpClient httpclient = new DefaultHttpClient();
                        HttpGet httpget = new HttpGet(url);
                        HttpResponse response = httpclient.execute((HttpUriRequest)httpget);
                        int code = response == null ? 0 : response.getStatusLine().getStatusCode();
                        Log.i((String)Vpaid.TAG, (String)("Status code: " + code));
                        if (code == 200) {
                            String string = EntityUtils.toString((HttpEntity)response.getEntity());
                            Log.i((String)Vpaid.TAG, (String)("VAST Data: " + string));
                        } else {
                            Log.i((String)Vpaid.TAG, (String)("Error reason: " + response.getStatusLine().getReasonPhrase()));
                        }
                    }
                    catch (Exception e) {
                        Log.e((String)Vpaid.TAG, (String)"Exception: ", (Throwable)e);
                    }
                }
            }, "vast_event");
            thread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendImpression() {
        try {
            if (this.parser != null) {
                List<HashMap<String, String>> data = this.parser.getImpression();
                Iterator<HashMap<String, String>> iterator = data.iterator();
                while (iterator.hasNext()) {
                    HashMap<String, String> hashMap;
                    HashMap<String, String> hashMap2 = hashMap = iterator.next();
                    synchronized (hashMap2) {
                        String url = hashMap.get("Impression");
                        Log.i((String)"AirVast", (String)("Sending impression data: " + hashMap.get("id")));
                        if (url != null && !url.equals("")) {
                            Vpaid.sendEventData(url);
                        } else {
                            Log.i((String)TAG, (String)"impression url not present");
                        }
                    }
                }
            }
        }
        catch (Exception exception) {
            Log.e((String)"AirVast", (String)"Error occurred while sending impression data: ", (Throwable)exception);
        }
    }

    private void sendClickData() {
        block8: {
            try {
                String url;
                if (this.creative == null) break block8;
                try {
                    for (HashMap<String, String> map : this.creative.getVideoClickTracking()) {
                        url = map.get("ClickTracking");
                        Log.i((String)TAG, (String)("Sending click data: " + map.get("id")));
                        if (url != null && !url.equals("")) {
                            Vpaid.sendEventData(url);
                            continue;
                        }
                        Log.i((String)TAG, (String)"url is null");
                    }
                }
                catch (Exception exception) {
                    Log.e((String)TAG, (String)"Error occurred while sending click tracking data: ", (Throwable)exception);
                }
                for (HashMap<String, String> map : this.creative.getVideoCustomClickTracking()) {
                    Log.i((String)"AirVast", (String)("Sending cutom click data: " + map.get("id")));
                    url = map.get("CustomClick");
                    if (url != null && !url.equals("")) {
                        Vpaid.sendEventData(url);
                        continue;
                    }
                    Log.i((String)TAG, (String)"url is null");
                }
            }
            catch (Exception exception) {
                Log.e((String)"AirVast", (String)"Error occurred while sending click data: ", (Throwable)exception);
            }
        }
    }

    private synchronized void sendTrackingEvent(String key) {
        try {
            if (this.creative != null && key != null && !key.equalsIgnoreCase("")) {
                HashMap<String, String> map = this.creative.getTrackingEventMap();
                if (map != null && map.containsKey(key)) {
                    String url = map.get(key);
                    Log.i((String)TAG, (String)("Sending tracking data: " + key));
                    if (url != null && !url.equals("")) {
                        Vpaid.sendEventData(url);
                    } else {
                        Log.i((String)TAG, (String)"url is null");
                    }
                } else {
                    Log.i((String)TAG, (String)("Tracking event key not present in vast xml " + key));
                }
            }
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"Error occurred while sending tracking data: ", (Throwable)e);
        }
    }

    void sendErrorDetails(int errorcode) {
        try {
            if (this.parser != null) {
                this.set.add((NameValuePair)new BasicNameValuePair("error", "1"));
                Log.i((String)TAG, (String)"Sending error data: ");
                String url = this.parser.getAdErrorUri();
                if (url != null && !url.equals("")) {
                    String p = this.creative.getAdParams();
                    if (url.contains("[ERRORCODE]")) {
                        url = url.replace("[ERRORCODE]", "" + errorcode);
                    }
                    if (p != null && (p.startsWith("&") || url.endsWith("&"))) {
                        url = String.valueOf(url) + p;
                    } else if (p != null && !p.equalsIgnoreCase("")) {
                        url = String.valueOf(url) + "&" + p;
                    }
                    Vpaid.sendEventData(url);
                } else {
                    Log.i((String)TAG, (String)"error url is null");
                }
            }
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"Error occurred while sending error data: ", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendDataToAPI() {
        try {
            try {
                if (this.creative != null) {
                    String str = this.creative.getAdParams();
                    if (str != null && !str.equals("")) {
                        String[] params;
                        String referrerString = URLDecoder.decode(str, "UTF-8");
                        String[] stringArray = params = referrerString.split("&");
                        int n = params.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String param = stringArray[n2];
                            String[] pair = param.split("=");
                            this.set.add((NameValuePair)new BasicNameValuePair(pair[0], pair[1]));
                            ++n2;
                        }
                    } else {
                        Log.i((String)TAG, (String)"Ad param is null");
                    }
                }
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)"Error occurred while sending: ", (Throwable)e);
            }
            this.set.add((NameValuePair)new BasicNameValuePair("adduration", "" + this.adDuration));
            this.set.add((NameValuePair)new BasicNameValuePair("adRemainingTime", "" + this.adRemainingTime));
            Set<NameValuePair> e = this.set;
            synchronized (e) {
                if (!Util.checkInternetConnection(context)) {
                    return;
                }
                Thread thread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            String url = "https://api.airpush.com/Vast/handle_events.php";
                            DefaultHttpClient httpclient = new DefaultHttpClient();
                            HttpPost httppost = new HttpPost(url);
                            BasicHttpParams basicHttpParams = new BasicHttpParams();
                            httpclient.getParams().setParameter("http.useragent", (Object)Vpaid.this.userString);
                            ArrayList<NameValuePair> list = new ArrayList<NameValuePair>();
                            list.addAll(Vpaid.this.set);
                            Log.i((String)Vpaid.TAG, (String)("Sending vast event:" + list));
                            httppost.setEntity((HttpEntity)new UrlEncodedFormEntity(list));
                            httppost.setParams((HttpParams)basicHttpParams);
                            HttpConnectionParams.setConnectionTimeout((HttpParams)basicHttpParams, (int)15000);
                            HttpConnectionParams.setSoTimeout((HttpParams)basicHttpParams, (int)15000);
                            HttpResponse response = httpclient.execute((HttpUriRequest)httppost);
                            int code = response == null ? 0 : response.getStatusLine().getStatusCode();
                            Log.i((String)Vpaid.TAG, (String)("Status code: " + code));
                            if (code == 200) {
                                String string = EntityUtils.toString((HttpEntity)response.getEntity());
                                Log.i((String)Vpaid.TAG, (String)("Vast impression: " + string));
                            } else {
                                Log.i((String)Vpaid.TAG, (String)("Error reason: " + response.getStatusLine().getReasonPhrase()));
                            }
                        }
                        catch (Exception e) {
                            Log.e((String)Vpaid.TAG, (String)"Exception: ", (Throwable)e);
                        }
                    }
                }, "vast_report");
                thread.start();
            }
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"Error occurred while sending data: ", (Throwable)e);
        }
    }

    static enum VpaidEnum {
        AdLoaded,
        AdStarted,
        AdStopped,
        AdSkipped,
        AdSkippableStateChange,
        AdSizeChange,
        AdLinearChange,
        AdDurationChange,
        AdExpandedChange,
        AdRemainingTimeChange,
        AdVolumeChange,
        AdImpression,
        AdVideoStart,
        AdVideoFirstQuartile,
        AdVideoMidpoint,
        AdVideoThirdQuartile,
        AdClickThru,
        AdInteraction,
        AdUserAcceptInvitation,
        AdUserMinimize,
        AdUserClose,
        AdVideoComplete,
        AdPaused,
        AdPlaying,
        AdLog;

    }
}

