/*
 * Decompiled with CFR 0.152.
 */
package com.bugsense.trace;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.util.Log;
import com.bugsense.trace.ActivityAsyncTask;
import com.bugsense.trace.DefaultExceptionHandler;
import com.bugsense.trace.ExceptionCallback;
import com.bugsense.trace.G;
import com.bugsense.trace.Utils;
import com.bugsense.trace.models.CrashMechanism;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class BugSenseHandler {
    public static boolean I_WANT_TO_DEBUG = false;
    private static ActivityAsyncTask<Processor, Object, Object, Object> sTask;
    protected static int sMinDelay;
    private static boolean sSetupCalled;
    private static ExceptionCallback exceptionCallback;
    private static boolean isSessionActive;
    protected static Context gContext;
    static String locTicker;
    static String locTitle;
    static String locText;
    private static HashMap<String, String> crashExtraData;

    private static void initAndStartSession(Context context, Processor processor, String string, String string2) {
        block10: {
            block9: {
                if (context == null) {
                    Log.e((String)G.TAG, (String)"Context is null!");
                    return;
                }
                gContext = context;
                if (string == null || string.length() < 8 || string.length() > 14) {
                    throw new IllegalArgumentException("Your BugSense API Key is invalid!");
                }
                G.API_KEY = string;
                BugSenseHandler.installHandler();
                processor.handlerInstalled();
                G.PHONE_MODEL = Build.MODEL;
                G.ANDROID_VERSION = Build.VERSION.RELEASE;
                G.APPID = string2;
                try {
                    PackageManager packageManager = gContext.getPackageManager();
                    PackageInfo packageInfo = packageManager.getPackageInfo(gContext.getPackageName(), 0);
                    G.APP_VERSION = packageInfo.versionName;
                    G.APP_VERSIONCODE = String.valueOf(packageInfo.versionCode);
                    G.APP_PACKAGE = packageInfo.packageName;
                }
                catch (Exception exception) {
                    Log.e((String)G.TAG, (String)"Error collecting information about the package!");
                    if (!I_WANT_TO_DEBUG) break block9;
                    exception.printStackTrace();
                }
            }
            if (sSetupCalled && sTask != null && !sTask.postProcessingDone()) {
                sTask.connectTo(null);
                sTask.connectTo(processor);
            }
            sSetupCalled = true;
            try {
                G.FILES_PATH = gContext.getFilesDir().getAbsolutePath();
            }
            catch (Exception exception) {
                if (!I_WANT_TO_DEBUG) break block10;
                exception.printStackTrace();
            }
        }
        if (G.FILES_PATH == null) {
            Log.e((String)G.TAG, (String)"G.FILES_PATH GOT NULL!");
            return;
        }
        if (I_WANT_TO_DEBUG) {
            Log.d((String)G.TAG, (String)("Files Path set to: " + G.FILES_PATH));
        }
        G.HAS_ROOT = Utils.checkForRoot();
        new Thread(new Runnable(){

            @Override
            public void run() {
                G.UID = Utils.manageUid(gContext);
                if (I_WANT_TO_DEBUG) {
                    Log.d((String)G.TAG, (String)("Crash     URL set to: " + G.URL));
                }
                BugSenseHandler.flush(gContext);
                BugSenseHandler.startSession(gContext);
            }
        }).start();
    }

    public static void initAndStartSession(Context context, String string, String string2) {
        BugSenseHandler.initAndStartSession(context, new Processor(){

            @Override
            public boolean beginSubmit() {
                return true;
            }

            @Override
            public void submitDone() {
            }

            @Override
            public void handlerInstalled() {
            }
        }, string, string2);
    }

    public static void setExceptionCallback(ExceptionCallback exceptionCallback) {
        BugSenseHandler.exceptionCallback = exceptionCallback;
    }

    protected static ExceptionCallback getCallback() {
        return exceptionCallback;
    }

    public static void startSession(Context context) {
        gContext = context;
        BugSenseHandler.installHandler();
        if (!isSessionActive) {
            G.TIMESTAMP = System.currentTimeMillis();
            isSessionActive = true;
        }
    }

    public static void leaveBreadcrumb(String string) {
        if (G.breadcrumbs == null) {
            G.breadcrumbs = new ArrayList(16);
        }
        if (G.breadcrumbs.size() >= 16) {
            G.breadcrumbs.remove(0);
        }
        G.breadcrumbs.add(string);
        if (I_WANT_TO_DEBUG) {
            Log.i((String)G.TAG, (String)("BreadCrumb: " + string + " added."));
        }
    }

    public static void closeSession(Context context) {
        isSessionActive = false;
    }

    public static void flush(Context context) {
        Log.i((String)G.TAG, (String)"Flushing...");
        CrashMechanism.getInstance().sendSavedCrashes(context);
    }

    public static void sendExceptionMap(HashMap<String, String> hashMap, Exception exception) {
        block10: {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            if (G.API_KEY == null) {
                Log.e((String)G.TAG, (String)"Could not send: API Key is missing");
            } else {
                Log.i((String)G.TAG, (String)"Saving handled exception");
                exception.printStackTrace(printWriter);
                HashMap<String, String> hashMap2 = new HashMap<String, String>();
                if (hashMap != null) {
                    for (Map.Entry<String, String> entry : hashMap.entrySet()) {
                        hashMap2.put(entry.getKey(), Utils.exceedLimitString(entry.getValue()));
                    }
                }
                long l = 0L;
                try {
                    l = System.currentTimeMillis() - G.TIMESTAMP;
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                try {
                    exception.printStackTrace(printWriter);
                    String string = "";
                    try {
                        string = CrashMechanism.createJSONFromCrash(((Object)stringWriter).toString(), Utils.isWifiOn(gContext), Utils.isMobileNetworkOn(gContext), Utils.isGPSOn(gContext), Utils.ScreenProperties(gContext), Utils.getTime(), BugSenseHandler.getCrashExtraData(), hashMap2, 0, l, null);
                    }
                    catch (Exception exception3) {
                        exception3.printStackTrace();
                    }
                    CrashMechanism.saveCrash(string, 0);
                }
                catch (Exception exception4) {
                    Log.e((String)G.TAG, (String)"Failed to save handled exception ");
                    if (!I_WANT_TO_DEBUG) break block10;
                    exception4.printStackTrace();
                }
            }
        }
    }

    public static void sendException(Exception exception) {
        HashMap<String, String> hashMap = new HashMap<String, String>(0);
        BugSenseHandler.sendExceptionMap(hashMap, exception);
    }

    public static void sendExceptionMessage(String string, String string2, Exception exception) {
        HashMap<String, String> hashMap = new HashMap<String, String>(1);
        if (string != null && string2 != null) {
            hashMap.put(string, Utils.exceedLimitString(string2));
        }
        BugSenseHandler.sendExceptionMap(hashMap, exception);
    }

    public static void setLogging(boolean bl) {
        G.SEND_LOG = bl;
    }

    public static void setLogging(int n) {
        G.SEND_LOG = true;
        G.LOG_LINES = n;
    }

    public static void setLogging(String string) {
        G.SEND_LOG = true;
        G.LOG_FILTER = string;
    }

    public static void setLogging(int n, String string) {
        G.SEND_LOG = true;
        G.LOG_LINES = n;
        G.LOG_FILTER = string;
    }

    private static void installHandler() {
        Log.i((String)G.TAG, (String)"Registering default exceptions handler");
        Thread.UncaughtExceptionHandler uncaughtExceptionHandler = Thread.getDefaultUncaughtExceptionHandler();
        if (uncaughtExceptionHandler != null && I_WANT_TO_DEBUG) {
            Log.d((String)G.TAG, (String)("current handler class=" + uncaughtExceptionHandler.getClass().getName()));
        }
        if (!(uncaughtExceptionHandler instanceof DefaultExceptionHandler)) {
            Thread.setDefaultUncaughtExceptionHandler(new DefaultExceptionHandler(uncaughtExceptionHandler));
        }
    }

    public static void setLocalizedNotification(String string, String string2, String string3) {
        locTicker = string;
        locTitle = string2;
        locText = string3;
    }

    public static HashMap<String, String> getCrashExtraData() {
        if (crashExtraData == null) {
            crashExtraData = new HashMap();
        }
        return crashExtraData;
    }

    public static void addCrashExtraData(String string, String string2) {
        if (crashExtraData == null) {
            crashExtraData = new HashMap();
        }
        crashExtraData.put(string, Utils.exceedLimitString(string2));
    }

    public static void addCrashExtraMap(HashMap<String, String> hashMap) {
        if (crashExtraData == null) {
            crashExtraData = new HashMap();
        }
        for (Map.Entry<String, String> entry : hashMap.entrySet()) {
            crashExtraData.put(entry.getKey(), Utils.exceedLimitString(entry.getValue()));
        }
    }

    public static void removeCrashExtraData(String string) {
        if (crashExtraData == null) {
            crashExtraData = new HashMap();
        }
        crashExtraData.remove(string);
    }

    public static void clearCrashExtraData() {
        if (crashExtraData == null) {
            crashExtraData = new HashMap();
        } else {
            crashExtraData.clear();
        }
    }

    public static void useProxy(boolean bl) {
        G.proxyEnabled = bl;
    }

    static {
        sMinDelay = 0;
        sSetupCalled = false;
        exceptionCallback = null;
        isSessionActive = false;
        locTicker = "";
        locTitle = "";
        locText = "";
        crashExtraData = new HashMap();
    }

    private static interface Processor {
        public boolean beginSubmit();

        public void submitDone();

        public void handlerInstalled();
    }
}

