/*
 * Decompiled with CFR 0.152.
 */
package com.bugsense.trace;

import android.app.ActivityManager;
import android.util.Log;
import com.bugsense.trace.BugSenseHandler;
import com.bugsense.trace.G;
import com.bugsense.trace.Utils;
import com.bugsense.trace.models.CrashMechanism;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;

public class DefaultExceptionHandler
implements Thread.UncaughtExceptionHandler {
    private Thread.UncaughtExceptionHandler defaultExceptionHandler;

    public DefaultExceptionHandler(Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
        this.defaultExceptionHandler = uncaughtExceptionHandler;
    }

    @Override
    public void uncaughtException(Thread thread, Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        long l = 0L;
        try {
            l = System.currentTimeMillis() - G.TIMESTAMP;
        }
        catch (Exception exception) {
            // empty catch block
        }
        ActivityManager.MemoryInfo memoryInfo = new ActivityManager.MemoryInfo();
        Runtime runtime = Runtime.getRuntime();
        HashMap<String, String> hashMap = new HashMap<String, String>(6);
        hashMap.put("sysMemAvail", String.valueOf((double)memoryInfo.availMem / 1048576.0));
        hashMap.put("sysMemLow", String.valueOf(memoryInfo.lowMemory));
        hashMap.put("sysMemThreshold", String.valueOf((double)memoryInfo.threshold / 1048576.0));
        hashMap.put("appMemAvail", String.valueOf((double)runtime.freeMemory() / 1048576.0));
        hashMap.put("appMemMax", String.valueOf((double)runtime.maxMemory() / 1048576.0));
        hashMap.put("appMemTotal", String.valueOf((double)runtime.totalMemory() / 1048576.0));
        String string = "";
        try {
            string = CrashMechanism.createJSONFromCrash(((Object)stringWriter).toString(), Utils.isWifiOn(BugSenseHandler.gContext), Utils.isMobileNetworkOn(BugSenseHandler.gContext), Utils.isGPSOn(BugSenseHandler.gContext), Utils.ScreenProperties(BugSenseHandler.gContext), Utils.getTime(), BugSenseHandler.getCrashExtraData(), null, 1, l, hashMap);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        CrashMechanism.transmitCrashASync(BugSenseHandler.gContext, string, 1);
        if (BugSenseHandler.I_WANT_TO_DEBUG) {
            Log.d((String)G.TAG, (String)((Object)stringWriter).toString());
        }
        if (BugSenseHandler.getCallback() != null) {
            BugSenseHandler.getCallback().lastBreath();
        }
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        this.defaultExceptionHandler.uncaughtException(thread, throwable);
    }
}

