/*
 * Decompiled with CFR 0.152.
 */
package com.bugsense.trace;

import android.app.ActivityManager;
import android.content.Context;
import android.content.pm.PackageManager;
import android.location.LocationManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Environment;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.Display;
import android.view.WindowManager;
import com.bugsense.trace.BugSenseHandler;
import com.bugsense.trace.G;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Random;
import java.util.TimeZone;

public class Utils {
    public static final int STATE_OFF = 0;
    public static final int STATE_ON = 1;
    public static final int STATE_DONT_KNOW = 2;
    private static final char[] DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    static final Runtime rt = Runtime.getRuntime();

    protected static boolean checkForRoot() {
        String[] stringArray;
        boolean bl = false;
        for (String string : stringArray = new String[]{"/sbin/", "/system/bin/", "/system/xbin/", "/data/local/xbin/", "/data/local/bin/", "/system/sd/xbin/", "/system/bin/failsafe/", "/data/local/"}) {
            File file = new File(string + "su");
            if (!file.exists()) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public static final String getTime() {
        String string = String.valueOf(System.currentTimeMillis());
        try {
            string = String.valueOf(Calendar.getInstance(TimeZone.getTimeZone("UTC")).getTimeInMillis() / 1000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    public static final String exceedLimitString(String string) {
        if (string == null || string.length() < 1) {
            return "";
        }
        if (string.length() == 128) {
            return string;
        }
        if (string.length() > 128) {
            string = string.substring(0, 125) + "...";
            return string;
        }
        return string;
    }

    public static String readLogs() {
        int n = G.LOG_LINES;
        if (n < 0) {
            n = 100;
        }
        String string = G.LOG_FILTER;
        StringBuilder stringBuilder = new StringBuilder();
        try {
            String string2;
            Process process = Runtime.getRuntime().exec("logcat -d " + string);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            ArrayList<String> arrayList = new ArrayList<String>();
            while ((string2 = bufferedReader.readLine()) != null) {
                arrayList.add(string2);
            }
            if (arrayList.size() == 0) {
                return "You must add the android.permission.READ_LOGS permission to your manifest file!";
            }
            int n2 = arrayList.size() - n;
            if (n2 < 0) {
                n2 = 0;
            }
            for (int i = n2; i < arrayList.size(); ++i) {
                stringBuilder.append((String)arrayList.get(i) + "\n");
            }
            arrayList = null;
            return stringBuilder.toString();
        }
        catch (Exception exception) {
            Log.e((String)G.TAG, (String)"Error reading logcat output!");
            if (BugSenseHandler.I_WANT_TO_DEBUG) {
                exception.printStackTrace();
            }
            return exception.getMessage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFile(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(string));
            String string2 = null;
            while ((string2 = bufferedReader.readLine()) != null) {
                stringBuilder.append(string2);
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        return stringBuilder.toString();
    }

    public static String MD5(String string) throws Exception {
        MessageDigest messageDigest = MessageDigest.getInstance("MD5");
        messageDigest.update(string.getBytes(), 0, string.length());
        return new BigInteger(1, messageDigest.digest()).toString(16);
    }

    private static int CheckNetworkConnection(Context context, String string) {
        int n = 0;
        PackageManager packageManager = context.getPackageManager();
        if (packageManager.checkPermission("android.permission.ACCESS_NETWORK_STATE", G.APP_PACKAGE) == 0) {
            NetworkInfo[] networkInfoArray;
            ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
            for (NetworkInfo networkInfo : networkInfoArray = connectivityManager.getAllNetworkInfo()) {
                if (!networkInfo.getTypeName().equalsIgnoreCase(string) || !networkInfo.isConnected()) continue;
                n = 1;
            }
        } else {
            n = 2;
        }
        return n;
    }

    protected static int isWifiOn(Context context) {
        return Utils.CheckNetworkConnection(context, "WIFI");
    }

    public static boolean isOnWifi(Context context) {
        return Utils.CheckNetworkConnection(context, "WIFI") == 1;
    }

    protected static int isMobileNetworkOn(Context context) {
        return Utils.CheckNetworkConnection(context, "MOBILE");
    }

    protected static int isGPSOn(Context context) {
        int n = 1;
        PackageManager packageManager = context.getPackageManager();
        if (packageManager.checkPermission("android.permission.ACCESS_FINE_LOCATION", G.APP_PACKAGE) == 0) {
            LocationManager locationManager = (LocationManager)context.getSystemService("location");
            if (!locationManager.isProviderEnabled("gps")) {
                n = 0;
            }
        } else {
            n = 2;
        }
        return n;
    }

    protected static String[] ScreenProperties(Context context) {
        String[] stringArray = new String[]{"Not available", "Not available", "Not available", "Not available", "Not available"};
        DisplayMetrics displayMetrics = new DisplayMetrics();
        Display display = ((WindowManager)context.getSystemService("window")).getDefaultDisplay();
        int n = display.getWidth();
        int n2 = display.getHeight();
        int n3 = display.getOrientation();
        stringArray[0] = Integer.toString(n);
        stringArray[1] = Integer.toString(n2);
        String string = "";
        switch (n3) {
            case 0: {
                string = "normal";
                break;
            }
            case 2: {
                string = "180";
                break;
            }
            case 3: {
                string = "270";
                break;
            }
            case 1: {
                string = "90";
            }
        }
        stringArray[2] = string;
        display.getMetrics(displayMetrics);
        stringArray[3] = Float.toString(displayMetrics.xdpi);
        stringArray[4] = Float.toString(displayMetrics.ydpi);
        return stringArray;
    }

    public static synchronized String manageUid(Context context) {
        BufferedReader bufferedReader;
        if (G.UID != null && G.UID.length() == 32) {
            return G.UID;
        }
        if (context == null) {
            Log.e((String)G.TAG, (String)"Context is null!");
            return "12345678901234567890123456789012";
        }
        String string = "";
        boolean bl = false;
        File file = new File(Environment.getExternalStorageDirectory() + File.separator + ".bugsense");
        File file2 = new File(context.getFilesDir().getAbsolutePath() + File.separator + ".bugsense");
        if (file != null && file.exists()) {
            bufferedReader = null;
            try {
                bufferedReader = new BufferedReader(new FileReader(file.getAbsolutePath()));
                if (bufferedReader != null) {
                    string = bufferedReader.readLine();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                bufferedReader.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            if (string == null || string.length() != 32) {
                string = "";
            }
        }
        if ((string == null || string.length() != 32) && file2 != null && file2.exists()) {
            bufferedReader = null;
            try {
                bufferedReader = new BufferedReader(new FileReader(file2.getAbsolutePath()));
                if (bufferedReader != null) {
                    string = bufferedReader.readLine();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                bufferedReader.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            if (string == null || string.length() != 32) {
                string = "";
            }
        }
        if (string == null || string.length() != 32) {
            string = Utils.generateUid();
            bl = true;
        }
        G.UID = string;
        if (bl) {
            boolean bl2 = false;
            try {
                if (Utils.hasStorage(true) && context.getPackageManager().checkPermission("android.permission.WRITE_EXTERNAL_STORAGE", G.APP_PACKAGE) == 0) {
                    bl2 = Utils.saveUid(file, string);
                }
            }
            catch (Exception exception) {
                bl2 = false;
            }
            if (!bl2) {
                Utils.saveUid(file2, string);
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean saveUid(File file, String string) {
        if (file != null) {
            PrintWriter printWriter = null;
            try {
                printWriter = new PrintWriter(file);
                printWriter.println(string);
                printWriter.flush();
                boolean bl = true;
                return bl;
            }
            catch (IOException iOException) {
                Log.e((String)G.TAG, (String)"Cannot save uid");
                if (BugSenseHandler.I_WANT_TO_DEBUG) {
                    Log.e((String)G.TAG, (String)("Cannot save uid, path= " + file));
                    iOException.printStackTrace();
                }
            }
            finally {
                if (printWriter != null) {
                    printWriter.close();
                }
            }
        }
        return false;
    }

    private static boolean hasStorage(boolean bl) {
        String string = Environment.getExternalStorageState();
        if (Environment.getExternalStorageState().equals("mounted")) {
            return true;
        }
        return !bl && "mounted_ro".equals(string);
    }

    private static String generateUid() {
        String string = Long.valueOf(new Date().getTime()).toString();
        String string2 = new Object().toString();
        long l = System.nanoTime();
        try {
            Thread.sleep(256L, 42);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        long l2 = System.nanoTime();
        String string3 = Long.valueOf(l2 - l).toString();
        String string4 = Integer.valueOf((int)(new Random(System.currentTimeMillis()).nextDouble() * 65535.0)).toString();
        String string5 = string + string2 + string3 + string4 + "android_id";
        byte[] byArray = null;
        try {
            byte[] byArray2 = string5.getBytes("UTF-8");
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            byArray = messageDigest.digest(byArray2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            noSuchAlgorithmException.printStackTrace();
        }
        return new String(Utils.encodeHex(byArray));
    }

    private static char[] encodeHex(byte[] byArray) {
        int n = byArray.length;
        char[] cArray = new char[n << 1];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            cArray[n2++] = DIGITS[(0xF0 & byArray[i]) >>> 4];
            cArray[n2++] = DIGITS[0xF & byArray[i]];
        }
        return cArray;
    }

    public static String getMem() {
        ActivityManager.MemoryInfo memoryInfo = new ActivityManager.MemoryInfo();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(String.format("%.3f", (double)rt.freeMemory() / 1048576.0) + ":");
        stringBuilder.append(String.format("%.3f", (double)rt.maxMemory() / 1048576.0) + ":");
        stringBuilder.append(String.format("%.3f", (double)rt.totalMemory() / 1048576.0) + ":");
        stringBuilder.append(String.format("%.3f", (double)memoryInfo.availMem / 1048576.0) + ":");
        stringBuilder.append(String.format("%.3f", (double)memoryInfo.threshold / 1048576.0) + ":");
        stringBuilder.append(String.valueOf(memoryInfo.lowMemory));
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getCPU() {
        String string = "unknown";
        String string2 = String.valueOf(android.os.Process.myPid());
        Process process = null;
        BufferedReader bufferedReader = null;
        String string3 = null;
        try {
            process = Runtime.getRuntime().exec("top -d 1 -n 1");
            bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            block13: while ((string3 = bufferedReader.readLine()) != null) {
                String[] stringArray;
                if (!string3.contains(string2) || (stringArray = string3.split(" ")) == null) continue;
                for (int i = 0; i < stringArray.length; ++i) {
                    if (stringArray[i] == null || !stringArray[i].contains("%")) continue;
                    string = stringArray[i];
                    continue block13;
                }
            }
        }
        catch (IOException iOException) {
            Log.e((String)"executeTop", (String)"error in getting first line of top");
            iOException.printStackTrace();
        }
        finally {
            try {
                bufferedReader.close();
                process.destroy();
            }
            catch (IOException iOException) {
                Log.e((String)"executeTop", (String)"error in closing and destroying top process");
                iOException.printStackTrace();
            }
        }
        try {
            return string.substring(0, string.length() - 1);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return string;
        }
    }
}

