/*
 * Decompiled with CFR 0.152.
 */
package com.bugsense.trace.models;

import android.util.Log;
import com.bugsense.trace.BugSense;
import com.bugsense.trace.BugSenseHandler;
import com.bugsense.trace.CryptoHttpClient;
import com.bugsense.trace.G;
import com.bugsense.trace.Utils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;

public final class EventsMechanism {
    private static final int MAX_EVENTS_SIZE = 12;
    private static final int MAX_BYTES = 256;
    private static volatile EventsMechanism instance;

    public static EventsMechanism getInstance() {
        if (instance == null) {
            instance = new EventsMechanism();
        }
        return instance;
    }

    public synchronized void sendSavedEvents() {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                int n;
                File file = new File(G.FILES_PATH);
                if (!file.exists()) {
                    file.mkdir();
                }
                FilenameFilter filenameFilter = new FilenameFilter(){

                    @Override
                    public boolean accept(File file, String string) {
                        return string.startsWith("Event_");
                    }
                };
                String[] stringArray = file.list(filenameFilter);
                if (BugSenseHandler.I_WANT_TO_DEBUG) {
                    Log.d((String)G.TAG, (String)("Events List has: " + stringArray.length + " items"));
                }
                if ((n = 12) > stringArray.length) {
                    n = stringArray.length;
                }
                int n2 = 0;
                for (n2 = 0; n2 < n && EventsMechanism.transmitEventSync(Utils.readFile(G.FILES_PATH + "/" + stringArray[n2])); ++n2) {
                }
                if (n2 >= 1) {
                    for (int i = 0; i < stringArray.length; ++i) {
                        try {
                            File file2 = new File(G.FILES_PATH + "/" + stringArray[i]);
                            file2.delete();
                            continue;
                        }
                        catch (Exception exception) {
                            Log.e((String)G.TAG, (String)("Error deleting trace file: " + G.FILES_PATH + "/" + stringArray[i]), (Throwable)exception);
                        }
                    }
                }
            }
        });
        ExecutorService executorService = BugSense.getExecutor();
        if (thread != null && executorService != null) {
            executorService.submit(thread);
        }
    }

    public static String getFlatLine(String string) {
        if (string.getBytes().length > 256) {
            string = string.substring(0, 256);
        }
        if (string.equals("_ping") || string.equals("_gnip")) {
            string = string.replaceAll("_", "-");
        }
        if (string.contains(":") || string.contains("|")) {
            string = string.replaceAll(":", "_").replace("|", "_");
        }
        String string2 = "3.2.1:";
        String string3 = ":" + G.PHONE_MODEL + ":" + G.PHONE_BRAND + ":" + G.ANDROID_VERSION + ":" + G.APP_VERSION + ":" + Locale.getDefault().getDisplayLanguage() + ":" + Utils.getTime();
        int n = 256 - (string2.getBytes().length + string3.getBytes().length);
        if (string.getBytes().length > n) {
            string = string.substring(0, n);
        }
        String string4 = "3.2.1:" + string + ":" + G.PHONE_MODEL + ":" + G.PHONE_BRAND + ":" + G.ANDROID_VERSION + ":" + G.APP_VERSION + ":" + Locale.getDefault().getDisplayLanguage() + ":" + Utils.getTime();
        return string4;
    }

    public static boolean transmitEventSync(String string) {
        if (BugSenseHandler.I_WANT_TO_DEBUG) {
            Log.d((String)G.TAG, (String)("URL: " + G.ANALYTICS_URL));
            Log.d((String)G.TAG, (String)("APIKEY: " + G.API_KEY));
        }
        try {
            String string2;
            DefaultHttpClient defaultHttpClient = null;
            defaultHttpClient = G.ANALYTICS_URL.startsWith("https://") ? new CryptoHttpClient(0) : new DefaultHttpClient();
            HttpParams httpParams = defaultHttpClient.getParams();
            HttpProtocolParams.setUseExpectContinue((HttpParams)httpParams, (boolean)false);
            HttpConnectionParams.setConnectionTimeout((HttpParams)httpParams, (int)20000);
            HttpConnectionParams.setSoTimeout((HttpParams)httpParams, (int)20000);
            HttpPost httpPost = new HttpPost(G.ANALYTICS_URL);
            httpPost.addHeader("X-BugSense-Api-Key", G.API_KEY);
            ArrayList<BasicNameValuePair> arrayList = new ArrayList<BasicNameValuePair>();
            arrayList.add(new BasicNameValuePair("data", string));
            httpPost.setEntity((HttpEntity)new StringEntity(string));
            HttpResponse httpResponse = defaultHttpClient.execute((HttpUriRequest)httpPost);
            HttpEntity httpEntity = httpResponse.getEntity();
            if (httpEntity == null) {
                Log.w((String)G.TAG, (String)"It seems that there is no internet connectivity");
                throw new Exception("no internet connection");
            }
            InputStream inputStream = httpEntity.getContent();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            StringBuilder stringBuilder = new StringBuilder();
            while ((string2 = bufferedReader.readLine()) != null) {
                stringBuilder.append(string2);
            }
            if (BugSenseHandler.I_WANT_TO_DEBUG) {
                Log.i((String)G.TAG, (String)("Event Response: " + stringBuilder.toString()));
            }
        }
        catch (Exception exception) {
            Log.w((String)G.TAG, (String)("Transmitting ping Exception " + exception.getMessage()));
            if (BugSenseHandler.I_WANT_TO_DEBUG) {
                exception.printStackTrace();
            }
            return false;
        }
        return true;
    }

    public static void saveEvent(final String string) {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                block2: {
                    String string4 = EventsMechanism.getFlatLine(string);
                    String string2 = "Event_";
                    String string3 = string2 + String.valueOf(System.currentTimeMillis()) + "-" + Integer.toString(new Random(System.currentTimeMillis()).nextInt(99999));
                    try {
                        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(G.FILES_PATH + "/" + string3));
                        bufferedWriter.write(string4);
                        bufferedWriter.flush();
                        bufferedWriter.close();
                    }
                    catch (IOException iOException) {
                        Log.e((String)G.TAG, (String)"Error saving event data");
                        if (!BugSenseHandler.I_WANT_TO_DEBUG) break block2;
                        iOException.printStackTrace();
                    }
                }
            }
        });
        ExecutorService executorService = BugSense.getExecutor();
        if (thread != null && executorService != null) {
            executorService.submit(thread);
        }
    }
}

