/*
 * Decompiled with CFR 0.152.
 */
package com.bugsense.trace.models;

import android.util.Log;
import com.bugsense.trace.BugSense;
import com.bugsense.trace.BugSenseHandler;
import com.bugsense.trace.CryptoHttpClient;
import com.bugsense.trace.G;
import com.bugsense.trace.Utils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;

public final class PingsMechanism {
    private static final int MAX_PINGS_SIZE = 2;
    private static final int MAX_GNIPS_SIZE = 2;
    private static final int MAX_PERFS_SIZE = 10;
    public static final int PING = 0;
    public static final int GNIP = 1;
    public static final int TRANS_START = 2;
    public static final int TRANS_END = 3;
    private static volatile PingsMechanism instance;

    public static PingsMechanism getInstance() {
        if (instance == null) {
            instance = new PingsMechanism();
        }
        return instance;
    }

    public synchronized void sendSavedPings() {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                File file;
                int n;
                int n2;
                File file2 = new File(G.FILES_PATH);
                if (!file2.exists()) {
                    file2.mkdir();
                }
                FilenameFilter filenameFilter = new FilenameFilter(){

                    @Override
                    public boolean accept(File file, String string) {
                        return string.startsWith("Ping_");
                    }
                };
                FilenameFilter filenameFilter2 = new FilenameFilter(){

                    @Override
                    public boolean accept(File file, String string) {
                        return string.startsWith("Gnip_");
                    }
                };
                FilenameFilter filenameFilter3 = new FilenameFilter(){

                    @Override
                    public boolean accept(File file, String string) {
                        return string.startsWith("Perf_");
                    }
                };
                String[] stringArray = file2.list(filenameFilter);
                String[] stringArray2 = file2.list(filenameFilter2);
                String[] stringArray3 = file2.list(filenameFilter3);
                if (BugSenseHandler.I_WANT_TO_DEBUG) {
                    Log.d((String)G.TAG, (String)("Ping List has: " + stringArray.length + " items"));
                    Log.d((String)G.TAG, (String)("Gnip List has: " + stringArray2.length + " items"));
                    Log.d((String)G.TAG, (String)("Perf List has: " + stringArray3.length + " items"));
                }
                if ((n2 = 2) > stringArray.length) {
                    n2 = stringArray.length;
                }
                int n3 = 0;
                for (n3 = 0; n3 < n2 && PingsMechanism.transmitPingSync(Utils.readFile(G.FILES_PATH + "/" + stringArray[n3])); ++n3) {
                }
                if (n3 >= 1) {
                    for (n = 0; n < stringArray.length; ++n) {
                        try {
                            file = new File(G.FILES_PATH + "/" + stringArray[n]);
                            file.delete();
                            continue;
                        }
                        catch (Exception exception) {
                            Log.e((String)G.TAG, (String)("Error deleting trace file: " + G.FILES_PATH + "/" + stringArray[n]), (Throwable)exception);
                        }
                    }
                }
                if ((n2 = 2) > stringArray2.length) {
                    n2 = stringArray2.length;
                }
                n3 = 0;
                for (n3 = 0; n3 < n2 && PingsMechanism.transmitPingSync(Utils.readFile(G.FILES_PATH + "/" + stringArray2[n3])); ++n3) {
                }
                if (n3 >= 1) {
                    for (n = 0; n < stringArray2.length; ++n) {
                        try {
                            file = new File(G.FILES_PATH + "/" + stringArray2[n]);
                            file.delete();
                            continue;
                        }
                        catch (Exception exception) {
                            Log.e((String)G.TAG, (String)("Error deleting trace file: " + G.FILES_PATH + "/" + stringArray2[n]), (Throwable)exception);
                        }
                    }
                }
                if ((n2 = 10) > stringArray3.length) {
                    n2 = stringArray3.length;
                }
                n3 = 0;
                for (n3 = 0; n3 < n2 && PingsMechanism.transmitPingSync(Utils.readFile(G.FILES_PATH + "/" + stringArray3[n3])); ++n3) {
                }
                if (n3 >= 1) {
                    for (n = 0; n < stringArray3.length; ++n) {
                        try {
                            file = new File(G.FILES_PATH + "/" + stringArray3[n]);
                            file.delete();
                            continue;
                        }
                        catch (Exception exception) {
                            Log.e((String)G.TAG, (String)("Error deleting trace file: " + G.FILES_PATH + "/" + stringArray3[n]), (Throwable)exception);
                        }
                    }
                }
            }
        });
        ExecutorService executorService = BugSense.getExecutor();
        if (thread != null && executorService != null) {
            executorService.submit(thread);
        }
    }

    public static String getFlatLine(int n, String string, String string2, String string3) {
        String string4 = "";
        if (n == 0) {
            string4 = "_ping";
        } else if (n == 1) {
            string4 = "_gnip";
        } else if (n == 2) {
            string4 = "_trstart-" + string;
        } else if (n == 3) {
            string4 = "_trend-" + string;
        }
        String string5 = "3.2.1:" + string4 + ":" + G.PHONE_MODEL + ":" + G.PHONE_BRAND + ":" + G.ANDROID_VERSION + ":" + G.APP_VERSION + ":" + Locale.getDefault().getDisplayLanguage() + ":" + Utils.getTime();
        if (string2 != null && string3 != null && string2.length() > 0 && string3.length() > 0) {
            string5 = string5 + ":" + string2 + ":" + string3;
        }
        return string5;
    }

    public static void transmitPingASync(int n) {
        PingsMechanism.transmitPingASync(PingsMechanism.getFlatLine(n, null, null, null), n);
    }

    public static void transmitPingASync(final String string, final int n) {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                if (!PingsMechanism.transmitPingSync(string)) {
                    PingsMechanism.savePing(n, null, null, null);
                }
            }
        });
        ExecutorService executorService = BugSense.getExecutor();
        if (thread != null && executorService != null) {
            executorService.submit(thread);
        }
    }

    public static boolean transmitPingSync(String string) {
        if (BugSenseHandler.I_WANT_TO_DEBUG) {
            Log.d((String)G.TAG, (String)("URL: " + G.ANALYTICS_URL));
            Log.d((String)G.TAG, (String)("APIKEY: " + G.API_KEY));
        }
        try {
            String string2;
            DefaultHttpClient defaultHttpClient = null;
            defaultHttpClient = G.ANALYTICS_URL.startsWith("https://") ? new CryptoHttpClient(0) : new DefaultHttpClient();
            HttpParams httpParams = defaultHttpClient.getParams();
            HttpProtocolParams.setUseExpectContinue((HttpParams)httpParams, (boolean)false);
            HttpConnectionParams.setConnectionTimeout((HttpParams)httpParams, (int)20000);
            HttpConnectionParams.setSoTimeout((HttpParams)httpParams, (int)20000);
            HttpPost httpPost = new HttpPost(G.ANALYTICS_URL);
            httpPost.addHeader("X-BugSense-Api-Key", G.API_KEY);
            ArrayList<BasicNameValuePair> arrayList = new ArrayList<BasicNameValuePair>();
            arrayList.add(new BasicNameValuePair("data", string));
            httpPost.setEntity((HttpEntity)new StringEntity(string));
            HttpResponse httpResponse = defaultHttpClient.execute((HttpUriRequest)httpPost);
            HttpEntity httpEntity = httpResponse.getEntity();
            if (httpEntity == null) {
                Log.w((String)G.TAG, (String)"It seems that there is no internet connectivity");
                throw new Exception("no internet connection");
            }
            InputStream inputStream = httpEntity.getContent();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            StringBuilder stringBuilder = new StringBuilder();
            while ((string2 = bufferedReader.readLine()) != null) {
                stringBuilder.append(string2);
            }
            if (BugSenseHandler.I_WANT_TO_DEBUG) {
                Log.i((String)G.TAG, (String)("Ping Response: " + stringBuilder.toString()));
            }
        }
        catch (Exception exception) {
            Log.w((String)G.TAG, (String)("Transmitting ping Exception " + exception.getMessage()));
            if (BugSenseHandler.I_WANT_TO_DEBUG) {
                exception.printStackTrace();
            }
            return false;
        }
        return true;
    }

    public static void savePing(final int n, final String string) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                if (n == 2 || n == 3) {
                    PingsMechanism.savePing(n, string, Utils.getCPU(), Utils.getMem());
                } else {
                    PingsMechanism.savePing(n, null, null, null);
                }
            }
        }).start();
    }

    public static void savePing(final int n, final String string, final String string2, final String string3) {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                block4: {
                    String string4 = PingsMechanism.getFlatLine(n, string, string2, string3);
                    String string22 = "Ping_";
                    if (n == 1) {
                        string22 = "Gnip_";
                    }
                    if (n == 2 || n == 3) {
                        string22 = "Perf_";
                    }
                    String string32 = string22 + String.valueOf(System.currentTimeMillis()) + "-" + Integer.toString(new Random(System.currentTimeMillis()).nextInt(99999));
                    try {
                        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(G.FILES_PATH + "/" + string32));
                        bufferedWriter.write(string4);
                        bufferedWriter.flush();
                        bufferedWriter.close();
                    }
                    catch (IOException iOException) {
                        Log.e((String)G.TAG, (String)"Error saving ping data");
                        if (!BugSenseHandler.I_WANT_TO_DEBUG) break block4;
                        iOException.printStackTrace();
                    }
                }
            }
        });
        ExecutorService executorService = BugSense.getExecutor();
        if (thread != null && executorService != null) {
            executorService.submit(thread);
        }
    }
}

