/*
 * Decompiled with CFR 0.152.
 */
package com.dhf.doj;

import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.os.Build;
import android.os.Environment;
import android.os.Handler;
import android.util.Log;
import com.dhf.doj.AdCallbackListener;
import com.dhf.doj.AsyncTaskCompleteListener;
import com.dhf.doj.BrowserActivity;
import com.dhf.doj.Caching;
import com.dhf.doj.FormatAds;
import com.dhf.doj.HttpPostDataTask;
import com.dhf.doj.IconAds;
import com.dhf.doj.NetworkThread;
import com.dhf.doj.OverlayAd;
import com.dhf.doj.PushService;
import com.dhf.doj.SDKIntializer;
import com.dhf.doj.SendIntegrationError;
import com.dhf.doj.SetPreferences;
import com.dhf.doj.SmartWallActivity;
import com.dhf.doj.UserDetails;
import com.dhf.doj.Util;
import com.dhf.doj.VideoAd;
import com.dhf.doj.VideoAdActivity;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;
import org.json.JSONException;
import org.json.JSONObject;

public class AirSDK
extends SDKIntializer {
    static final String TAG = "AirSDK";
    private static Context mContext;
    private static boolean isDialogClosed;
    private static boolean isShowOptinDialog;
    private static AdCallbackListener.OptinListener optinListener;
    static AdCallbackListener adCallbackListener;
    static FormatAds.ParseMraidJson parseMraidJson;
    static Handler handler;
    private static boolean isIntegrationIssue;
    static boolean enableCaching;
    private Caching caching;
    Runnable optinRunnable = new Runnable(){

        public void run() {
            try {
                Intent intent = new Intent(mContext, SmartWallActivity.class);
                intent.setFlags(0x10000000);
                intent.addFlags(0x20000000);
                intent.addFlags(0x800000);
                mContext.startActivity(intent);
            }
            catch (ActivityNotFoundException e) {
                Log.e((String)AirSDK.TAG, (String)"Required SmartWallActivity not declared in Manifest, Please add.");
                SDKIntializer.sendIntegrationError("Required SmartWallActivity not declared in Manifest, Please add.");
            }
            catch (Exception e) {
                Log.e((String)AirSDK.TAG, (String)("Error in Optin runnable: " + e.getMessage()));
            }
        }
    };

    public AirSDK(Context context, AdCallbackListener adCallbackListener, boolean enableCaching) {
        Log.i((String)TAG, (String)"Starting SDK.");
        AirSDK.adCallbackListener = adCallbackListener;
        AirSDK.enableCaching = enableCaching;
        try {
            handler = new Handler();
            if (context == null) {
                Log.e((String)TAG, (String)"Context must not be null.");
                AirSDK.sendIntegrationError("Context must not be null.");
                isIntegrationIssue = true;
                return;
            }
            mContext = context;
            Util.setContext(mContext);
            if (!this.checkSmartWallActivity()) {
                return;
            }
            isDialogClosed = false;
            Util.startBusense(mContext);
            if (!AirSDK.checkRequiredDetails(mContext)) {
                isIntegrationIssue = true;
                return;
            }
            isIntegrationIssue = false;
            Util.setSESSION_ID();
            Log.i((String)TAG, (String)("Caching enabled: " + enableCaching));
            SharedPreferences SDKPrefs = context.getSharedPreferences("sdkPrefs", 0);
            if (SDKPrefs == null || !SDKPrefs.contains("SDKEnabled")) {
                AirSDK.enableSDK(context, true);
            }
            if (isShowOptinDialog = SetPreferences.isShowOptinDialog(mContext)) {
                new Thread(this.optinRunnable, "optin_thread").start();
            } else {
                this.sendUserInfo();
            }
            this.caching = new Caching(context);
        }
        catch (Exception exception) {
            Log.e((String)TAG, (String)"Error while starting in-app sdk ", (Throwable)exception);
        }
    }

    AirSDK() {
        try {
            isDialogClosed = true;
            isShowOptinDialog = SetPreferences.isShowOptinDialog(mContext);
            if (!AirSDK.checkRequiredDetails(mContext)) {
                isIntegrationIssue = true;
                return;
            }
            isIntegrationIssue = false;
            if (!isShowOptinDialog) {
                this.sendUserInfo();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void sendUserInfo() {
        if (SetPreferences.isDeviceBlackListed(mContext)) {
            Log.w((String)TAG, (String)"Device blacklisted.");
            return;
        }
        if (AirSDK.isSDKEnabled(mContext)) {
            try {
                AsyncTaskCompleteListener<String> asyncTaskCompleteListener = new AsyncTaskCompleteListener<String>(){

                    @Override
                    public void launchNewHttpTask() {
                        Log.i((String)AirSDK.TAG, (String)"Sending user info...>>>>");
                        ArrayList<NameValuePair> values = new ArrayList<NameValuePair>();
                        values.add((NameValuePair)new BasicNameValuePair("model", "user"));
                        values.add((NameValuePair)new BasicNameValuePair("action", "setuserinfo"));
                        values.add((NameValuePair)new BasicNameValuePair("type", "app"));
                        NetworkThread networkThread = new NetworkThread(mContext, this, values, "https://api.airpush.com/v2/api.php", 20000L, true);
                        new Thread((Runnable)networkThread, "sn").start();
                    }

                    @Override
                    public void onTaskComplete(String result) {
                        Log.i((String)AirSDK.TAG, (String)("Info sent: " + result));
                        long startTime = SetPreferences.getAppListStartTime(mContext);
                        if (startTime == 0L || startTime < System.currentTimeMillis()) {
                            try {
                                if (Util.checkInternetConnection(mContext)) {
                                    new SetPreferences((Context)mContext).sendAppInfoAsyncTaskCompleteListener.launchNewHttpTask();
                                }
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                        }
                    }
                };
                if (Util.checkInternetConnection(mContext)) {
                    asyncTaskCompleteListener.launchNewHttpTask();
                }
            }
            catch (Exception e) {
                Log.i((String)"Activitymanager", (String)e.toString());
            }
        }
    }

    public void startPushNotification(boolean testMode) {
        try {
            if (isShowOptinDialog) {
                SharedPreferences preferences = mContext.getSharedPreferences("enableAdPref", 0);
                SharedPreferences.Editor editor = preferences.edit();
                editor.putBoolean("doPush", true);
                editor.putBoolean("testMode", testMode);
                editor.commit();
                return;
            }
            if (SetPreferences.isDeviceBlackListed(mContext)) {
                Log.w((String)TAG, (String)"Can not start pushes device blacklisted.");
                return;
            }
            if (isIntegrationIssue) {
                return;
            }
            Util.setTestmode(testMode);
            Util.setDoPush(true);
            PushService.startAirpush(mContext);
        }
        catch (Exception e) {
            Util.printLog("Error in Start Push Notification: " + e.getMessage());
        }
    }

    public void startIconAd() {
        try {
            if (isShowOptinDialog) {
                SharedPreferences preferences = mContext.getSharedPreferences("enableAdPref", 0);
                SharedPreferences.Editor editor = preferences.edit();
                editor.putBoolean("icon", true);
                editor.commit();
                return;
            }
            if (SetPreferences.isDeviceBlackListed(mContext)) {
                Log.e((String)TAG, (String)"Can not start icon ad device blacklisted.");
                return;
            }
            Log.i((String)TAG, (String)"Push IconSearch....true");
            if (!isIntegrationIssue) {
                if (0 == mContext.checkCallingOrSelfPermission("com.android.launcher.permission.INSTALL_SHORTCUT")) {
                    if (AirSDK.isSDKEnabled(mContext)) {
                        new IconAds(mContext);
                    } else {
                        Log.i((String)TAG, (String)"AirSDK is disabled, Please enable it to receive Icon ad. ");
                    }
                } else {
                    Log.i((String)TAG, (String)"Installing shortcut permission not found in Manifest, please add.");
                    AirSDK.sendIntegrationError("Installing shortcut permission not found in Manifest, please add.");
                    new SendIntegrationError(mContext, 108);
                }
            }
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"Error in StartIconAd: ", (Throwable)e);
        }
    }

    public void startSmartWallAd() {
        try {
            if (!isDialogClosed && isShowOptinDialog) {
                SharedPreferences preferences = mContext.getSharedPreferences("enableAdPref", 0);
                SharedPreferences.Editor editor = preferences.edit();
                editor.putBoolean("interstitialads", true);
                editor.commit();
                return;
            }
            Log.i((String)TAG, (String)"Initialising SmartWall.....");
            if (isIntegrationIssue || !this.checkSmartWallintegration()) {
                return;
            }
            boolean available = Util.isIntentAvailable(mContext, VideoAdActivity.class);
            if (!available) {
                String err = "Required VideoAdActivity not found in Manifest. Please add";
                Log.e((String)TAG, (String)err);
                AirSDK.sendIntegrationError(err);
                new SendIntegrationError(mContext, 102);
                return;
            }
            if (mContext != null && AirSDK.isSDKEnabled(mContext)) {
                if (SetPreferences.getNextAdCallTime(mContext) > System.currentTimeMillis()) {
                    Log.i((String)TAG, (String)"SmartWall Ad called within 10 secs. Ignoring request.");
                    AirSDK.sendAdError("SmartWall Ad called within 10  secs. Ignoring request.");
                    return;
                }
                if (SmartWallActivity.isShowing()) {
                    Log.i((String)TAG, (String)"Another ad is showing on screen.");
                    AirSDK.sendAdError("Another ad is showing on screen.");
                    return;
                }
                SetPreferences.setNextAdCallTime(mContext);
                AsyncTaskCompleteListener<String> asyncTaskCompleteListener = new AsyncTaskCompleteListener<String>(){

                    @Override
                    public void onTaskComplete(String result) {
                        Log.i((String)AirSDK.TAG, (String)("SmartWall JSON: " + result));
                        try {
                            String adtype;
                            if (result == null) {
                                return;
                            }
                            JSONObject jsonObject = new JSONObject(result);
                            int status = jsonObject.isNull("status") ? 0 : jsonObject.getInt("status");
                            String msg = jsonObject.isNull("message") ? "" : jsonObject.getString("message");
                            String string = adtype = jsonObject.isNull("adtype") ? "" : jsonObject.getString("adtype");
                            if (status == 200 && msg.equalsIgnoreCase("Success") && !adtype.equals("")) {
                                if (enableCaching) {
                                    if (result.startsWith("<VAST>") && Build.VERSION.SDK_INT > 7) {
                                        VideoAd videoAd = new VideoAd(mContext);
                                        videoAd.parseVideoAd(result);
                                        return;
                                    }
                                    AirSDK.this.caching.saveJson(AdCallbackListener.AdType.smartwall, result);
                                    SDKIntializer.sendAdCached(AdCallbackListener.AdType.smartwall);
                                    AirSDK.this.caching.setSmartWallAd(true);
                                } else {
                                    AirSDK.this.parseSmartwallJson(result);
                                }
                            }
                        }
                        catch (Exception e) {
                            Log.e((String)AirSDK.TAG, (String)"Error: ", (Throwable)e);
                        }
                    }

                    @Override
                    public void launchNewHttpTask() {
                        try {
                            List<NameValuePair> nameValuePairs = SetPreferences.setValues(mContext);
                            Util.printDebugLog("Interstitial values: " + nameValuePairs);
                            HttpPostDataTask httpPostTask = new HttpPostDataTask(mContext, nameValuePairs, "https://api.airpush.com/lp/getinterstitialads.php", this);
                            httpPostTask.execute(new Void[0]);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                };
                if (Util.checkInternetConnection(mContext)) {
                    asyncTaskCompleteListener.launchNewHttpTask();
                }
            } else {
                Log.i((String)TAG, (String)"AirSDK is disabled Please enable to recive ads.");
                AirSDK.sendAdError("AirSDK is disabled Please enable to recive ads.");
            }
        }
        catch (Exception exception) {
            Log.e((String)TAG, (String)"Error occurred in startSmartWall method: ", (Throwable)exception);
        }
    }

    void parseSmartwallJson(String result) {
        try {
            String adtype;
            if (result.startsWith("<VAST>") && Build.VERSION.SDK_INT > 7) {
                VideoAd videoAd = new VideoAd(mContext);
                videoAd.parseVideoAd(result);
                return;
            }
            JSONObject jsonObject = new JSONObject(result);
            int status = jsonObject.isNull("status") ? 0 : jsonObject.getInt("status");
            String msg = jsonObject.isNull("message") ? "" : jsonObject.getString("message");
            String string = adtype = jsonObject.isNull("adtype") ? "" : jsonObject.getString("adtype");
            if (status == 200 && !adtype.equals("")) {
                if (adtype.equalsIgnoreCase("AW")) {
                    this.parseAppWallJson(result);
                } else if (adtype.equals("OLAU") || adtype.equals("DAU") || adtype.equals("DCC") || adtype.equals("DCM")) {
                    this.showOverlayAd(result);
                } else if (!adtype.equals("") && adtype.equalsIgnoreCase("FP")) {
                    this.parseLandingPageAdJson(result);
                } else if (!adtype.equals("") && adtype.equalsIgnoreCase("MFP")) {
                    this.parseRichMediaInterstitialJson(jsonObject);
                } else {
                    Log.i((String)TAG, (String)("Invalid ad type delivered in SmartWall: " + adtype));
                }
            } else {
                AirSDK.validateStatusCode(status, msg);
            }
        }
        catch (JSONException e) {
            Log.e((String)TAG, (String)"Error in Smart Wall json: ", (Throwable)e);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"Error in Smart Wall response: ", (Throwable)e);
        }
    }

    public void startAppWall() {
        try {
            if (!isDialogClosed && isShowOptinDialog) {
                SharedPreferences preferences = mContext.getSharedPreferences("enableAdPref", 0);
                SharedPreferences.Editor editor = preferences.edit();
                editor.putBoolean("appwall", true);
                editor.commit();
                return;
            }
            Log.i((String)TAG, (String)"Initialising AppWall.....");
            if (isIntegrationIssue || !this.checkSmartWallActivity()) {
                return;
            }
            if (AirSDK.isSDKEnabled(mContext)) {
                if (SetPreferences.getNextAdCallTime(mContext) > System.currentTimeMillis()) {
                    Log.i((String)TAG, (String)"AppWall called within 10 secs. Ignoring request");
                    AirSDK.sendAdError("AppWall called within 10 secs. Ignoring request.");
                    return;
                }
                if (SmartWallActivity.isShowing()) {
                    Log.i((String)TAG, (String)"Another ad is showing on screen.");
                    AirSDK.sendAdError("Another ad is showing on screen.");
                    return;
                }
                SetPreferences.setNextAdCallTime(mContext);
                AsyncTaskCompleteListener<String> asyncTaskCompleteListener = new AsyncTaskCompleteListener<String>(){

                    @Override
                    public void onTaskComplete(String result) {
                        Log.i((String)AirSDK.TAG, (String)("AppWall Json: " + result));
                        try {
                            if (result == null) {
                                return;
                            }
                            if (enableCaching) {
                                String msg;
                                JSONObject jsonObject = new JSONObject(result);
                                int status = jsonObject.isNull("status") ? 0 : jsonObject.getInt("status");
                                String string = msg = jsonObject.isNull("message") ? "invalid" : jsonObject.getString("message");
                                if (status == 200 && msg.equalsIgnoreCase("Success")) {
                                    AirSDK.this.caching.saveJson(AdCallbackListener.AdType.appwall, result);
                                    SDKIntializer.sendAdCached(AdCallbackListener.AdType.appwall);
                                } else {
                                    AirSDK.validateStatusCode(status, msg);
                                }
                            } else {
                                AirSDK.this.parseAppWallJson(result);
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }

                    @Override
                    public void launchNewHttpTask() {
                        try {
                            List<NameValuePair> nameValuePairs = SetPreferences.setValues(mContext);
                            Util.printDebugLog("AppWall AD Values: " + nameValuePairs);
                            HttpPostDataTask httpPostTask = new HttpPostDataTask(mContext, nameValuePairs, "https://api.airpush.com/appwall/getid.php", this);
                            httpPostTask.execute(new Void[0]);
                        }
                        catch (NullPointerException e) {
                            e.printStackTrace();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                };
                if (Util.checkInternetConnection(mContext)) {
                    asyncTaskCompleteListener.launchNewHttpTask();
                }
            } else {
                Log.i((String)TAG, (String)"AirSDK is disabled Please enable to recive ads.");
                AirSDK.sendAdError("AirSDK is disabled Please enable to recive ads.");
            }
        }
        catch (Exception exception) {
            Log.e((String)TAG, (String)"Error occurred in appwall ", (Throwable)exception);
        }
    }

    void parseAppWallJson(String json) {
        try {
            String msg;
            JSONObject jsonObject = new JSONObject(json);
            int status = jsonObject.isNull("status") ? 0 : jsonObject.getInt("status");
            String string = msg = jsonObject.isNull("message") ? "" : jsonObject.getString("message");
            if (status == 200 && msg.equals("Success")) {
                final String url = jsonObject.getString("url");
                if (url != null && !url.equals("")) {
                    SetPreferences.setNextAdCallTime(mContext);
                    Runnable appwallRunnable = new Runnable(){

                        public void run() {
                            Intent intent = new Intent(mContext, SmartWallActivity.class);
                            intent.setFlags(0x10000000);
                            intent.addFlags(0x20000000);
                            intent.addFlags(0x800000);
                            intent.setAction("appwallad");
                            intent.putExtra("adtype", "AW");
                            intent.putExtra("url", url);
                            try {
                                mContext.startActivity(intent);
                            }
                            catch (ActivityNotFoundException e) {
                                Log.e((String)AirSDK.TAG, (String)"Required SmartWallActivity not found in Manifest. Please add.");
                            }
                        }
                    };
                    new Thread(appwallRunnable, "Appwall").start();
                }
            } else {
                AirSDK.validateStatusCode(status, msg);
            }
        }
        catch (JSONException e) {
            Log.e((String)TAG, (String)"Error in AppWall json: ", (Throwable)e);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"Error in AppWall response: ", (Throwable)e);
        }
    }

    public void startLandingPageAd() {
        try {
            if (!isDialogClosed && isShowOptinDialog) {
                SharedPreferences preferences = mContext.getSharedPreferences("enableAdPref", 0);
                SharedPreferences.Editor editor = preferences.edit();
                editor.putBoolean("landingpagead", true);
                editor.commit();
                return;
            }
            Log.i((String)TAG, (String)"Initialising LandingPage AD.....");
            if (isIntegrationIssue || !this.checkSmartWallActivity()) {
                return;
            }
            if (AirSDK.isSDKEnabled(mContext)) {
                if (SetPreferences.getNextAdCallTime(mContext) > System.currentTimeMillis()) {
                    Log.i((String)TAG, (String)"LandingPage Ad called within 10 secs. Ignoring request");
                    AirSDK.sendAdError("LandingPage Ad called within 10 secs. Ignoring request");
                    return;
                }
                if (SmartWallActivity.isShowing()) {
                    Log.i((String)TAG, (String)"Another ad is showing on screen.");
                    AirSDK.sendAdError("Another ad is showing on screen.");
                    return;
                }
                SetPreferences.setNextAdCallTime(mContext);
                AsyncTaskCompleteListener<String> asyncTaskCompleteListener = new AsyncTaskCompleteListener<String>(){

                    @Override
                    public void onTaskComplete(String result) {
                        Log.i((String)AirSDK.TAG, (String)("LandingPage Json: " + result));
                        try {
                            if (result == null) {
                                return;
                            }
                            if (enableCaching) {
                                String msg;
                                JSONObject jsonObject = new JSONObject(result);
                                int status = jsonObject.isNull("status") ? 0 : jsonObject.getInt("status");
                                String string = msg = jsonObject.isNull("message") ? "invalid" : jsonObject.getString("message");
                                if (status == 200 && msg.equalsIgnoreCase("Success")) {
                                    AirSDK.this.caching.saveJson(AdCallbackListener.AdType.landing_page, result);
                                    SDKIntializer.sendAdCached(AdCallbackListener.AdType.landing_page);
                                } else {
                                    AirSDK.validateStatusCode(status, msg);
                                }
                            } else {
                                AirSDK.this.parseLandingPageAdJson(result);
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }

                    @Override
                    public void launchNewHttpTask() {
                        try {
                            List<NameValuePair> nameValuePairs = SetPreferences.setValues(mContext);
                            Util.printDebugLog("LandingPage AD Values: " + nameValuePairs);
                            HttpPostDataTask httpPostTask = new HttpPostDataTask(mContext, nameValuePairs, "https://api.airpush.com/fullpage/adcall.php", this);
                            httpPostTask.execute(new Void[0]);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                };
                if (Util.checkInternetConnection(mContext)) {
                    asyncTaskCompleteListener.launchNewHttpTask();
                }
            } else {
                Log.i((String)TAG, (String)"AirSDK is disabled Please enable to recive ads.");
                AirSDK.sendAdError("AirSDK is disabled Please enable to recive ads.");
            }
        }
        catch (Exception exception) {
            Log.e((String)TAG, (String)"Error occurred in LandingPage ad: ", (Throwable)exception);
        }
    }

    void parseLandingPageAdJson(String json) {
        if (json != null) {
            try {
                String msg;
                String invalid = "invalid";
                JSONObject jsonObject = new JSONObject(json);
                int status = jsonObject.isNull("status") ? 200 : jsonObject.getInt("status");
                String string = msg = jsonObject.isNull("message") ? invalid : jsonObject.getString("message");
                if (status == 200 && msg.equals("Success")) {
                    String url;
                    String string2 = url = jsonObject.isNull("url") ? invalid : jsonObject.getString("url");
                    if (!url.equals(invalid)) {
                        SetPreferences.setNextAdCallTime(mContext);
                        Intent intent = new Intent(mContext, SmartWallActivity.class);
                        intent.setAction("lpad");
                        intent.setFlags(0x10000000);
                        intent.addFlags(0x20000000);
                        intent.addFlags(0x800000);
                        intent.putExtra("adtype", "FP");
                        intent.putExtra("url", url);
                        try {
                            mContext.startActivity(intent);
                        }
                        catch (ActivityNotFoundException e) {
                            Log.e((String)TAG, (String)"Required SmartWallActivity not found in Manifest. Please add.");
                        }
                        catch (Exception e) {}
                    }
                } else {
                    AirSDK.validateStatusCode(status, msg);
                }
            }
            catch (JSONException e) {
                Log.e((String)TAG, (String)"Error occurred while parsing LandingPage Json: ", (Throwable)e);
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)"Error occured in LandingPage Json: ", (Throwable)e);
            }
        }
    }

    static void startNewAdThread(boolean isOptin) {
        try {
            handler.postDelayed(new Runnable(){

                public void run() {
                    SetPreferences.enableADPref(mContext);
                }
            }, 3000L);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"An error occured while starting new thread. ", (Throwable)e);
            SetPreferences.enableADPref(mContext);
        }
    }

    static AdCallbackListener.OptinListener getOptinListener() {
        return optinListener;
    }

    public static void setOptinListener(AdCallbackListener.OptinListener optinListener) {
        AirSDK.optinListener = optinListener;
    }

    public void showRichMediaInterstitialAd() {
        try {
            if (!isDialogClosed && isShowOptinDialog) {
                SharedPreferences preferences = mContext.getSharedPreferences("enableAdPref", 0);
                SharedPreferences.Editor editor = preferences.edit();
                editor.putBoolean("rich_media", true);
                editor.commit();
                return;
            }
            Log.i((String)TAG, (String)"Initialising Rich Media Interstitial Ad.....");
            if (isIntegrationIssue || !this.checkSmartWallintegration()) {
                return;
            }
            if (AirSDK.isSDKEnabled(mContext)) {
                if (SetPreferences.getNextAdCallTime(mContext) > System.currentTimeMillis()) {
                    String err = "Rich Media Interstitial Ad called within 10 secs. Ignoring request";
                    Log.i((String)TAG, (String)err);
                    AirSDK.sendAdError(err);
                    return;
                }
                if (SmartWallActivity.isShowing()) {
                    Log.i((String)TAG, (String)"Another ad is showing on screen.");
                    AirSDK.sendAdError("Another ad is showing on screen.");
                    return;
                }
                SetPreferences.setNextAdCallTime(mContext);
                AsyncTaskCompleteListener<String> asyncTaskCompleteListener = new AsyncTaskCompleteListener<String>(){

                    @Override
                    public void onTaskComplete(String result) {
                        block7: {
                            Log.i((String)AirSDK.TAG, (String)("Rich Media Ad Json: " + result));
                            try {
                                String adtype;
                                if (result == null) {
                                    return;
                                }
                                JSONObject jsonObject = new JSONObject(result);
                                int status = jsonObject.isNull("status") ? 0 : jsonObject.getInt("status");
                                String msg = jsonObject.isNull("message") ? "invalid" : jsonObject.getString("message");
                                String string = adtype = jsonObject.isNull("adtype") ? null : jsonObject.getString("adtype");
                                if (adtype == null || !adtype.equals("MFP")) {
                                    Log.w((String)AirSDK.TAG, (String)("Invalid adtype: " + adtype));
                                    return;
                                }
                                if (status == 200 && msg.equalsIgnoreCase("Success")) {
                                    if (enableCaching) {
                                        AirSDK.this.caching.saveJson(AdCallbackListener.AdType.interstitial, result);
                                        SDKIntializer.sendAdCached(AdCallbackListener.AdType.interstitial);
                                    } else {
                                        AirSDK.this.parseRichMediaInterstitialJson(jsonObject);
                                    }
                                    break block7;
                                }
                                AirSDK.validateStatusCode(status, msg);
                                return;
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    }

                    @Override
                    public void launchNewHttpTask() {
                        try {
                            ArrayList<NameValuePair> list = new ArrayList<NameValuePair>();
                            list.add((NameValuePair)new BasicNameValuePair("banner_type", "rich_media"));
                            list.add((NameValuePair)new BasicNameValuePair("supports", "" + Util.getSupportsJson(mContext)));
                            list.add((NameValuePair)new BasicNameValuePair("placement_type", "fullpage"));
                            NetworkThread networkThread = new NetworkThread(mContext, this, list, "https://api.airpush.com/mraid/mraidadcall.php", 0L, true);
                            Thread thread = new Thread((Runnable)networkThread, "AdView");
                            thread.start();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                };
                if (Util.checkInternetConnection(mContext)) {
                    asyncTaskCompleteListener.launchNewHttpTask();
                }
            } else {
                Log.i((String)TAG, (String)"AirSDK is disabled Please enable to recive ads.");
                AirSDK.sendAdError("AirSDK is disabled Please enable to recive ads.");
            }
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"Error occurred in Rich Media interstital ad: ", (Throwable)e);
        }
    }

    void parseRichMediaInterstitialJson(JSONObject jsonObject) {
        try {
            parseMraidJson = new FormatAds.ParseMraidJson(mContext, jsonObject);
            String doc = Util.getDoc(mContext);
            if (doc != null && !doc.equals("")) {
                SetPreferences.setNextAdCallTime(mContext);
                Intent intent = new Intent(mContext, SmartWallActivity.class);
                intent.setAction("mfpad");
                intent.setFlags(0x10000000);
                intent.addFlags(0x800000);
                intent.addFlags(0x20000000);
                intent.putExtra("adtype", "MFP");
                mContext.startActivity(intent);
                return;
            }
            AsyncTaskCompleteListener<Boolean> getDoc = new AsyncTaskCompleteListener<Boolean>(){

                @Override
                public void onTaskComplete(Boolean result) {
                    if (result.booleanValue()) {
                        SetPreferences.setNextAdCallTime(mContext);
                        Intent intent = new Intent(mContext, SmartWallActivity.class);
                        intent.setAction("mfpad");
                        intent.setFlags(0x10000000);
                        intent.addFlags(0x800000);
                        intent.addFlags(0x20000000);
                        intent.putExtra("adtype", "MFP");
                        mContext.startActivity(intent);
                    } else {
                        Log.e((String)AirSDK.TAG, (String)"Not able to get doc.");
                    }
                }

                @Override
                public void launchNewHttpTask() {
                    Util.NativeMraid nativeMraid = new Util.NativeMraid(mContext, this);
                    new Thread((Runnable)nativeMraid, "native").start();
                }
            };
            if (Util.checkInternetConnection(mContext)) {
                getDoc.launchNewHttpTask();
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            AirSDK.sendAdError(e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void startVideoAd() {
        try {
            if (Build.VERSION.SDK_INT < 8) {
                String err = "Video ad supported on Android 2.2 and later devices.";
                Log.e((String)TAG, (String)err);
                AirSDK.sendAdError(err);
                return;
            }
            if (!isDialogClosed && isShowOptinDialog) {
                SharedPreferences preferences = mContext.getSharedPreferences("enableAdPref", 0);
                SharedPreferences.Editor editor = preferences.edit();
                editor.putBoolean("videoad", true);
                editor.commit();
                System.out.println("isDialog " + isDialogClosed + " opt " + isShowOptinDialog);
                return;
            }
            Log.i((String)TAG, (String)"Initialising video ad.....");
            if (!AirSDK.isSDKEnabled(mContext)) {
                Log.e((String)TAG, (String)"AirSDK is disabled please enable to receive ads.");
                return;
            }
            if (isIntegrationIssue || !VideoAd.checkVideoAdPermission(mContext)) {
                Log.e((String)TAG, (String)"Integration issue is there");
                return;
            }
            boolean available = Util.isIntentAvailable(mContext, VideoAdActivity.class);
            if (!available) {
                String err = "Required VideoAdActivity not found in Manifest. Please add";
                Log.e((String)TAG, (String)err);
                AirSDK.sendIntegrationError(err);
                new SendIntegrationError(mContext, 102);
                return;
            }
            String mediaState = Environment.getExternalStorageState();
            if (mediaState != null && mediaState.equalsIgnoreCase("mounted")) {
                if (SmartWallActivity.isShowing()) {
                    String err = "Another ad is already showing on screen.";
                    Log.w((String)TAG, (String)err);
                    AirSDK.sendAdError(err);
                    return;
                }
                if (System.currentTimeMillis() < SetPreferences.getNextVideoAdCallTime(mContext)) {
                    String err = "Video ad is called before 30 secs. Ignoring request.";
                    Log.w((String)TAG, (String)err);
                    AirSDK.sendAdError(err);
                    return;
                }
                VideoAd ad = new VideoAd(mContext);
                if (!Util.checkInternetConnection(mContext)) return;
                ad.launchNewHttpTask();
                return;
            }
            String err = "Can't call video ad at this time. SD card not mounted.";
            Log.w((String)TAG, (String)err);
            AirSDK.sendAdError(err);
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static final void validateStatusCode(int status, String message) {
        if (message == null || message.equals("")) {
            return;
        }
        switch (status) {
            case 100: {
                AirSDK.sendIntegrationError(message);
                break;
            }
            case 120: {
                AirSDK.sendIntegrationError(message);
                break;
            }
            case 130: {
                AirSDK.sendIntegrationError(message);
                break;
            }
            case 204: {
                AirSDK.sendAdError(message);
                break;
            }
            case 150: {
                AirSDK.sendAdError(message);
                break;
            }
        }
    }

    static boolean checkRequiredDetails(Context mContext) {
        boolean result = true;
        try {
            UserDetails details;
            if (mContext == null) {
                Log.e((String)TAG, (String)"Context is null.");
                AirSDK.sendIntegrationError("Context is null");
                result = false;
            }
            if (!AirSDK.getDataFromManifest(mContext)) {
                result = false;
            }
            if (!AirSDK.checkRequiredPermission(mContext)) {
                result = false;
            }
            if (!(details = new UserDetails(mContext)).setImeiInMd5()) {
                result = false;
            }
            new SetPreferences(mContext).setPreferencesData();
            result = SetPreferences.getDataSharedPrefrences(mContext);
        }
        catch (Exception exception) {
            Log.e((String)TAG, (String)"Error occurred while checking required details: ", (Throwable)exception);
            result = false;
        }
        return result;
    }

    private boolean checkSmartWallintegration() {
        boolean result = true;
        try {
            result = this.checkSmartWallActivity();
            if (!Util.isIntentAvailable(mContext, BrowserActivity.class)) {
                String err = "Required BrowserActivity not found in Manifest. Please add.";
                Log.e((String)TAG, (String)err);
                AirSDK.sendIntegrationError(err);
                new SendIntegrationError(mContext, 104);
                result = false;
            }
        }
        catch (Exception exception) {
            Log.e((String)TAG, (String)"Error occurred while validating SmartWall: ", (Throwable)exception);
            result = false;
        }
        return result;
    }

    private boolean checkSmartWallActivity() throws NullPointerException, Exception {
        if (!Util.isIntentAvailable(mContext, SmartWallActivity.class)) {
            String err = "Required SmartWallActivity not found in Manifest. Please add.";
            Log.e((String)TAG, (String)err);
            AirSDK.sendIntegrationError(err);
            new SendIntegrationError(mContext, 103);
            return false;
        }
        return true;
    }

    public void startOverlayAd() {
        try {
            if (!isDialogClosed && isShowOptinDialog) {
                SharedPreferences preferences = mContext.getSharedPreferences("enableAdPref", 0);
                SharedPreferences.Editor editor = preferences.edit();
                editor.putBoolean("overylayad", true);
                editor.commit();
                return;
            }
            Log.i((String)TAG, (String)"Initialising Overlay AD.....");
            if (isIntegrationIssue || !this.checkSmartWallActivity()) {
                return;
            }
            if (AirSDK.isSDKEnabled(mContext)) {
                if (SetPreferences.getNextAdCallTime(mContext) > System.currentTimeMillis()) {
                    Log.i((String)TAG, (String)"Overlay Ad called within 10 secs. Ignoring request");
                    AirSDK.sendAdError("Overlay Ad called within 10 secs. Ignoring request");
                    return;
                }
                if (SmartWallActivity.isShowing()) {
                    Log.i((String)TAG, (String)"Another ad is showing on screen.");
                    AirSDK.sendAdError("Another ad is showing on screen.");
                    return;
                }
                SetPreferences.setNextAdCallTime(mContext);
                AsyncTaskCompleteListener<String> asyncTaskCompleteListener = new AsyncTaskCompleteListener<String>(){

                    @Override
                    public void onTaskComplete(String result) {
                        Log.i((String)AirSDK.TAG, (String)("Overlay Json: " + result));
                        try {
                            if (result == null) {
                                return;
                            }
                            if (enableCaching) {
                                String msg;
                                JSONObject jsonObject = new JSONObject(result);
                                int status = jsonObject.isNull("status") ? 0 : jsonObject.getInt("status");
                                String string = msg = jsonObject.isNull("message") ? "invalid" : jsonObject.getString("message");
                                if (status == 200 && msg.equalsIgnoreCase("Success")) {
                                    AirSDK.this.caching.saveJson(AdCallbackListener.AdType.overlay, result);
                                    SDKIntializer.sendAdCached(AdCallbackListener.AdType.overlay);
                                } else {
                                    AirSDK.validateStatusCode(status, msg);
                                }
                            } else {
                                AirSDK.this.showOverlayAd(result);
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }

                    @Override
                    public void launchNewHttpTask() {
                        try {
                            ArrayList<NameValuePair> nameValuePairs = new ArrayList<NameValuePair>();
                            String url = "https://api.airpush.com/overlayads/overlayadcall.php";
                            NetworkThread networkThread = new NetworkThread(mContext, this, nameValuePairs, url, 0L, true);
                            new Thread((Runnable)networkThread, "overlay").start();
                        }
                        catch (Exception e) {
                            Log.e((String)AirSDK.TAG, (String)"Error occurred in while requesting: ", (Throwable)e);
                        }
                    }
                };
                if (Util.checkInternetConnection(mContext)) {
                    asyncTaskCompleteListener.launchNewHttpTask();
                }
            } else {
                Log.i((String)TAG, (String)"AirSDK is disabled Please enable to recive ads.");
                AirSDK.sendAdError("AirSDK is disabled Please enable to recive ads.");
            }
        }
        catch (Exception exception) {
            Log.e((String)TAG, (String)"Error occurred in Overlay ad: ", (Throwable)exception);
        }
    }

    private void showOverlayAd(String result) {
        try {
            boolean error;
            JSONObject jsonObject = new JSONObject(result);
            int status = jsonObject.isNull("status") ? 0 : jsonObject.getInt("status");
            String msg = jsonObject.isNull("message") ? "invalid" : jsonObject.getString("message");
            final String adtype = jsonObject.isNull("adtype") ? "" : jsonObject.getString("adtype");
            boolean bl = error = jsonObject.isNull("error") ? false : jsonObject.getBoolean("error");
            if (status == 200 && msg.equalsIgnoreCase("Success")) {
                String data;
                String string = data = jsonObject.isNull("data") ? "nodata" : jsonObject.getString("data");
                if (data.equals("nodata")) {
                    return;
                }
                JSONObject jsonObject2 = new JSONObject(data);
                String tag = jsonObject2.getString("tag");
                int height = jsonObject2.getInt("height");
                int width = jsonObject2.getInt("width");
                String imp_url = jsonObject2.getString("api_url");
                OverlayAd.setAdtype(adtype);
                OverlayAd.setApiUrl(imp_url);
                OverlayAd.setError(error);
                OverlayAd.setWidth(width);
                OverlayAd.setHeight(height);
                OverlayAd.setTag(tag);
                if (adtype.equals("OLAU") || adtype.equals("DAU") || adtype.equals("DCC") || adtype.equals("DCM")) {
                    new Thread(new Runnable(){

                        public void run() {
                            Intent intent = new Intent(mContext, SmartWallActivity.class);
                            intent.setFlags(0x10000000);
                            intent.addFlags(0x800000);
                            intent.setAction("overlayad");
                            intent.putExtra("adtype", adtype);
                            mContext.startActivity(intent);
                        }
                    }, "overlay_showing").start();
                } else {
                    Log.w((String)TAG, (String)("Invalid adtype delivered in overylay ad " + adtype));
                }
            } else {
                AirSDK.validateStatusCode(status, msg);
            }
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"Error occurred in overlay ad", (Throwable)e);
        }
    }

    public void showCachedAd(Context context, AdCallbackListener.AdType adType) {
        try {
            if (context == null || adType == null) {
                Log.e((String)TAG, (String)"Activity or Adtype is null.");
                AirSDK.sendIntegrationError("Activity or Adtype is null.");
                return;
            }
            mContext = context;
            if (SmartWallActivity.isShowing()) {
                if (adCallbackListener != null) {
                    adCallbackListener.onAdError("Another ad is showing on screen.");
                }
                return;
            }
            if (this.caching == null) {
                this.caching = new Caching(context);
            }
            switch (adType) {
                case smartwall: {
                    String jsonString = this.caching.getJson(AdCallbackListener.AdType.smartwall);
                    if (jsonString != null && !jsonString.equals("")) {
                        this.parseSmartwallJson(jsonString);
                        break;
                    }
                    AirSDK.validateStatusCode(204, "Smart ad is not available in cache");
                    break;
                }
                case appwall: {
                    String jsonString = this.caching.getJson(AdCallbackListener.AdType.appwall);
                    if (jsonString != null && !jsonString.equals("")) {
                        this.parseAppWallJson(jsonString);
                        break;
                    }
                    AirSDK.validateStatusCode(204, "Appwall ad is not available in cache");
                    break;
                }
                case landing_page: {
                    String jsonString = this.caching.getJson(AdCallbackListener.AdType.landing_page);
                    if (jsonString != null && !jsonString.equals("")) {
                        this.parseLandingPageAdJson(jsonString);
                        break;
                    }
                    AirSDK.validateStatusCode(204, "Landingpage is not available in cache");
                    break;
                }
                case interstitial: {
                    String jsonString = this.caching.getJson(AdCallbackListener.AdType.interstitial);
                    if (jsonString != null && !jsonString.equals("")) {
                        JSONObject jsonObject = new JSONObject(jsonString);
                        this.parseRichMediaInterstitialJson(jsonObject);
                        break;
                    }
                    AirSDK.validateStatusCode(204, "Interstitial ad is not available in cache");
                    break;
                }
                case video: {
                    VideoAd videoAd = new VideoAd(context);
                    videoAd.starVideoAdActivity();
                    break;
                }
                case overlay: {
                    String jsonString = this.caching.getJson(AdCallbackListener.AdType.overlay);
                    if (jsonString != null && !jsonString.equals("")) {
                        this.showOverlayAd(jsonString);
                        break;
                    }
                    AirSDK.validateStatusCode(204, "Overlay ad is not available in cache");
                    break;
                }
                default: {
                    if (adCallbackListener != null) {
                        adCallbackListener.onAdError("Invalid AdType.");
                    }
                    break;
                }
            }
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"Error occurred in caching ad", (Throwable)e);
        }
    }

    static {
        isDialogClosed = false;
        isShowOptinDialog = true;
        isIntegrationIssue = false;
        enableCaching = true;
    }
}

