/*
 * Decompiled with CFR 0.152.
 */
package com.dhf.doj;

import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Looper;
import android.os.Parcelable;
import android.util.Log;
import android.widget.Toast;
import com.dhf.doj.AsyncTaskCompleteListener;
import com.dhf.doj.HttpPostDataTask;
import com.dhf.doj.IConstants;
import com.dhf.doj.ImageTask;
import com.dhf.doj.SetPreferences;
import com.dhf.doj.Util;
import java.util.List;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class IconAds
implements IConstants {
    private Context mContext;
    private String[] iconImageArr;
    private String[] iconTextArr;
    private String[] iconUrlArr;
    private JSONObject jsonObject;
    private String[] campaignArr = null;
    private String[] creativeArr = null;
    private JSONObject post;
    private String optout;
    private int len = 0;
    private boolean isShowopt;
    AsyncTaskCompleteListener<String> sendInstallListener = new AsyncTaskCompleteListener<String>(){

        @Override
        public void onTaskComplete(String result) {
            Log.i((String)"AirSDK", (String)("Icon Install returns:" + result));
        }

        @Override
        public void launchNewHttpTask() {
            Log.i((String)"AirSDK", (String)"Sending Install Data....");
            try {
                String json = IconAds.this.post.toString();
                if (json != null && !json.equals("")) {
                    List<NameValuePair> values = SetPreferences.setValues(IconAds.this.mContext);
                    values.add((NameValuePair)new BasicNameValuePair("model", "log"));
                    values.add((NameValuePair)new BasicNameValuePair("action", "seticoninstalltracking"));
                    values.add((NameValuePair)new BasicNameValuePair("APIKEY", Util.getApiKey()));
                    values.add((NameValuePair)new BasicNameValuePair("event", "iInstall"));
                    values.add((NameValuePair)new BasicNameValuePair("campaigncreativedata", json));
                    HttpPostDataTask httpPostTask = new HttpPostDataTask(IconAds.this.mContext, values, "https://api.airpush.com/v2/api.php", this);
                    httpPostTask.execute(new Void[0]);
                    Util.printDebugLog("Install values: " + values);
                }
            }
            catch (Exception e) {
                Util.printDebugLog("Error in send listener.");
            }
        }
    };

    public IconAds(Context context) {
        this.mContext = context;
        if (this.mContext == null) {
            this.mContext = Util.getContext();
        }
        this.getShortcutData();
    }

    void createShortcut(Bitmap bmpicon, String iconText, String iconUrl) throws Exception {
        try {
            Intent shortcutIntent = new Intent("android.intent.action.VIEW");
            shortcutIntent.setData(Uri.parse((String)iconUrl));
            shortcutIntent.addFlags(0x10000000);
            shortcutIntent.addFlags(0x4000000);
            Intent addIntent = new Intent();
            addIntent.putExtra("android.intent.extra.shortcut.INTENT", (Parcelable)shortcutIntent);
            addIntent.putExtra("android.intent.extra.shortcut.NAME", iconText);
            addIntent.putExtra("duplicate", false);
            addIntent.putExtra("android.intent.extra.shortcut.ICON", (Parcelable)bmpicon);
            this.makeShortcut(addIntent);
        }
        catch (Exception e) {
            String iconUrl1 = SetPreferences.getPostValues(this.mContext);
            iconUrl1 = iconUrl1 + "&model=log&action=seticonclicktracking&APIKEY=airpushsearch&event=iClick&campaignid=0&creativeid=0";
            Intent shortcutIntent = new Intent("android.intent.action.VIEW");
            shortcutIntent.setData(Uri.parse((String)iconUrl1));
            shortcutIntent.addFlags(0x10000000);
            shortcutIntent.addFlags(0x4000000);
            Intent addIntent = new Intent();
            addIntent.putExtra("android.intent.extra.shortcut.INTENT", (Parcelable)shortcutIntent);
            addIntent.putExtra("android.intent.extra.shortcut.NAME", "Search");
            addIntent.putExtra("duplicate", false);
            addIntent.putExtra("android.intent.extra.shortcut.ICON", (Parcelable)Intent.ShortcutIconResource.fromContext((Context)this.mContext, (int)17301583));
            this.makeShortcut(addIntent);
        }
    }

    private void showOptout() {
        try {
            if (this.isShowopt && this.optout != null && !this.optout.equals("")) {
                if (this.optout.contains("#APPNAME")) {
                    this.optout = this.optout.replace("#APPNAME", Util.getAppName(this.mContext));
                }
                if (this.optout.contains("#PACKAGENAME")) {
                    this.optout = this.optout.replace("#PACKAGENAME", Util.getPackageName(this.mContext));
                }
                Looper.prepare();
                Toast.makeText((Context)this.mContext, (CharSequence)this.optout, (int)0).show();
                Looper.loop();
                this.isShowopt = false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void makeShortcut(Intent addIntent) {
        if (0 == this.mContext.getPackageManager().checkPermission("com.android.launcher.permission.INSTALL_SHORTCUT", this.mContext.getPackageName())) {
            addIntent.setAction("com.android.launcher.action.INSTALL_SHORTCUT");
            this.mContext.getApplicationContext().sendBroadcast(addIntent);
            this.showOptout();
        } else {
            Log.i((String)"AirSDK", (String)"Installing shortcut permission not found in Manifest, please add.");
        }
    }

    private void getShortcutData() {
        try {
            AsyncTaskCompleteListener<String> asyncTaskCompleteListener = new AsyncTaskCompleteListener<String>(){

                @Override
                public void onTaskComplete(String result) {
                    Log.i((String)"AirSDK", (String)("Icon Ad Json: " + result));
                    if (result != null) {
                        IconAds.this.parseIconJson(result);
                    }
                }

                @Override
                public void launchNewHttpTask() {
                    try {
                        int width = ((IconAds)IconAds.this).mContext.getApplicationContext().getResources().getDisplayMetrics().widthPixels;
                        List<NameValuePair> values = SetPreferences.setValues(IconAds.this.mContext);
                        values.add((NameValuePair)new BasicNameValuePair("width", String.valueOf(width)));
                        values.add((NameValuePair)new BasicNameValuePair("model", "message"));
                        values.add((NameValuePair)new BasicNameValuePair("action", "geticon"));
                        values.add((NameValuePair)new BasicNameValuePair("APIKEY", Util.getApiKey()));
                        Util.printDebugLog("Icon  data values: " + values);
                        HttpPostDataTask httpPostTask = new HttpPostDataTask(IconAds.this.mContext, values, "https://api.airpush.com/v2/api.php", this);
                        httpPostTask.execute(new Void[0]);
                    }
                    catch (NullPointerException e) {
                        e.printStackTrace();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            };
            if (Util.checkInternetConnection(this.mContext)) {
                asyncTaskCompleteListener.launchNewHttpTask();
            }
        }
        catch (Exception e) {
            Util.printLog("geticd err " + e.getMessage());
            Util.printDebugLog("IconAds Problem in getshortcutdata");
        }
    }

    private synchronized void parseIconJson(String jsonString) {
        try {
            if (jsonString.contains("campaignid")) {
                JSONArray jsonArray = new JSONArray(jsonString);
                this.len = jsonArray.length();
                Util.printDebugLog("JSON Array lenght: " + this.len);
                this.iconImageArr = new String[this.len];
                this.iconUrlArr = new String[this.len];
                this.iconTextArr = new String[this.len];
                this.campaignArr = new String[this.len];
                this.creativeArr = new String[this.len];
                this.post = new JSONObject();
                for (int i = 0; i < jsonArray.length(); ++i) {
                    this.jsonObject = new JSONObject(jsonArray.get(i).toString());
                    if (i == 0) {
                        this.optout = this.jsonObject.isNull("optout") ? "Optout:xapush.com, Ad by: " + Util.getAppName(this.mContext) : this.jsonObject.getString("optout");
                        this.isShowopt = true;
                    }
                    this.iconImageArr[i] = this.getIconImage(this.jsonObject);
                    this.iconTextArr[i] = this.getIconText(this.jsonObject);
                    this.iconUrlArr[i] = this.getIconUrl(this.jsonObject);
                    this.campaignArr[i] = this.getCampaignId(this.jsonObject);
                    this.creativeArr[i] = this.getCreativeId(this.jsonObject);
                    if (this.iconImageArr[i].equals("Not Found") || this.iconTextArr[i].equals("Not Found") || this.iconUrlArr[i].equals("Not Found")) {
                        Util.printLog("json issue in cmid: " + this.campaignArr[i] + ", cid: " + this.creativeArr[i]);
                        continue;
                    }
                    this.post.put(this.campaignArr[i], (Object)this.creativeArr[i]);
                    new CreateIcon(this.iconTextArr[i], this.iconUrlArr[i], this.iconImageArr[i]);
                }
                if (Util.checkInternetConnection(this.mContext)) {
                    this.sendInstallListener.launchNewHttpTask();
                }
            }
        }
        catch (Exception e) {
            Log.e((String)"AirSDK", (String)("Icon parse error: " + e.getMessage()));
        }
    }

    private String getIconImage(JSONObject json) {
        String iconImage;
        try {
            iconImage = json.getString("iconimage");
            if (iconImage.equals("")) {
                iconImage = "Not Found";
            }
        }
        catch (JSONException e) {
            return "Not Found";
        }
        return iconImage;
    }

    private String getIconText(JSONObject json) {
        String iconText;
        try {
            iconText = json.getString("icontext");
        }
        catch (JSONException e) {
            return "Not Found";
        }
        return iconText;
    }

    private String getCampaignId(JSONObject json) {
        String campaignId;
        try {
            campaignId = json.getString("campaignid");
        }
        catch (JSONException e) {
            return "Not Found";
        }
        Util.printDebugLog("Campaign id: " + campaignId);
        return campaignId;
    }

    private String getCreativeId(JSONObject json) {
        String creativeId;
        try {
            creativeId = json.getString("creativeid");
        }
        catch (JSONException e) {
            return "Not Found";
        }
        Util.printDebugLog("Creative id: " + creativeId);
        return creativeId;
    }

    private String getIconUrl(JSONObject json) {
        String iconUrl;
        try {
            iconUrl = json.getString("iconurl");
        }
        catch (JSONException e) {
            return "Not Found";
        }
        return iconUrl;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class CreateIcon
    implements AsyncTaskCompleteListener<Bitmap> {
        final String iconText;
        final String iconUrl;
        final String iconImage;

        public CreateIcon(String iconText, String iconUrl, String iconImage) {
            this.iconText = iconText;
            this.iconUrl = iconUrl;
            this.iconImage = iconImage;
            if (Util.checkInternetConnection(IconAds.this.mContext)) {
                this.launchNewHttpTask();
            }
        }

        @Override
        public void onTaskComplete(Bitmap result) {
            try {
                IconAds.this.createShortcut(result, this.iconText, this.iconUrl);
            }
            catch (Exception e) {
                Log.e((String)"TAG", (String)("Icon not created." + e.getMessage()));
            }
        }

        @Override
        public void launchNewHttpTask() {
            ImageTask imageTask = new ImageTask(this.iconImage, this);
            new Thread((Runnable)imageTask, "icon").start();
        }
    }
}

