/*
 * Decompiled with CFR 0.152.
 */
package com.dhf.doj;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.Intent;
import android.graphics.Paint;
import android.net.Uri;
import android.os.Build;
import android.os.Handler;
import android.util.Log;
import android.view.MotionEvent;
import android.view.ViewGroup;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.FrameLayout;
import com.dhf.doj.AdView;
import com.dhf.doj.FormatAds;
import com.dhf.doj.Util;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.util.EntityUtils;

class ImageBanner
extends WebView {
    private final String TAG = "AirMraid";
    private FormatAds.ParseBannerAd bannerAd;
    private AdView.AnimationDrawListener animationDrawListener;
    private boolean isTestMode;
    private AdView adView;
    private boolean isClicked;

    @SuppressLint(value={"InlinedApi"})
    void plugin() {
        if (Build.VERSION.SDK_INT >= 8) {
            this.getSettings().setPluginState(WebSettings.PluginState.ON_DEMAND);
        }
    }

    @SuppressLint(value={"SetJavaScriptEnabled"})
    public ImageBanner(final Context context, int newWidth, int newHeight, final Handler loadingListener, FormatAds.ParseBannerAd ad, AdView.AnimationDrawListener animationListener, boolean isTestMode, AdView adView) {
        super(context);
        try {
            this.isTestMode = isTestMode;
            this.animationDrawListener = animationListener;
            this.adView = adView;
            this.bannerAd = ad;
            this.setVerticalScrollBarEnabled(false);
            this.setHorizontalScrollBarEnabled(false);
            this.setScrollBarStyle(0x2000000);
            this.getSettings().setJavaScriptEnabled(true);
            this.plugin();
            this.setBackgroundColor(0);
            WebViewClient webViewClient = new WebViewClient(){
                boolean error = false;

                public boolean shouldOverrideUrlLoading(WebView view, String url) {
                    if ((ImageBanner.this.bannerAd.isJsAd() || ImageBanner.this.bannerAd.isHtmlAd() || ImageBanner.this.bannerAd.isInlineScript() || ImageBanner.this.bannerAd.isPlainUrl()) && ImageBanner.this.isClicked && !url.equals(ImageBanner.this.bannerAd.getTag())) {
                        Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)url));
                        intent.setFlags(0x10000000);
                        intent.addFlags(0x800000);
                        context.startActivity(intent);
                        ImageBanner.this.isClicked = false;
                        return true;
                    }
                    view.loadUrl(url);
                    return true;
                }

                public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
                    this.error = true;
                    ImageBanner.this.sendImpression("89");
                    if (loadingListener != null) {
                        loadingListener.sendEmptyMessage(8);
                        Util.printDebugLog("Error in ad loading.");
                    }
                    if (AdView.adListener != null) {
                        AdView.adListener.onErrorListener(description);
                    }
                    super.onReceivedError(view, errorCode, description, failingUrl);
                }

                public void onPageFinished(WebView view, String url) {
                    if (!this.error && loadingListener != null) {
                        loadingListener.sendEmptyMessage(0);
                        Util.printDebugLog("Ad loading complete");
                    }
                    ImageBanner.this.sendImpression("14");
                    if (AdView.adListener != null) {
                        AdView.adListener.onAdLoadedListener();
                    }
                }
            };
            this.setWebViewClient(webViewClient);
            if (Build.VERSION.SDK_INT >= 11) {
                try {
                    Method setLayerTypeMethod = ((Object)((Object)this)).getClass().getMethod("setLayerType", Integer.TYPE, Paint.class);
                    setLayerTypeMethod.invoke((Object)this, 1, null);
                }
                catch (NoSuchMethodException e) {
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(this.adView.getadWidth(), this.adView.getadHeight());
            if (this.bannerAd.isInlineScript()) {
                this.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
                this.loadDataWithBaseURL(null, this.bannerAd.getTag(), "text/html", "UTF-8", null);
            } else if (this.bannerAd.isPlainUrl()) {
                this.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
                if (this.bannerAd.getTag() != null && !this.bannerAd.getTag().equals("")) {
                    this.loadUrl(this.bannerAd.getTag());
                } else {
                    Log.e((String)"AirMraid", (String)"Url is null");
                }
            } else if (this.bannerAd.isJsAd()) {
                this.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
                StringBuilder content = new StringBuilder();
                content.append("<html><head>" + this.bannerAd.getTag() + "<style>* {margin:0;padding:0; width: " + newWidth + "; height: " + newHeight + ";}</style></head><body>").append("</body></html>");
                this.loadDataWithBaseURL(null, content.toString(), "text/html", "UTF-8", null);
            } else if (this.bannerAd.isHtmlAd()) {
                this.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
                StringBuilder content = new StringBuilder();
                content.append("<html><head><style>* {margin:0;padding:0; width: " + newWidth + "; height: " + newHeight + ";}</style></head><body>").append(this.bannerAd.getTag()).append("</body></html>");
                this.loadDataWithBaseURL(null, content.toString(), "text/html", "UTF-8", null);
            } else if (this.bannerAd.getBanner_type().equals("text")) {
                StringBuilder builder = new StringBuilder();
                builder.append("<html><head><style>* {margin:0;}</style></head><body>");
                builder.append("<div style='background-color: " + this.bannerAd.getBanner_bg() + "; width: " + newWidth + "; height: " + newHeight + ";'><table><tr>");
                builder.append("<td rowspan='2' align='center'><img alt='icon' style='padding: 2' src='" + this.bannerAd.getAdimage() + "'></td>");
                builder.append("<td><font color='" + this.bannerAd.getTextColor() + "'><b>" + this.bannerAd.getTitle() + "</b><br></font>");
                builder.append("</td><tr><td><font size=2 color='" + this.bannerAd.getTextColor() + "'>" + this.bannerAd.getText() + "</font></td></tr>");
                builder.append("</table></div></body></html>");
                this.loadDataWithBaseURL(null, builder.toString(), "text/html", "UTF-8", null);
            } else {
                StringBuilder content = new StringBuilder();
                content.append("<html><head><style>* {margin:0;padding:0;}</style></head><body>").append("<img src=\"" + this.bannerAd.getAdimage() + "\" height=\"" + newHeight + "\" width=\"" + newWidth + "\"/>").append("</html></head>");
                this.loadDataWithBaseURL(null, content.toString(), "text/html", "UTF-8", null);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.sendImpression("89");
        }
    }

    public boolean dispatchTouchEvent(MotionEvent event) {
        if (event.getAction() == 0) {
            this.sendImpression("13");
            if (AdView.adListener != null) {
                AdView.adListener.onAdClickListener();
            }
            if (this.bannerAd.isJsAd() || this.bannerAd.isHtmlAd() || this.bannerAd.isInlineScript() || this.bannerAd.isPlainUrl()) {
                this.isClicked = true;
                return super.dispatchTouchEvent(event);
            }
            this.bannerAd.handleClicks();
            return true;
        }
        return super.dispatchTouchEvent(event);
    }

    protected void onAnimationEnd() {
        super.onAnimationEnd();
        if (this.animationDrawListener != null) {
            this.animationDrawListener.onAnimationDrawEnd();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void sendImpression(final String event) {
        String string = event;
        synchronized (string) {
            if (this.isTestMode) {
                Util.printDebugLog("Ad in test mode. Sending ignored.");
                return;
            }
            if (!Util.checkInternetConnection(this.getContext())) {
                return;
            }
            Thread thread = new Thread(new Runnable(){

                public void run() {
                    try {
                        Log.i((String)"AirMraid", (String)"Sending banner impression event: ");
                        if (!ImageBanner.this.bannerAd.isErrorReport() && event.equals("89")) {
                            Util.printDebugLog("Error reporting is off.");
                            return;
                        }
                        String imp_url = ImageBanner.this.bannerAd.getApi_url();
                        if (imp_url.contains("%event%")) {
                            imp_url = imp_url.replace("%event%", event);
                        }
                        Util.printDebugLog("URL: " + imp_url);
                        DefaultHttpClient httpclient = new DefaultHttpClient();
                        HttpPost httppost = new HttpPost(imp_url);
                        BasicHttpParams basicHttpParams = new BasicHttpParams();
                        httppost.setParams((HttpParams)basicHttpParams);
                        HttpConnectionParams.setConnectionTimeout((HttpParams)basicHttpParams, (int)15000);
                        HttpConnectionParams.setSoTimeout((HttpParams)basicHttpParams, (int)10000);
                        HttpResponse response = httpclient.execute((HttpUriRequest)httppost);
                        int code = response == null ? 0 : response.getStatusLine().getStatusCode();
                        Log.i((String)"AirMraid", (String)("Status code: " + code));
                        if (code == 200) {
                            String string = EntityUtils.toString((HttpEntity)response.getEntity());
                            Log.i((String)"AirMraid", (String)("Banner Data: " + string));
                        }
                    }
                    catch (Exception e) {
                        Log.e((String)"AirMraid", (String)("Data not sent. Exception: " + e.getMessage()));
                        e.printStackTrace();
                    }
                }
            }, "banner_event");
            thread.start();
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        String banner_type;
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        if (this.bannerAd != null && ((banner_type = this.bannerAd.getBanner_type()).equals("image") || banner_type.equals("text") || banner_type.equals("medium_rectangle"))) {
            this.setMeasuredDimension(this.adView.getadWidth(), this.adView.getadHeight());
        }
    }
}

