/*
 * Decompiled with CFR 0.152.
 */
package com.dhf.doj;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.util.Log;
import com.dhf.doj.AsyncTaskCompleteListener;
import com.dhf.doj.Util;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ImageTask
implements Runnable {
    final String IMAGE_URL;
    final AsyncTaskCompleteListener<Bitmap> listener;

    public ImageTask(String image_url, AsyncTaskCompleteListener<Bitmap> completeListener) {
        this.IMAGE_URL = image_url;
        this.listener = completeListener;
        Util.printDebugLog("Image URL: " + image_url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        HttpURLConnection httpConnection = null;
        try {
            URL u = new URL(this.IMAGE_URL);
            httpConnection = (HttpURLConnection)u.openConnection();
            httpConnection.setRequestMethod("GET");
            httpConnection.setConnectTimeout(20000);
            httpConnection.setReadTimeout(20000);
            httpConnection.setUseCaches(false);
            httpConnection.setDefaultUseCaches(false);
            httpConnection.connect();
            int code = httpConnection.getResponseCode();
            if (code == 200) {
                InputStream iconStream = httpConnection.getInputStream();
                Bitmap bmpicon = BitmapFactory.decodeStream((InputStream)iconStream);
                if (this.listener != null) {
                    this.listener.onTaskComplete(bmpicon);
                    return;
                }
            } else {
                Log.w((String)"AirSDK", (String)("Http Code: " + code + ", Message: " + httpConnection.getResponseMessage()));
            }
        }
        catch (Exception ex) {
            Log.e((String)"AirSDK", (String)"Network Error, please try again later", (Throwable)ex);
        }
        finally {
            if (httpConnection != null) {
                httpConnection.disconnect();
            }
        }
        if (this.listener != null) {
            this.listener.onTaskComplete(null);
        }
    }
}

