/*
 * Decompiled with CFR 0.152.
 */
package com.dhf.doj;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.AlertDialog;
import android.content.ActivityNotFoundException;
import android.content.ContentResolver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.res.Configuration;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Rect;
import android.media.MediaPlayer;
import android.net.Uri;
import android.os.Build;
import android.os.Handler;
import android.provider.MediaStore;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.webkit.JavascriptInterface;
import android.webkit.WebChromeClient;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.VideoView;
import com.dhf.doj.AdCallbackListener;
import com.dhf.doj.AdView;
import com.dhf.doj.BrowserActivity;
import com.dhf.doj.FormatAds;
import com.dhf.doj.IMraid;
import com.dhf.doj.MraidJS;
import com.dhf.doj.Util;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Locale;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.util.EntityUtils;
import org.json.JSONException;
import org.json.JSONObject;

final class MraidView
extends WebView
implements IMraid {
    static MraidView airpushMraidView;
    private AdView adView;
    private AdCallbackListener.MraidCallbackListener adListener;
    private Handler handler;
    private String placementType;
    private DisplayMetrics displayMetrics;
    private int width;
    private int height;
    private int widthDp;
    private int heightDp;
    private ExpandProperties expandProperties;
    private String state;
    private boolean isViewable;
    private float scale;
    private FrameLayout expandedFrameLayout;
    private ViewGroup parentViewGroup;
    private int viewIndex;
    private VideoView videoHolder;
    private MraidAdUtil mraidAdUtil;
    private String adUrl;
    private boolean viewable;
    private FormatAds.ParseMraidJson parseMraidJson;
    private AdView.AnimationDrawListener animationDrawListener;
    boolean isTestMode = false;

    @SuppressLint(value={"InlinedApi"})
    public MraidView(Context context, FormatAds.ParseMraidJson parseMraidJson, Handler handler) {
        super(context);
        try {
            try {
                if (Build.VERSION.SDK_INT >= 11 && context instanceof Activity) {
                    ((Activity)context).getWindow().setFlags(0x1000000, 0x1000000);
                }
            }
            catch (Throwable e) {
                // empty catch block
            }
            this.adUrl = parseMraidJson.getAd_url();
            this.handler = handler;
            this.mraidAdUtil = new MraidAdUtil();
            this.displayMetrics = context.getResources().getDisplayMetrics();
            this.scale = this.displayMetrics.density;
            this.expandProperties = new ExpandProperties();
            this.parseMraidJson = parseMraidJson;
            this.initSettting();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @SuppressLint(value={"InlinedApi"})
    public MraidView(Context context, AdView adView, AdCallbackListener.MraidCallbackListener adListener, Handler handler, AdView.AnimationDrawListener animationDrawListener) {
        super(context);
        try {
            if (Build.VERSION.SDK_INT >= 11 && this.getContext() instanceof Activity) {
                ((Activity)this.getContext()).getWindow().setFlags(0x1000000, 0x1000000);
            }
        }
        catch (Throwable e) {
            // empty catch block
        }
        this.animationDrawListener = animationDrawListener;
        airpushMraidView = this;
        this.parseMraidJson = adView.parseMraidJson;
        this.adView = adView;
        this.adListener = adListener;
        this.handler = handler;
        this.adUrl = this.parseMraidJson.getAd_url();
        this.isTestMode = adView.isTestMode();
        this.mraidAdUtil = new MraidAdUtil();
        this.placementType = adView.getPlacementType();
        this.displayMetrics = context.getResources().getDisplayMetrics();
        this.scale = this.displayMetrics.density;
        if (this.placementType.equals("inline")) {
            this.width = this.displayMetrics.widthPixels;
            this.height = Util.isTablet(this.getContext()) ? 90 : 60;
        } else {
            this.width = this.displayMetrics.widthPixels;
            this.height = this.displayMetrics.heightPixels;
        }
        try {
            this.widthDp = (int)Util.convertPixelsToDp(this.width, this.getContext());
            this.heightDp = (int)Util.convertPixelsToDp(this.height, this.getContext());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Util.printDebugLog("Device Width:" + this.width + ", Device Height:" + this.height);
        this.expandProperties = new ExpandProperties();
        this.initSettting();
        this.expandProperties.getProperties();
        int height = (int)(60.0f * this.scale);
        if (Util.isTablet(this.getContext())) {
            height = (int)(90.0f * this.scale);
        }
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-1, height);
        this.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
    }

    @SuppressLint(value={"SetJavaScriptEnabled", "InlinedApi"})
    private void initSettting() {
        ViewGroup.LayoutParams layoutParams = new ViewGroup.LayoutParams(this.width, this.height);
        this.setLayoutParams(layoutParams);
        this.setHorizontalScrollBarEnabled(false);
        this.setVerticalScrollBarEnabled(false);
        this.setScrollBarStyle(0x2000000);
        this.setBackgroundColor(0);
        this.setWebChromeClient(new AirpushWebChromeClient());
        WebSettings settings = this.getSettings();
        settings.setRenderPriority(WebSettings.RenderPriority.HIGH);
        settings.setLayoutAlgorithm(WebSettings.LayoutAlgorithm.NARROW_COLUMNS);
        settings.setCacheMode(2);
        settings.setLoadWithOverviewMode(true);
        settings.setLoadsImagesAutomatically(true);
        settings.setUseWideViewPort(false);
        settings.setJavaScriptEnabled(true);
        this.addJavascriptInterface(new JavaScriptInterface(), "airpush_mraid");
        if (Build.VERSION.SDK_INT >= 8) {
            settings.setPluginState(WebSettings.PluginState.ON);
        }
        this.setWebViewClient(new AirpuhWebViewClient());
        this.displayAd(this.adUrl);
        if (this.adListener != null) {
            this.adListener.onAdLoadingListener();
        }
    }

    void displayAd(String url) {
        this.injectJSCode(Util.getDoc(this.getContext()));
        if (url != null && url.endsWith(".js")) {
            int lastIndex = url.lastIndexOf("/");
            String jsFile = url.substring(lastIndex, url.length() - 1);
            String baseUrl = url.substring(0, lastIndex - 1);
            this.loadDataWithBaseURL(baseUrl, "<html><head><script type=\"text/javascript\" src=\"" + jsFile + "\"/>" + "</head><body></body></html>", "text/html", "utf-8", null);
        } else if (this.parseMraidJson.isInlineScript()) {
            if (this.parseMraidJson.getTag() != null && !this.parseMraidJson.getTag().equals("")) {
                this.loadDataWithBaseURL(null, this.parseMraidJson.getTag(), "text/html", "utf-8", null);
            } else {
                Log.e((String)"AirMraid", (String)"Tag data is null");
            }
        } else if (this.parseMraidJson.isJsAd()) {
            if (this.parseMraidJson.getTag() != null && !this.parseMraidJson.getTag().equals("")) {
                this.loadDataWithBaseURL(null, "<html><head><script type=\"text/javascript\" src=\"" + this.parseMraidJson.getTag() + "\"/>" + "</head><body></body></html>", "text/html", "utf-8", null);
            } else {
                Log.e((String)"AirMraid", (String)"Tag data is null");
            }
        } else if (this.parseMraidJson.isHtmlAd()) {
            if (this.parseMraidJson.getTag() != null && !this.parseMraidJson.getTag().equals("")) {
                this.loadDataWithBaseURL(null, "<html><head></head><body>" + this.parseMraidJson.getTag() + "</body></html>", "text/html", "utf-8", null);
            } else {
                Log.e((String)"AirMraid", (String)"tag data is null");
            }
        } else if (url != null && !url.equals("")) {
            this.loadUrl(url);
        } else {
            Log.e((String)"AirMraid", (String)("Invalid url: " + url));
        }
    }

    void displayAD() {
        this.injectJSCode("mraid.setPlacementType('" + this.placementType + "')");
        Util.printDebugLog("SDK LOG: display Ad called.");
        this.injectJSCode("mraid.setExpandProperties(" + this.expandProperties.getProperties() + ");");
        this.checkVisibility();
        this.setState("default");
        this.triggerEvent("ready");
        if (this.handler != null) {
            this.handler.sendEmptyMessage(0);
            this.onAnimationEnd();
        }
        this.setDefaultPosition();
        Log.i((String)"AirMraid", (String)"Sending impression data:>");
        this.sendEventData("90");
    }

    private void checkVisibility() {
        boolean visible = this.isViewable && this.getVisibility() == 0;
        if (visible != this.viewable && this.state == "default") {
            this.viewable = visible;
            this.setViewable(this.viewable);
        }
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.isViewable = true;
        this.checkVisibility();
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.isViewable = false;
        this.checkVisibility();
    }

    public void setVisibility(int visibility) {
        super.setVisibility(visibility);
        this.checkVisibility();
    }

    public void loadUrl(String url) {
        Util.printDebugLog("Loading url: " + url);
        super.loadUrl(url);
    }

    public void loadDataWithBaseURL(String baseUrl, String data, String mimeType, String encoding, String historyUrl) {
        super.loadDataWithBaseURL(baseUrl, data, mimeType, encoding, historyUrl);
        if (this.adListener != null) {
            this.adListener.onAdLoadingListener();
        }
    }

    private void setDataInJs() {
        this.setScreenSize();
        this.setMaxSize();
        this.setSupportProperties();
        this.setCurrentPosition();
    }

    protected void onAnimationEnd() {
        super.onAnimationEnd();
        if (this.animationDrawListener != null) {
            Util.printDebugLog("Animation end.");
            this.animationDrawListener.onAnimationDrawEnd();
        }
    }

    public void expand(String url) {
        try {
            if (Build.VERSION.SDK_INT >= 18) {
                this.loadUrl("about:blank");
            } else {
                this.clearView();
            }
            FrameLayout content = (FrameLayout)this.getRootView().findViewById(0x1020002);
            FrameLayout.LayoutParams adParams = new FrameLayout.LayoutParams(-1, -1);
            View placeholderView = new View(this.getContext());
            placeholderView.setLayoutParams(this.getLayoutParams());
            this.expandedFrameLayout = new FrameLayout(this.getContext());
            FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-1, -1);
            layoutParams.gravity = 17;
            this.expandedFrameLayout.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            this.parentViewGroup = (ViewGroup)this.getParent();
            int index = 0;
            if (this.parentViewGroup != null) {
                int count = this.parentViewGroup.getChildCount();
                for (index = 0; index < count && this.parentViewGroup.getChildAt(index) != this; ++index) {
                }
                this.viewIndex = index;
                this.setLayoutParams((ViewGroup.LayoutParams)adParams);
                this.parentViewGroup.removeView((View)this);
                this.expandedFrameLayout.addView((View)this);
                if (!this.expandProperties.useCustomClose) {
                    Button close = this.addCloseButton(5);
                    close.setId(111);
                    FrameLayout.LayoutParams closeParams = new FrameLayout.LayoutParams((int)this.scale * 50, (int)this.scale * 50);
                    closeParams.gravity = 53;
                    close.setLayoutParams((ViewGroup.LayoutParams)closeParams);
                    this.expandedFrameLayout.addView((View)close);
                }
                content.addView((View)this.expandedFrameLayout);
                this.parentViewGroup.addView(placeholderView, this.viewIndex);
                this.parentViewGroup.setVisibility(8);
                this.setState("expanded");
                if (url != null && !url.equals("")) {
                    this.loadUrl(url);
                }
            }
            if (this.adListener != null) {
                this.adListener.onAdExpandedListner();
            }
            if (this.adView != null) {
                this.adView.canFetchAd = false;
            }
            this.sendEventData("94");
        }
        catch (Exception e) {
            this.sendEventData("89");
            e.printStackTrace();
        }
    }

    public void resize() {
        int width = this.displayMetrics.widthPixels;
        int height = this.displayMetrics.heightPixels;
        int offsetX = 0;
        int offsetY = 0;
        boolean allowOffscreen = true;
        int closeButtonGravity = 53;
        try {
            if (Build.VERSION.SDK_INT >= 18) {
                this.loadUrl("about:blank");
            } else {
                this.clearView();
            }
            if (this.mraidAdUtil != null && !this.mraidAdUtil.getResizeProperties().equals("")) {
                try {
                    JSONObject jsonObject = new JSONObject(this.mraidAdUtil.getResizeProperties());
                    width = jsonObject.isNull("width") ? this.displayMetrics.widthPixels : (int)Util.convertDpToPixel(jsonObject.getInt("width"), this.getContext());
                    height = jsonObject.isNull("height") ? this.displayMetrics.heightPixels : (int)Util.convertDpToPixel(jsonObject.getInt("height"), this.getContext());
                    String customClosePosition = jsonObject.isNull("customClosePosition") ? "top-right" : jsonObject.getString("customClosePosition");
                    offsetX = jsonObject.isNull("offsetX") ? 0 : jsonObject.getInt("offsetX");
                    offsetY = jsonObject.isNull("offsetY") ? 0 : jsonObject.getInt("offsetY");
                    allowOffscreen = jsonObject.isNull("allowOffscreen") ? true : jsonObject.getBoolean("allowOffscreen");
                    closeButtonGravity = this.mraidAdUtil.getGravity(customClosePosition);
                }
                catch (Exception e) {
                    if (this.adListener != null) {
                        this.adListener.onErrorListener(e.getMessage());
                    }
                    this.triggerErrorEvent("resize", "Error occured while parsing resizeProperties data.");
                    return;
                }
            }
            if (!allowOffscreen) {
                int[] size = this.checkSizeParams(width, height);
                width = size[0];
                height = size[1];
            }
            FrameLayout content = (FrameLayout)this.getRootView().findViewById(0x1020002);
            FrameLayout.LayoutParams adParams = new FrameLayout.LayoutParams(width, height);
            View placeholderView = new View(this.getContext());
            placeholderView.setLayoutParams(this.getLayoutParams());
            this.expandedFrameLayout = new FrameLayout(this.getContext());
            FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(width, height);
            layoutParams.leftMargin = offsetX;
            layoutParams.topMargin = offsetY;
            this.expandedFrameLayout.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            this.parentViewGroup = (ViewGroup)this.getParent();
            int index = 0;
            if (this.parentViewGroup != null) {
                int count = this.parentViewGroup.getChildCount();
                for (index = 0; index < count && this.parentViewGroup.getChildAt(index) != this; ++index) {
                }
                this.viewIndex = index;
                this.setLayoutParams((ViewGroup.LayoutParams)adParams);
                this.parentViewGroup.removeView((View)this);
                this.expandedFrameLayout.addView((View)this);
                try {
                    LinearLayout ll = new LinearLayout(this.getContext());
                    FrameLayout.LayoutParams closeParams = new FrameLayout.LayoutParams((int)(this.scale * 50.0f), (int)(this.scale * 50.0f));
                    closeParams.gravity = closeButtonGravity;
                    ll.setLayoutParams((ViewGroup.LayoutParams)closeParams);
                    ll.setGravity(closeButtonGravity);
                    this.expandedFrameLayout.addView((View)ll);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                content.addView((View)this.expandedFrameLayout);
                this.parentViewGroup.addView(placeholderView, this.viewIndex);
                this.parentViewGroup.setVisibility(8);
                this.setState("resized");
                this.triggerEvent("sizeChange");
            }
            if (this.adListener != null) {
                this.adListener.onAdExpandedListner();
            }
            if (this.adView != null) {
                this.adView.canFetchAd = false;
            }
            this.sendEventData("95");
        }
        catch (Exception e) {
            this.sendEventData("89");
            e.printStackTrace();
        }
    }

    private int[] checkSizeParams(int width, int height) {
        if (width > this.width || height > this.height) {
            float ratio = (float)height / (float)width;
            int diffWidth = (int)((float)(width - this.width) * ratio);
            int diffHeight = (int)((float)(height - this.height) * ratio);
            if (diffWidth > diffHeight) {
                width = this.width;
                height = (int)((float)width * ratio);
            } else {
                height = this.width;
                width = (int)((float)height / ratio);
            }
        }
        return new int[]{width, height};
    }

    private void setButtonBackground(Button button) {
        try {
            if (null == button) {
                return;
            }
            Class<?> cls = Class.forName("com.android.internal.R$drawable");
            int background = cls.getField("ic_menu_close_clear_cancel").getInt(cls);
            button.setBackgroundResource(background);
        }
        catch (Exception exception) {
            button.setText((CharSequence)"Close");
            button.setTypeface(null, 1);
            button.setBackgroundColor(0);
        }
    }

    Button addCloseButton(int gravity) {
        Button button = new Button(this.getContext());
        ViewGroup.LayoutParams layoutParams = new ViewGroup.LayoutParams((int)(50.0f * this.scale), (int)(50.0f * this.scale));
        button.setGravity(gravity);
        button.setLayoutParams(layoutParams);
        this.setButtonBackground(button);
        button.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                MraidView.this.close();
            }
        });
        return button;
    }

    public void close() {
        try {
            if (this.adView != null) {
                this.adView.canFetchAd = true;
            }
            if (this.state.equals("expanded")) {
                if (this.expandedFrameLayout != null && this.parentViewGroup != null) {
                    ((ViewGroup)this.expandedFrameLayout.getParent()).removeView((View)this.expandedFrameLayout);
                    this.expandedFrameLayout.removeView((View)this);
                    this.setLayoutParams(this.parentViewGroup.getChildAt(this.viewIndex).getLayoutParams());
                    this.parentViewGroup.removeViewAt(this.viewIndex);
                    this.parentViewGroup.setVisibility(0);
                }
                this.setState("default");
                if (this.adView != null) {
                    this.adView.getAd();
                }
            } else if (this.state.equals("default")) {
                ((ViewGroup)this.getParent()).setVisibility(8);
                this.setState("hidden");
                if (this.handler != null) {
                    this.handler.sendEmptyMessage(-3);
                }
            } else if (this.state.equals("resized")) {
                if (this.expandedFrameLayout != null && this.parentViewGroup != null) {
                    ((ViewGroup)this.expandedFrameLayout.getParent()).removeView((View)this.expandedFrameLayout);
                    this.expandedFrameLayout.removeView((View)this);
                    this.setLayoutParams(this.parentViewGroup.getChildAt(this.viewIndex).getLayoutParams());
                    this.parentViewGroup.removeViewAt(this.viewIndex);
                    this.parentViewGroup.setVisibility(0);
                }
                this.setState("default");
                if (this.adView != null) {
                    this.adView.getAd();
                }
            } else {
                ((ViewGroup)this.getParent()).setVisibility(8);
                this.setState("hidden");
                if (this.handler != null) {
                    this.handler.sendEmptyMessage(-3);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.adListener != null) {
            this.adListener.onCloseListener();
        }
    }

    public void createCalendarEvent(String jsonString) {
        this.canFetchAd(false);
        Util.printDebugLog("SDK LOG: inside createCalendarEvent: " + jsonString);
        if (this.adListener != null) {
            this.adListener.onAdClickListener();
        }
        try {
            if (jsonString == null || jsonString.equals("")) {
                this.triggerErrorEvent("createCalendarEvent", "Calender method called with empty json.");
                Log.e((String)"AirMraid", (String)"Error occured while creating calendar event.");
                return;
            }
            Intent intent = new Intent(this.getContext(), BrowserActivity.class);
            intent.setAction("newCalendarEvent");
            intent.addFlags(0x10000000);
            intent.addFlags(0x800000);
            intent.putExtra("json", jsonString);
            this.getContext().startActivity(intent);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.sendEventData("89");
            this.triggerErrorEvent("createCalendarEvent", "Error occured in createCalenderEvent.");
            Log.e((String)"AirMraid", (String)"Error occured in createCalenderEvent.");
        }
    }

    public void playVideo(String url) {
        this.canFetchAd(false);
        try {
            if (this.adListener != null) {
                this.adListener.onAdClickListener();
            }
            Intent intent = new Intent(this.getContext(), BrowserActivity.class);
            intent.setAction("playVideo");
            intent.putExtra("url", url);
            intent.addFlags(0x800000);
            intent.addFlags(0x10000000);
            this.getContext().startActivity(intent);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.sendEventData("89");
        }
    }

    public void storePicture(final String imageURL, final String fileNameWithExt) {
        this.canFetchAd(false);
        try {
            if (this.adListener != null) {
                this.adListener.onAdClickListener();
            }
            if (imageURL == null || imageURL.equals("")) {
                this.triggerErrorEvent("storePicture", "Image url is null.");
                return;
            }
            if (fileNameWithExt == null || fileNameWithExt.equals("")) {
                this.triggerErrorEvent("storePicture", "File name is null.");
                return;
            }
            if (this.getContext() instanceof Activity) {
                AlertDialog.Builder alertDialog = new AlertDialog.Builder(this.getContext());
                alertDialog.setMessage((CharSequence)"This image will be added in gallery. Please confirm ?");
                alertDialog.setPositiveButton((CharSequence)"Yes", new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        dialog.dismiss();
                        Thread thread = new Thread(new Runnable(){

                            public void run() {
                                try {
                                    URL myImageURL = new URL(imageURL);
                                    HttpURLConnection connection = (HttpURLConnection)myImageURL.openConnection();
                                    connection.setDoInput(true);
                                    connection.connect();
                                    InputStream input = connection.getInputStream();
                                    Bitmap myBitmap = BitmapFactory.decodeStream((InputStream)input);
                                    String dataDir = MraidView.this.getContext().getApplicationInfo().dataDir;
                                    FileOutputStream fOut = null;
                                    File file = new File(dataDir, fileNameWithExt);
                                    Log.i((String)"TAG", (String)("file: " + file.getAbsolutePath()));
                                    fOut = new FileOutputStream(file);
                                    myBitmap.compress(Bitmap.CompressFormat.JPEG, 85, (OutputStream)fOut);
                                    fOut.flush();
                                    ((OutputStream)fOut).close();
                                }
                                catch (IOException e) {
                                    e.printStackTrace();
                                }
                                String dataDir = MraidView.this.getContext().getApplicationInfo().dataDir + "/" + fileNameWithExt;
                                try {
                                    MediaStore.Images.Media.insertImage((ContentResolver)MraidView.this.getContext().getContentResolver(), (String)dataDir, (String)"My Image", (String)fileNameWithExt);
                                    MraidView.this.post(new Runnable(){

                                        public void run() {
                                            MraidView.this.sendEventData("93");
                                            Log.i((String)"AirMraid", (String)"Ad image is saved in Gallery.");
                                            MraidView.this.canFetchAd(true);
                                        }
                                    });
                                }
                                catch (FileNotFoundException e) {
                                    MraidView.this.post(new Runnable(){

                                        public void run() {
                                            MraidView.this.triggerErrorEvent("storePicture", "Url does not exist.");
                                            MraidView.this.canFetchAd(true);
                                        }
                                    });
                                    e.printStackTrace();
                                }
                                catch (Exception e) {
                                    MraidView.this.post(new Runnable(){

                                        public void run() {
                                            MraidView.this.triggerErrorEvent("storePicture", "Unknown error occured: " + e.getMessage());
                                            if (MraidView.this.adListener != null) {
                                                MraidView.this.adListener.onCloseListener();
                                            }
                                            MraidView.this.canFetchAd(true);
                                        }
                                    });
                                    e.printStackTrace();
                                }
                            }
                        });
                        thread.start();
                    }
                });
                alertDialog.setNegativeButton((CharSequence)"No", new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        dialog.dismiss();
                        MraidView.this.triggerErrorEvent("storePicture", "User has canceled.");
                        if (MraidView.this.adListener != null) {
                            MraidView.this.adListener.onCloseListener();
                        }
                        MraidView.this.canFetchAd(true);
                    }
                });
                alertDialog.setOnCancelListener(new DialogInterface.OnCancelListener(){

                    public void onCancel(DialogInterface dialog) {
                        dialog.dismiss();
                        MraidView.this.triggerErrorEvent("storePicture", "User has canceled.");
                        if (MraidView.this.adListener != null) {
                            MraidView.this.adListener.onCloseListener();
                        }
                        MraidView.this.canFetchAd(true);
                    }
                });
                alertDialog.setCancelable(false);
                alertDialog.show();
            }
        }
        catch (Exception exception) {
            this.triggerErrorEvent("storePicture", "Error occured while storing picture.");
            this.sendEventData("error");
            if (this.adListener != null) {
                this.adListener.onCloseListener();
            }
            this.canFetchAd(true);
        }
    }

    public void triggerEvent(String event) {
        this.injectJSCode("mraid.triggerEvent('" + event + "');");
    }

    public void triggerErrorEvent(String action, String msg) {
        this.injectJSCode("mraid.triggerErrorEvent(" + action + ",'" + msg + "');");
        if (!this.isTestMode) {
            this.sendEventData("error");
        }
    }

    public void setCurrentPosition() {
        try {
            int width = (int)Util.convertPixelsToDp(this.getWidth(), this.getContext());
            int height = (int)Util.convertPixelsToDp(this.getHeight(), this.getContext());
            int x = this.getLeft();
            if (Build.VERSION.SDK_INT > 10) {
                x = (int)this.getX();
            }
            int y = this.getTop();
            if (Build.VERSION.SDK_INT > 10) {
                y = (int)this.getY();
            }
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("x", x);
            jsonObject.put("y", y);
            jsonObject.put("width", width);
            jsonObject.put("height", height);
            this.injectJSCode("mraid.setCurrentPosition(" + jsonObject + ");");
        }
        catch (Exception exception) {
            this.triggerErrorEvent("setCurrentPosition", "Error occured while setting current position.");
            exception.printStackTrace();
        }
    }

    public void setDefaultPosition() {
        try {
            int width = (int)Util.convertPixelsToDp(this.getWidth(), this.getContext());
            int height = (int)Util.convertPixelsToDp(this.getHeight(), this.getContext());
            int x = this.getLeft();
            if (Build.VERSION.SDK_INT > 10) {
                x = (int)this.getX();
            }
            int y = this.getTop();
            if (Build.VERSION.SDK_INT > 10) {
                y = (int)this.getY();
            }
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("x", x);
            jsonObject.put("y", y);
            jsonObject.put("width", width);
            jsonObject.put("height", height);
            this.injectJSCode("mraid.setDefaultPosition(" + jsonObject + ");");
        }
        catch (Exception exception) {
            this.triggerErrorEvent("setDefaultPosition", "Error occured while setting default position.");
            exception.printStackTrace();
        }
    }

    public void setMaxSize() {
        try {
            int width = this.widthDp;
            int height = (int)Util.convertPixelsToDp(this.displayMetrics.heightPixels - this.getTokenSize(), this.getContext());
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("width", width);
            jsonObject.put("height", height);
            this.injectJSCode("mraid.setMaxSize(" + jsonObject + ");");
        }
        catch (Exception exception) {
            this.triggerErrorEvent("setMaxSize", "Error occured while setting max size.");
            exception.printStackTrace();
        }
    }

    private int getTokenSize() {
        Rect rectgle = new Rect();
        Activity activity = (Activity)this.getContext();
        Window window = activity.getWindow();
        window.getDecorView().getWindowVisibleDisplayFrame(rectgle);
        int StatusBarHeight = rectgle.top;
        int contentViewTop = window.findViewById(0x1020002).getTop();
        int TitleBarHeight = contentViewTop - StatusBarHeight;
        Util.printDebugLog("StatusBar Height= " + StatusBarHeight + " , TitleBar Height = " + TitleBarHeight);
        return StatusBarHeight + TitleBarHeight;
    }

    public void setScreenSize() {
        try {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("width", this.widthDp);
            jsonObject.put("height", this.heightDp);
            this.injectJSCode("mraid.setScreenSize(" + jsonObject + ");");
        }
        catch (Exception exception) {
            this.triggerErrorEvent("setScreenSize", "Error occured while setting screen size.");
            exception.printStackTrace();
        }
    }

    public void setAdOrientation() {
        try {
            Activity activity = (Activity)this.getContext();
            String forceOrientation = this.mraidAdUtil.getForceOrientation();
            Configuration configuration = this.getResources().getConfiguration();
            boolean allowOrientationChange = this.mraidAdUtil.isOrientationChange();
            if (forceOrientation != null && forceOrientation.equals("landscape")) {
                activity.setRequestedOrientation(0);
                configuration.orientation = 2;
                activity.onConfigurationChanged(configuration);
                Util.printDebugLog("Orientation cahnged to landscape.");
            } else if (forceOrientation != null && forceOrientation.equals("portrait")) {
                activity.setRequestedOrientation(1);
                Util.printDebugLog("Orientation changed to protrait.");
            } else if (forceOrientation != null && forceOrientation.equals("none")) {
                activity.setRequestedOrientation(-1);
                Util.printDebugLog("Orientation changed to none.");
            }
            if (!allowOrientationChange) {
                int i = activity.getRequestedOrientation();
                activity.setRequestedOrientation(i);
                activity.onConfigurationChanged(configuration);
                Util.printDebugLog("Orientation changed to false.");
            }
            Util.printDebugLog("Orientation saved.");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setSupportProperties() {
        JSONObject jsonObject = Util.getSupportsJson(this.getContext());
        if (jsonObject != null) {
            this.injectJSCode("mraid.setSupportedFeatures(" + jsonObject + ");");
        } else {
            this.triggerErrorEvent("supports", "Error occured in supports.");
        }
    }

    public void injectJSCode(final String js_code) {
        this.post(new Runnable(){

            public void run() {
                MraidView.this.loadUrl("javascript:" + js_code);
            }
        });
    }

    public void setState(String state) {
        this.state = state;
        this.injectJSCode("mraid.setState('" + state + "');");
    }

    public void setViewable(boolean isViewable) {
        this.injectJSCode("mraid.setViewable(" + isViewable + ");");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void sendEventData(final String event) {
        String string = event;
        synchronized (string) {
            if (this.isTestMode) {
                Util.printDebugLog("Ad in test mode. Sending ignored.");
                return;
            }
            if (!Util.checkInternetConnection(this.getContext())) {
                return;
            }
            Thread thread = new Thread(new Runnable(){

                public void run() {
                    try {
                        Log.i((String)"AirMraid", (String)"Sending event: ");
                        if (!MraidView.this.parseMraidJson.isErrorReporting() && event.equals("89")) {
                            Util.printDebugLog("Error reporting is off.");
                            return;
                        }
                        String imp_url = MraidView.this.parseMraidJson.getImpression_url();
                        if (imp_url.contains("%event%")) {
                            imp_url = imp_url.replace("%event%", event);
                        }
                        Util.printDebugLog("URL: " + imp_url);
                        DefaultHttpClient httpclient = new DefaultHttpClient();
                        HttpPost httppost = new HttpPost(imp_url);
                        BasicHttpParams basicHttpParams = new BasicHttpParams();
                        httppost.setParams((HttpParams)basicHttpParams);
                        HttpConnectionParams.setConnectionTimeout((HttpParams)basicHttpParams, (int)15000);
                        HttpConnectionParams.setSoTimeout((HttpParams)basicHttpParams, (int)10000);
                        HttpResponse response = httpclient.execute((HttpUriRequest)httppost);
                        int code = response == null ? 0 : response.getStatusLine().getStatusCode();
                        Log.i((String)"AirMraid", (String)("Status code: " + code));
                        if (code == 200) {
                            String string = EntityUtils.toString((HttpEntity)response.getEntity());
                            Log.i((String)"AirMraid", (String)("MRAID Data: " + string));
                        }
                    }
                    catch (Exception e) {
                        Log.e((String)"AirMraid", (String)("Exception: " + e.getMessage()));
                        e.printStackTrace();
                    }
                }
            }, "mraid_event");
            thread.start();
        }
    }

    void canFetchAd(boolean canFetchAd) {
        if (this.adView != null) {
            if (!(!canFetchAd || this.state == null || this.state.equalsIgnoreCase("expanded") && this.state.equalsIgnoreCase("resized"))) {
                this.adView.canFetchAd = true;
                if (this.placementType != null && this.placementType.equals("inline") && this.adView != null) {
                    this.adView.getAd();
                }
            } else {
                this.adView.canFetchAd = false;
            }
        }
    }

    public static class MraidAdUtil {
        private String resizeProperties = "";
        private String expandProperties;
        private String forceOrientation;
        private boolean useCustomClose = false;
        private boolean orientationChange;

        public String getResizeProperties() {
            return this.resizeProperties;
        }

        public void setResizeProperties(String resizeProperties) {
            this.resizeProperties = resizeProperties;
        }

        public String getExpandProperties() {
            return this.expandProperties;
        }

        public void setExpandProperties(String expandProperties) {
            this.expandProperties = expandProperties;
        }

        public String getForceOrientation() {
            return this.forceOrientation;
        }

        public void setForceOrientation(String forceOrientation) {
            this.forceOrientation = forceOrientation;
        }

        public void setOrientationChange(boolean orientationChange) {
            this.orientationChange = orientationChange;
        }

        public boolean isOrientationChange() {
            return this.orientationChange;
        }

        public void setUseCustomClose(boolean useCustomClose) {
            this.useCustomClose = useCustomClose;
        }

        public boolean isUseCustomClose() {
            return this.useCustomClose;
        }

        public int getGravity(String position) {
            int gravity = 53;
            gravity = position.equals("top-right") ? 53 : (position.equals("bottom-center") ? 81 : (position.equals("bottom-left") ? 83 : (position.equals("bottom-right") ? 85 : (position.equals("center") ? 17 : (position.equals("top-center") ? 49 : (position.equals("top-left") ? 51 : 53))))));
            return gravity;
        }
    }

    private class AirpushWebChromeClient
    extends WebChromeClient {
        private AirpushWebChromeClient() {
        }

        public void onShowCustomView(View view, WebChromeClient.CustomViewCallback callback) {
            FrameLayout frame;
            super.onShowCustomView(view, callback);
            if (view instanceof FrameLayout && (frame = (FrameLayout)view).getFocusedChild() instanceof VideoView) {
                MraidView.this.videoHolder = (VideoView)((FrameLayout)view).getFocusedChild();
                frame.removeView((View)MraidView.this.videoHolder);
                ((ViewGroup)MraidView.this.getParent()).addView((View)MraidView.this.videoHolder);
                MraidView.this.videoHolder.setOnCompletionListener(new MediaPlayer.OnCompletionListener(){

                    public void onCompletion(MediaPlayer player) {
                        try {
                            player.stop();
                            MraidView.this.sendEventData("99");
                            MraidView.this.canFetchAd(true);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                });
                MraidView.this.videoHolder.setOnErrorListener(new MediaPlayer.OnErrorListener(){

                    public boolean onError(MediaPlayer mp, int what, int extra) {
                        MraidView.this.sendEventData("89");
                        MraidView.this.canFetchAd(true);
                        return false;
                    }
                });
                MraidView.this.videoHolder.start();
                MraidView.this.canFetchAd(false);
            }
        }

        public void onHideCustomView() {
            if (MraidView.this.videoHolder != null) {
                ((ViewGroup)MraidView.this.getParent()).removeView((View)MraidView.this.videoHolder);
                if (MraidView.this.videoHolder.isPlaying()) {
                    MraidView.this.videoHolder.stopPlayback();
                }
            }
            MraidView.this.canFetchAd(true);
        }
    }

    class AirpuhWebViewClient
    extends WebViewClient {
        boolean isErrorOccured = false;

        AirpuhWebViewClient() {
        }

        public void onPageFinished(WebView view, String url) {
            super.onPageFinished(view, url);
            if (!this.isErrorOccured) {
                if (MraidView.this.state == null || MraidView.this.state != "expanded" && MraidView.this.state != "resized") {
                    MraidView.this.displayAD();
                }
                if (MraidView.this.adListener != null) {
                    MraidView.this.adListener.onAdLoadedListener();
                }
                MraidView.this.setDataInJs();
            }
        }

        public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
            this.isErrorOccured = true;
            super.onReceivedError(view, errorCode, description, failingUrl);
            if (MraidView.this.adListener != null) {
                MraidView.this.adListener.onErrorListener(description);
            }
            if (MraidView.this.handler != null) {
                MraidView.this.handler.sendEmptyMessage(-4);
            }
        }
    }

    public class JavaScriptInterface
    extends MraidJS {
        @JavascriptInterface
        public void printJSLog(String log) {
            Log.i((String)"AirMraid", (String)("JS Log: " + log));
        }

        @JavascriptInterface
        public void expand() {
            this.expand("");
        }

        @JavascriptInterface
        public void expand(final String url) {
            MraidView.this.post(new Runnable(){

                public void run() {
                    MraidView.this.expand(url);
                }
            });
        }

        @JavascriptInterface
        public void close() {
            MraidView.this.post(new Runnable(){

                public void run() {
                    MraidView.this.close();
                }
            });
        }

        @JavascriptInterface
        public void open(String url) {
            if (MraidView.this.adListener != null) {
                MraidView.this.adListener.onAdClickListener();
            }
            Intent intent = new Intent(MraidView.this.getContext(), BrowserActivity.class);
            intent.setAction("browser");
            intent.addFlags(0x10000000);
            intent.addFlags(0x800000);
            intent.putExtra("url", url);
            try {
                MraidView.this.getContext().startActivity(intent);
                MraidView.this.sendEventData("96");
            }
            catch (ActivityNotFoundException activityNotFoundException) {
                Log.e((String)"AirMraid", (String)"Required BrowserActivty is not added in manifest please add.");
                if (MraidView.this.adListener != null) {
                    MraidView.this.adListener.onErrorListener("Required BrowserActivty is not added in manifest please add.");
                }
                MraidView.this.sendEventData("89");
            }
            MraidView.this.canFetchAd(true);
        }

        @JavascriptInterface
        public void setExpandProperties(String json) {
            Util.printDebugLog("Expand Json: " + json);
            if (MraidView.this.expandProperties != null) {
                MraidView.this.expandProperties.setProperties(json);
            } else {
                MraidView.this.expandProperties = new ExpandProperties();
                MraidView.this.expandProperties.setProperties(json);
            }
        }

        @JavascriptInterface
        public void setResizeProperties(String properties) {
            if (null != MraidView.this.mraidAdUtil) {
                MraidView.this.mraidAdUtil.setResizeProperties(properties);
            }
        }

        @JavascriptInterface
        public void resize() {
            MraidView.this.post(new Runnable(){

                public void run() {
                    MraidView.this.resize();
                }
            });
        }

        @JavascriptInterface
        public void playVideo(final String url) {
            MraidView.this.post(new Runnable(){

                public void run() {
                    MraidView.this.playVideo(url);
                }
            });
        }

        @JavascriptInterface
        public void storePicture(final String url, final String fileName) {
            MraidView.this.post(new Runnable(){

                public void run() {
                    MraidView.this.storePicture(url, fileName);
                }
            });
        }

        @JavascriptInterface
        public void createCalendarEvent(final String json) {
            MraidView.this.post(new Runnable(){

                public void run() {
                    MraidView.this.createCalendarEvent(json);
                }
            });
        }

        @JavascriptInterface
        public void setOrientationProperties(String json) {
            Util.printDebugLog("Orientation json: " + json);
            boolean allowOrientationChange = true;
            String forceOrientation = "none";
            try {
                JSONObject jsonObject = new JSONObject(json);
                allowOrientationChange = jsonObject.isNull("allowOrientationChange") ? true : jsonObject.getBoolean("allowOrientationChange");
                forceOrientation = jsonObject.isNull("forceOrientation") ? "none" : jsonObject.getString("forceOrientation");
                MraidView.this.mraidAdUtil.setForceOrientation(forceOrientation);
                MraidView.this.mraidAdUtil.setOrientationChange(allowOrientationChange);
                MraidView.this.post(new Runnable(){

                    public void run() {
                        MraidView.this.setAdOrientation();
                    }
                });
            }
            catch (Exception exception) {
                MraidView.this.triggerErrorEvent("setOrientationProperties", "Error occured in while parsing orientation json.");
            }
        }

        @JavascriptInterface
        public void showDialer(String phoneNumber) {
            Log.i((String)"AirMraid", (String)"Showing dialer.....");
            try {
                if (MraidView.this.adListener != null) {
                    MraidView.this.adListener.onAdClickListener();
                }
                if (phoneNumber == null || phoneNumber.equals("")) {
                    MraidView.this.triggerErrorEvent("showDialer", "Phone numer is null.");
                    return;
                }
                Uri uri = Uri.parse((String)("tel:" + phoneNumber));
                Intent intent = new Intent("android.intent.action.DIAL", uri);
                intent.addFlags(0x10000000);
                intent.addFlags(0x800000);
                MraidView.this.getContext().startActivity(intent);
                MraidView.this.sendEventData("97");
            }
            catch (ActivityNotFoundException e) {
                MraidView.this.triggerErrorEvent("showDialer", "Error occurred while dialing number.");
                Log.e((String)"AirMraid", (String)("Error whlie displaying push ad......: " + e.getMessage()));
                MraidView.this.sendEventData("89");
            }
            MraidView.this.canFetchAd(true);
        }

        @JavascriptInterface
        public void sendSms(String number, String sms_text) {
            Log.i((String)"AirMraid", (String)"Sending SMS.....");
            try {
                if (MraidView.this.adListener != null) {
                    MraidView.this.adListener.onAdClickListener();
                }
                if (number == null || number.equals("")) {
                    MraidView.this.triggerErrorEvent("sendSms", "Numer is null.");
                    return;
                }
                if (sms_text == null || sms_text.equals("")) {
                    MraidView.this.triggerErrorEvent("sendSms", "SMS text is null.");
                    return;
                }
                Intent intent = new Intent("android.intent.action.VIEW");
                intent.addFlags(0x10000000);
                intent.setType("vnd.android-dir/mms-sms");
                intent.putExtra("address", number);
                intent.putExtra("sms_body", sms_text);
                MraidView.this.getContext().startActivity(intent);
                MraidView.this.sendEventData("98");
            }
            catch (Exception e) {
                Log.e((String)"AirMraid", (String)("Error whlie displaying push ad......: " + e.getMessage()));
                MraidView.this.triggerErrorEvent("sendSms", "Error occurred while sending message");
                MraidView.this.sendEventData("error");
            }
            MraidView.this.canFetchAd(true);
        }

        @JavascriptInterface
        public void downloadApp(String url) {
            try {
                if (MraidView.this.adListener != null) {
                    MraidView.this.adListener.onAdClickListener();
                }
                Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)url));
                intent.setFlags(0x10000000);
                intent.addFlags(0x800000);
                MraidView.this.getContext().startActivity(intent);
                MraidView.this.sendEventData("77");
            }
            catch (Exception e) {
                Log.e((String)"AirMraid", (String)("Error whlie displaying App......: " + e.getMessage()));
                MraidView.this.triggerErrorEvent("downloadApp", "Error occurred while redirecting to market.");
                MraidView.this.sendEventData("error");
            }
            MraidView.this.canFetchAd(true);
        }

        @JavascriptInterface
        public void showLocation(String latitude, String longitude) {
            try {
                if (MraidView.this.adListener != null) {
                    MraidView.this.adListener.onAdClickListener();
                }
                String url = String.format(Locale.ENGLISH, "geo:%f,%f", latitude, longitude);
                Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)url));
                intent.setFlags(0x10000000);
                intent.addFlags(0x800000);
                MraidView.this.getContext().startActivity(intent);
                MraidView.this.sendEventData("79");
            }
            catch (Exception e) {
                Log.e((String)"AirMraid", (String)("Error occurred whlie displaying Location......: " + e.getMessage()));
                MraidView.this.triggerErrorEvent("showLoaction", "Error occurred while showing location.");
                MraidView.this.sendEventData("error");
            }
            MraidView.this.canFetchAd(true);
        }
    }

    class ExpandProperties {
        boolean useCustomClose = false;

        ExpandProperties() {
        }

        String getProperties() {
            JSONObject jsonObject = new JSONObject();
            try {
                jsonObject.put("width", MraidView.this.widthDp);
                jsonObject.put("height", MraidView.this.heightDp);
                jsonObject.put("useCustomClose", this.useCustomClose);
                jsonObject.put("isModal", true);
            }
            catch (JSONException exception) {
                exception.printStackTrace();
            }
            return jsonObject.toString();
        }

        void setProperties(String json) {
            try {
                JSONObject jsonObject = new JSONObject(json);
                MraidView.this.width = jsonObject.isNull("width") ? MraidView.this.widthDp : jsonObject.getInt("width");
                MraidView.this.height = jsonObject.isNull("height") ? MraidView.this.heightDp : jsonObject.getInt("height");
                this.useCustomClose = jsonObject.isNull("useCustomClose") ? false : jsonObject.getBoolean("useCustomClose");
            }
            catch (JSONException exception) {
                exception.printStackTrace();
            }
            catch (Exception e) {
                MraidView.this.triggerErrorEvent("setExpandProperties", "An error occured while parsing expand properties json;");
            }
        }
    }
}

