/*
 * Decompiled with CFR 0.152.
 */
package com.dhf.doj;

import android.content.Context;
import android.util.Log;
import com.dhf.doj.AsyncTaskCompleteListener;
import com.dhf.doj.SetPreferences;
import com.dhf.doj.Util;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.List;
import java.util.zip.GZIPInputStream;
import javax.net.ssl.SSLPeerUnverifiedException;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.NameValuePair;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.HttpEntityWrapper;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicHttpResponse;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class NetworkThread
implements Runnable {
    private static final String HEADER_ACCEPT_ENCODING = "Accept-Encoding";
    private static final String ENCODING_GZIP = "gzip";
    final Context context;
    final AsyncTaskCompleteListener<String> asyncTaskCompleteListener;
    final List<NameValuePair> list;
    final String url;
    final long wait;
    final boolean isAddvalues;

    public NetworkThread(Context context, AsyncTaskCompleteListener<String> asyncTaskCompleteListener, List<NameValuePair> list, String url, long wait, boolean isAddValues) {
        this.context = context;
        this.asyncTaskCompleteListener = asyncTaskCompleteListener;
        this.list = list;
        this.url = url;
        Util.printDebugLog("Url: " + url);
        this.wait = wait;
        this.isAddvalues = isAddValues;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        NetworkThread networkThread = this;
        synchronized (networkThread) {
            if (this.wait != 0L) {
                try {
                    Util.printDebugLog("Thread is waiting for " + this.wait + " ms.");
                    this.wait(this.wait);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            if (Util.checkInternetConnection(this.context)) {
                try {
                    if (this.isAddvalues) {
                        this.list.addAll(SetPreferences.setValues(this.context));
                    }
                    HttpPost httpPost = new HttpPost(this.url);
                    Util.printDebugLog("Values: " + this.list);
                    httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(this.list));
                    BasicHttpParams httpParameters = new BasicHttpParams();
                    int timeoutConnection = 7000;
                    HttpConnectionParams.setConnectionTimeout((HttpParams)httpParameters, (int)timeoutConnection);
                    int timeoutSocket = 7000;
                    HttpConnectionParams.setSoTimeout((HttpParams)httpParameters, (int)timeoutSocket);
                    DefaultHttpClient httpClient = new DefaultHttpClient((HttpParams)httpParameters);
                    httpClient.getParams().setParameter("http.useragent", (Object)System.getProperty("http.agent"));
                    httpClient.addRequestInterceptor(new HttpRequestInterceptor(){

                        public void process(HttpRequest request, HttpContext context) {
                            if (!request.containsHeader(NetworkThread.HEADER_ACCEPT_ENCODING)) {
                                request.addHeader(NetworkThread.HEADER_ACCEPT_ENCODING, NetworkThread.ENCODING_GZIP);
                            }
                        }
                    });
                    httpClient.addResponseInterceptor(new HttpResponseInterceptor(){

                        public void process(HttpResponse response, HttpContext context) {
                            HttpEntity entity = response.getEntity();
                            Header encoding = entity.getContentEncoding();
                            if (encoding != null) {
                                for (HeaderElement element : encoding.getElements()) {
                                    if (!element.getName().equalsIgnoreCase(NetworkThread.ENCODING_GZIP)) continue;
                                    response.setEntity((HttpEntity)new InflatingEntity(response.getEntity()));
                                    break;
                                }
                            }
                        }
                    });
                    BasicHttpResponse httpResponse = (BasicHttpResponse)httpClient.execute((HttpUriRequest)httpPost);
                    int code = httpResponse.getStatusLine().getStatusCode();
                    Log.i((String)"AirSDK", (String)("Status Code: " + code));
                    if (code == 200) {
                        String responseString = EntityUtils.toString((HttpEntity)httpResponse.getEntity());
                        Util.printDebugLog("Response String:" + responseString);
                        if (responseString != null && !responseString.equals("")) {
                            this.asyncTaskCompleteListener.onTaskComplete(responseString);
                            return;
                        }
                    } else {
                        Log.i((String)"AirSDK", (String)("HTTP response reason: " + httpResponse.getStatusLine().getReasonPhrase()));
                    }
                }
                catch (UnknownHostException e) {
                    Log.d((String)"UnknownHostException Thrown", (String)e.toString());
                }
                catch (SocketTimeoutException e) {
                    Log.d((String)"SocketTimeoutException Thrown", (String)e.toString());
                }
                catch (ClientProtocolException e) {
                    Log.d((String)"ClientProtocolException Thrown", (String)e.toString());
                }
                catch (MalformedURLException e) {
                    System.out.println("Url has caused malford: " + this.url);
                    Log.d((String)"MalformedURLException Thrown", (String)e.toString());
                }
                catch (SSLPeerUnverifiedException e) {
                    Log.d((String)"SSL Exception: ", (String)e.getMessage());
                }
                catch (IOException e) {
                    Log.d((String)"IOException Thrown", (String)e.toString());
                }
                catch (Exception iex) {
                    Log.d((String)"Exception Thrown: ", (String)("" + iex.getMessage()));
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            this.asyncTaskCompleteListener.onTaskComplete(null);
        }
    }

    private static class InflatingEntity
    extends HttpEntityWrapper {
        public InflatingEntity(HttpEntity wrapped) {
            super(wrapped);
        }

        public InputStream getContent() throws IOException {
            return new GZIPInputStream(this.wrappedEntity.getContent());
        }

        public long getContentLength() {
            return -1L;
        }
    }
}

