/*
 * Decompiled with CFR 0.152.
 */
package com.dhf.doj;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.Dialog;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.JavascriptInterface;
import android.webkit.WebChromeClient;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.RelativeLayout;
import com.dhf.doj.AirSDK;
import com.dhf.doj.Util;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.util.EntityUtils;

class OverlayAd
extends Dialog
implements DialogInterface.OnCancelListener,
DialogInterface.OnDismissListener {
    private final String TAG = "AirSDK";
    static final String AD_TYPE_DIALOG_U = "DAU";
    static final String AD_TYPE_DIALOG_CM = "DCM";
    static final String AD_TYPE_DIALOG_CC = "DCC";
    static final String AD_TYPE_OVERLAY = "OLAU";
    private final String event_overlay_push = "23";
    private final String event_overlay_click = "24";
    private final String event_overlay_click_no = "25";
    private final String event_dialog_push = "43";
    private final String event_dialog_click_yes = "44";
    private final String event_dialog_click_no = "45";
    private final String event_dialog_error = "184";
    private final String event_overlay_error = "183";
    Activity context;
    private static int height = 250;
    private static int width = 300;
    private static String tag;
    private static boolean error;
    private static String apiUrl;
    private WebView webView;
    private static String adtype;
    private boolean errorInLoading = false;
    private boolean isCliked = false;
    View.OnTouchListener onTouchListener = new View.OnTouchListener(){

        public boolean onTouch(View v, MotionEvent event) {
            if (v == OverlayAd.this.webView && event.getAction() == 0) {
                OverlayAd.this.isCliked = true;
            }
            return false;
        }
    };

    @SuppressLint(value={"SetJavaScriptEnabled"})
    public OverlayAd(Activity context) {
        super((Context)context);
        try {
            this.context = context;
            this.requestWindowFeature(1);
            this.getWindow().setBackgroundDrawable((Drawable)new ColorDrawable(0));
            this.setCancelable(false);
            this.setCanceledOnTouchOutside(false);
            this.setOnCancelListener(this);
            this.setOnDismissListener(this);
            float scale = context.getResources().getDisplayMetrics().density;
            RelativeLayout linearLayout = new RelativeLayout((Context)context);
            linearLayout.setId(76);
            RelativeLayout.LayoutParams mainLayoutParams1 = new RelativeLayout.LayoutParams(-2, -2);
            mainLayoutParams1.addRule(13);
            linearLayout.setLayoutParams((ViewGroup.LayoutParams)mainLayoutParams1);
            this.webView = new WebView((Context)context);
            this.webView.setId(54);
            this.webView.getSettings().setJavaScriptEnabled(true);
            this.webView.setWebChromeClient(new WebChromeClient());
            this.webView.setHorizontalScrollBarEnabled(false);
            this.webView.setVerticalScrollBarEnabled(false);
            this.webView.getSettings().setCacheMode(-1);
            this.webView.setBackgroundColor(0);
            this.webView.setScrollBarStyle(0x2000000);
            this.webView.addJavascriptInterface((Object)new JavaScriptInterface(), "Overlay");
            this.webView.setOnTouchListener(this.onTouchListener);
            this.webView.setWebViewClient(new WebViewClient(){

                public void onLoadResource(WebView view, String url) {
                    if (OverlayAd.this.isCliked && OverlayAd.this.isShowing()) {
                        OverlayAd.this.open(url);
                    } else {
                        super.onLoadResource(view, url);
                    }
                }

                public void onPageFinished(WebView view, String url) {
                    super.onPageFinished(view, url);
                    try {
                        if (OverlayAd.this.errorInLoading) {
                            Log.i((String)"AirSDK", (String)"Error in loading");
                            OverlayAd.this.dismiss();
                            if (adtype.equals(OverlayAd.AD_TYPE_DIALOG_U) || adtype.equals(OverlayAd.AD_TYPE_DIALOG_CC) || adtype.equals(OverlayAd.AD_TYPE_DIALOG_CM)) {
                                OverlayAd.this.sendEventData("184");
                            } else {
                                OverlayAd.this.sendEventData("183");
                            }
                            return;
                        }
                        OverlayAd.this.show();
                        if (adtype.equals(OverlayAd.AD_TYPE_DIALOG_U) || adtype.equals(OverlayAd.AD_TYPE_DIALOG_CC) || adtype.equals(OverlayAd.AD_TYPE_DIALOG_CM)) {
                            OverlayAd.this.sendEventData("43");
                        } else {
                            OverlayAd.this.sendEventData("23");
                        }
                        if (AirSDK.adCallbackListener != null) {
                            AirSDK.adCallbackListener.onSmartWallAdShowing();
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        OverlayAd.this.context.finish();
                    }
                }

                public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
                    OverlayAd.this.errorInLoading = true;
                    try {
                        OverlayAd.this.dismiss();
                        OverlayAd.this.context.finish();
                    }
                    catch (Throwable e) {
                        Log.e((String)"AirSDK", (String)("Error occurred while loading Overlay Ad: code " + errorCode + ", desc: " + description));
                    }
                    super.onReceivedError(view, errorCode, description, failingUrl);
                }

                public boolean shouldOverrideUrlLoading(WebView view, String url) {
                    try {
                        if (OverlayAd.this.isCliked) {
                            OverlayAd.this.open(url);
                            return true;
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        OverlayAd.this.dismiss();
                        OverlayAd.this.context.finish();
                    }
                    view.loadUrl(url);
                    return true;
                }
            });
            this.webView.loadDataWithBaseURL(null, tag, "text/html", "UTF-8", null);
            RelativeLayout.LayoutParams webLayoutParams = new RelativeLayout.LayoutParams(width, height);
            webLayoutParams.addRule(13);
            this.webView.setLayoutParams((ViewGroup.LayoutParams)webLayoutParams);
            linearLayout.addView((View)this.webView);
            this.setContentView((View)linearLayout);
        }
        catch (Exception e) {
            Log.e((String)"AirSDK", (String)"An error occured while starting Overlay Ad.");
            try {
                this.dismiss();
                context.finish();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void open(String url) {
        try {
            this.dismiss();
            try {
                String packageName = "com.android.browser";
                String className = "com.android.browser.BrowserActivity";
                Intent internetIntent = new Intent("android.intent.action.VIEW", Uri.parse((String)url));
                internetIntent.setFlags(0x10000000);
                internetIntent.addFlags(0x800000);
                internetIntent.addCategory("android.intent.category.LAUNCHER");
                internetIntent.setClassName(packageName, className);
                this.context.startActivity(internetIntent);
                if (adtype.equals(AD_TYPE_DIALOG_U) || adtype.equals(AD_TYPE_DIALOG_CC) || adtype.equals(AD_TYPE_DIALOG_CM)) {
                    this.sendEventData("44");
                } else {
                    this.sendEventData("24");
                }
                return;
            }
            catch (ActivityNotFoundException e) {
                Log.i((String)"AirSDK", (String)"Browser not found.");
                Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)url));
                intent.setFlags(0x10000000);
                intent.addFlags(0x800000);
                this.context.startActivity(intent);
                if (adtype.equals(AD_TYPE_DIALOG_U) || adtype.equals(AD_TYPE_DIALOG_CC) || adtype.equals(AD_TYPE_DIALOG_CM)) {
                    this.sendEventData("44");
                } else {
                    this.sendEventData("24");
                }
                this.context.finish();
            }
        }
        catch (ActivityNotFoundException e) {
            Log.e((String)"AirSDK", (String)("Error whlie displaying dialog ad......: " + e.getMessage()));
            this.context.finish();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.context.finish();
        }
    }

    public void onCancel(DialogInterface dialog) {
        try {
            if (dialog != null) {
                dialog.dismiss();
            }
            this.context.finish();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void onDismiss(DialogInterface dialog) {
        try {
            try {
                if (this != null) {
                    if (this.webView != null) {
                        this.webView.stopLoading();
                        this.webView.removeAllViews();
                        this.webView.destroy();
                    }
                    this.dismiss();
                }
            }
            catch (Exception e) {
            }
            catch (Throwable e) {
                // empty catch block
            }
            this.context.finish();
        }
        catch (Exception e) {
            this.context.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void sendEventData(final String event) {
        String string = event;
        synchronized (string) {
            if (!Util.checkInternetConnection(this.getContext())) {
                return;
            }
            Thread thread = new Thread(new Runnable(){

                public void run() {
                    try {
                        Log.i((String)"AirSDK", (String)"Sending overlay event: ");
                        if (!error && (event.equals("184") || event.equals("183"))) {
                            Util.printDebugLog("Error reporting is off.");
                            return;
                        }
                        String url = apiUrl;
                        if (apiUrl.contains("%event%")) {
                            url = url.replace("%event%", event);
                        }
                        Util.printDebugLog("URL: " + url);
                        DefaultHttpClient httpclient = new DefaultHttpClient();
                        HttpPost httppost = new HttpPost(url);
                        BasicHttpParams basicHttpParams = new BasicHttpParams();
                        httppost.setParams((HttpParams)basicHttpParams);
                        HttpConnectionParams.setConnectionTimeout((HttpParams)basicHttpParams, (int)15000);
                        HttpConnectionParams.setSoTimeout((HttpParams)basicHttpParams, (int)10000);
                        HttpResponse response = httpclient.execute((HttpUriRequest)httppost);
                        int code = response == null ? 0 : response.getStatusLine().getStatusCode();
                        Log.i((String)"AirSDK", (String)("Status code: " + code));
                        if (code == 200) {
                            String string = EntityUtils.toString((HttpEntity)response.getEntity());
                            Log.i((String)"AirSDK", (String)("Overlay Data: " + string));
                        }
                    }
                    catch (Exception e) {
                        Log.e((String)"AirSDK", (String)"Exception in overlay: ", (Throwable)e);
                    }
                }
            }, "overlay_event");
            thread.start();
        }
    }

    public static void setHeight(int height) {
        OverlayAd.height = height;
    }

    public static void setWidth(int width) {
        OverlayAd.width = width;
    }

    public static void setTag(String tag) {
        OverlayAd.tag = tag;
    }

    public static void setError(boolean error) {
        OverlayAd.error = error;
    }

    public static void setApiUrl(String apiUrl) {
        OverlayAd.apiUrl = apiUrl;
    }

    public static void setAdtype(String adtype) {
        OverlayAd.adtype = adtype;
    }

    static {
        error = false;
        adtype = "";
    }

    private class JavaScriptInterface {
        private JavaScriptInterface() {
        }

        @JavascriptInterface
        public void close() {
            OverlayAd.this.dismiss();
            if (adtype.equals(OverlayAd.AD_TYPE_DIALOG_U) || adtype.equals(OverlayAd.AD_TYPE_DIALOG_CC) || adtype.equals(OverlayAd.AD_TYPE_DIALOG_CM)) {
                OverlayAd.this.sendEventData("45");
            } else {
                OverlayAd.this.sendEventData("25");
            }
            OverlayAd.this.context.finish();
        }

        @JavascriptInterface
        public void open(String url) {
            OverlayAd.this.open(url);
            OverlayAd.this.context.finish();
        }

        @JavascriptInterface
        public void call(String number) {
            try {
                OverlayAd.this.dismiss();
                Uri uri = Uri.parse((String)("tel:" + number));
                Intent intent = new Intent("android.intent.action.DIAL", uri);
                intent.addFlags(0x10000000);
                OverlayAd.this.context.startActivity(intent);
                if (adtype.equals(OverlayAd.AD_TYPE_DIALOG_U) || adtype.equals(OverlayAd.AD_TYPE_DIALOG_CC) || adtype.equals(OverlayAd.AD_TYPE_DIALOG_CM)) {
                    OverlayAd.this.sendEventData("44");
                } else {
                    OverlayAd.this.sendEventData("24");
                }
            }
            catch (ActivityNotFoundException e) {
                e.printStackTrace();
            }
            catch (Exception exception) {
                // empty catch block
            }
            OverlayAd.this.context.finish();
        }

        @JavascriptInterface
        public void sms(String number, String text) {
            try {
                OverlayAd.this.dismiss();
                Intent intent = new Intent("android.intent.action.VIEW");
                intent.addFlags(0x10000000);
                intent.setType("vnd.android-dir/mms-sms");
                intent.putExtra("address", number);
                intent.putExtra("sms_body", text);
                OverlayAd.this.context.startActivity(intent);
                if (adtype.equals(OverlayAd.AD_TYPE_DIALOG_U) || adtype.equals(OverlayAd.AD_TYPE_DIALOG_CC) || adtype.equals(OverlayAd.AD_TYPE_DIALOG_CM)) {
                    OverlayAd.this.sendEventData("44");
                } else {
                    OverlayAd.this.sendEventData("24");
                }
            }
            catch (Exception e) {
                OverlayAd.this.context.finish();
                e.printStackTrace();
            }
        }
    }
}

