/*
 * Decompiled with CFR 0.152.
 */
package com.dhf.doj;

import android.app.AlarmManager;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.IBinder;
import android.util.Log;
import com.dhf.doj.AirSDK;
import com.dhf.doj.AsyncTaskCompleteListener;
import com.dhf.doj.BootReceiver;
import com.dhf.doj.FormatAds;
import com.dhf.doj.HandleClicks;
import com.dhf.doj.HttpPostDataTask;
import com.dhf.doj.IConstants;
import com.dhf.doj.SendIntegrationError;
import com.dhf.doj.SetPreferences;
import com.dhf.doj.UserDetails;
import com.dhf.doj.Util;
import java.util.Calendar;
import java.util.List;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;

public class PushService
extends Service {
    private static final String TAG = "AirSDK";
    static final String INTENT_ACTION_SET_MESSAGE_RECEIVER = "SetMessageReceiver";
    static final String INTENT_ACTION_POST_AD_VALUES = "PostAdValues";
    static final String INTENT_ACTION_BOOT_RECEIVER = "bootReceiver";
    static final String INTENT_ACTION_CANCEL_NOTIFICATION = "cancelNotification";
    static final String INTENT_ACTION_CANCEL_ALARM = "cancelAlarm";
    private static long delay_after_boot = 0L;
    private static final int[] gap_after_boot = new int[]{10, 30, 50, 70, 90, 110, 130, 150, 170, 190};
    private static final int[] gap_no_con = new int[]{1200, 1800, 2400, 3600};
    private final String MODEL_MESSAGE = "message";
    private final String ACTION_GET_MESSAGE = "getmessage";
    private Context context;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onStart(Intent intent, int startId) {
        this.context = this.getApplicationContext();
        Integer startIdObj = startId;
        try {
            String action = "";
            action = intent.getAction();
            String msg_action = INTENT_ACTION_SET_MESSAGE_RECEIVER + this.getPackageName();
            String cancel_action = INTENT_ACTION_CANCEL_NOTIFICATION + this.getPackageName();
            if (action.equals(msg_action)) {
                if (SetPreferences.getDataSharedPrefrences(this.context)) {
                    if (Util.isDoPush()) {
                        this.getPushMessage();
                    } else {
                        Log.i((String)TAG, (String)"Push notification not enabled.");
                    }
                } else {
                    Util.printDebugLog("Preference is null");
                }
            } else if (action.equals(INTENT_ACTION_POST_AD_VALUES)) {
                String adtype;
                if (!SetPreferences.getNotificationData(this.getApplicationContext())) {
                    Util.printDebugLog("Unable to retrive notification preference data");
                } else {
                    Util.setApiKey(intent.getStringExtra("APIKEY"));
                    Util.setAppID(intent.getStringExtra("appId"));
                    Util.setAdType(intent.getStringExtra("adtype"));
                    adtype = Util.getAdType();
                    if (adtype.equals("W") || adtype.equals("A") || adtype.equals("BPNW") || adtype.equals("BPW") || adtype.equals("BPA") || adtype.equals("BPNA")) {
                        Util.setNotificationUrl(intent.getStringExtra("url"));
                        Util.setHeader(intent.getStringExtra("header"));
                    } else if (adtype.equals("CM") || adtype.equals("BPCM") || adtype.equals("BPNCM")) {
                        Util.setSms(intent.getStringExtra("sms"));
                        Util.setPhoneNumber(intent.getStringExtra("number"));
                    } else if (adtype.equals("CC") || adtype.equals("BPCC") || adtype.equals("BPNCC")) {
                        Util.setPhoneNumber(intent.getStringExtra("number"));
                    }
                    Util.setCreativeId(intent.getStringExtra("creativeId"));
                    Util.setCampId(intent.getStringExtra("campId"));
                    Util.setTestmode(intent.getBooleanExtra("testMode", false));
                }
                adtype = Util.getAdType();
                if (adtype.equals("CC") || adtype.equals("BPCC") || adtype.equals("BPNCC")) {
                    this.postAdValues(intent);
                    new HandleClicks((Context)this).callNumber(Util.getPhoneNumber());
                } else if (adtype.equals("CM") || adtype.equals("BPCM") || adtype.equals("BPNCM")) {
                    this.postAdValues(intent);
                    new HandleClicks((Context)this).sendSms(Util.getSms(), Util.getPhoneNumber());
                } else if (adtype.equals("W") || adtype.equals("A") || adtype.equals("BPNW") || adtype.equals("BPW") || adtype.equals("BPA") || adtype.equals("BPNA")) {
                    this.postAdValues(intent);
                    new HandleClicks((Context)this).displayUrl(Util.getNotificationUrl());
                }
                PushService.exipryTimeAlarm(this.getApplicationContext(), true);
            } else if (action.equals(INTENT_ACTION_BOOT_RECEIVER)) {
                delay_after_boot = PushService.random(gap_after_boot);
                Util.printDebugLog("Push is called from BootReceiver. Random delay time: " + delay_after_boot);
                PushService.startAirpush(this.getApplicationContext());
            } else if (action.equals(cancel_action)) {
                this.cancelNotification();
            } else if (action.equals(INTENT_ACTION_CANCEL_ALARM)) {
                Util.printDebugLog("Notification cleared. So canceling alarm.");
                PushService.exipryTimeAlarm(this.getApplicationContext(), true);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Util.printDebugLog("Error in push Service: " + e.getMessage());
        }
        finally {
            if (startIdObj != null) {
                this.stopSelf(startId);
            }
        }
    }

    private synchronized void getPushMessage() {
        if (this.context == null) {
            this.context = this.getApplicationContext();
        }
        if (AirSDK.isSDKEnabled(this.context)) {
            Log.i((String)TAG, (String)"Receiving message.......");
            try {
                AsyncTaskCompleteListener<String> asyncTaskCompleteListener = new AsyncTaskCompleteListener<String>(){

                    @Override
                    public void onTaskComplete(String result) {
                        Log.i((String)PushService.TAG, (String)("Push Message: " + result));
                        if (result != null && !result.equals("")) {
                            new FormatAds.NotificationJson(PushService.this.getApplicationContext(), result);
                        } else {
                            Util.printDebugLog("Push message response is null.");
                            PushService.reStartSDK(PushService.this.context, false);
                        }
                    }

                    @Override
                    public void launchNewHttpTask() {
                        try {
                            List<NameValuePair> values = SetPreferences.setValues(PushService.this.context);
                            values.add((NameValuePair)new BasicNameValuePair("model", "message"));
                            values.add((NameValuePair)new BasicNameValuePair("action", "getmessage"));
                            try {
                                int i = PushService.getNotificationXML(PushService.this.context);
                                boolean b = PushService.validateFields(PushService.this.context);
                                if (i != 0 && b) {
                                    values.add((NameValuePair)new BasicNameValuePair("isXMLFound", "1"));
                                } else {
                                    values.add((NameValuePair)new BasicNameValuePair("isXMLFound", "0"));
                                }
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                            Util.printDebugLog("Get Push Values: " + values);
                            String url = "https://api.airpush.com/v2/api.php";
                            if (Util.isTestmode()) {
                                url = "https://api.airpush.com/testmsg2.php";
                            }
                            HttpPostDataTask httpPostTask = new HttpPostDataTask((Context)PushService.this, values, url, this);
                            httpPostTask.execute(new Void[0]);
                        }
                        catch (NullPointerException e) {
                            e.printStackTrace();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                };
                if (Util.checkInternetConnection(this.context)) {
                    asyncTaskCompleteListener.launchNewHttpTask();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                Log.i((String)"Activitymanager", (String)"Message Fetching Failed.....");
                Log.i((String)"Activitymanager", (String)e.toString());
                PushService.reStartSDK(this.context, false);
            }
        } else {
            Log.i((String)TAG, (String)"AirSDK is disabled, please enable to receive ads.");
            AirSDK.sendAdError("AirSDK is disabled Please enable to recive ads.");
        }
    }

    private synchronized void postAdValues(Intent intent) {
        try {
            if (!Util.isTestmode()) {
                AsyncTaskCompleteListener<String> asyncTaskCompleteListener = new AsyncTaskCompleteListener<String>(){

                    @Override
                    public void launchNewHttpTask() {
                        List<NameValuePair> values = null;
                        try {
                            values = SetPreferences.setValues(PushService.this.context);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        try {
                            if (values == null || values.isEmpty()) {
                                AirSDK.getDataFromManifest(PushService.this.context);
                                UserDetails details = new UserDetails(PushService.this.getApplicationContext());
                                details.setImeiInMd5();
                                new SetPreferences(PushService.this.getApplicationContext()).setPreferencesData();
                                SetPreferences.getDataSharedPrefrences(PushService.this.context);
                                values = SetPreferences.setValues(PushService.this.getApplicationContext());
                            }
                            values.add((NameValuePair)new BasicNameValuePair("model", "log"));
                            values.add((NameValuePair)new BasicNameValuePair("action", "settexttracking"));
                            values.add((NameValuePair)new BasicNameValuePair("event", "TrayClicked"));
                            values.add((NameValuePair)new BasicNameValuePair("campId", Util.getCampId()));
                            values.add((NameValuePair)new BasicNameValuePair("creativeId", Util.getCreativeId()));
                            Util.printDebugLog("Posting values: " + values.toString());
                            HttpPostDataTask httpPostTask = new HttpPostDataTask((Context)PushService.this, values, "https://api.airpush.com/v2/api.php", this);
                            httpPostTask.execute(new Void[0]);
                        }
                        catch (NullPointerException e) {
                            e.printStackTrace();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }

                    @Override
                    public void onTaskComplete(String result) {
                        Log.i((String)PushService.TAG, (String)("Click : " + result));
                    }
                };
                if (Util.checkInternetConnection(this.getApplicationContext())) {
                    asyncTaskCompleteListener.launchNewHttpTask();
                }
            }
        }
        catch (Exception e) {
            Util.printLog("Error while posting ad values");
        }
    }

    private void cancelNotification() {
        try {
            NotificationManager manager = (NotificationManager)this.getSystemService("notification");
            manager.cancel(999);
            Log.i((String)TAG, (String)"Notification cleared.");
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("Notification not cleared. " + e.getMessage()));
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    static void exipryTimeAlarm(Context context, boolean cancel) {
        try {
            Intent intent = new Intent(context, PushService.class);
            String action = INTENT_ACTION_CANCEL_NOTIFICATION + context.getPackageName();
            intent.setAction(action);
            PendingIntent pendingIntent = PendingIntent.getService((Context)context, (int)0, (Intent)intent, (int)0x10000000);
            AlarmManager alarmManager = (AlarmManager)context.getSystemService("alarm");
            long l = System.currentTimeMillis() + Util.getExpiry_time() * 1000L;
            alarmManager.set(0, l, pendingIntent);
            if (cancel) {
                alarmManager.cancel(pendingIntent);
                Util.printDebugLog("Expiry Alarm cancelled");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    static int getAppIcon(Context context) {
        try {
            PackageInfo p = context.getPackageManager().getPackageInfo(context.getPackageName(), 128);
            int iconid = p.applicationInfo.icon;
            return iconid;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return 0;
        }
    }

    static int getNotificationXML(Context context) {
        try {
            Class<?> cls2 = Class.forName(context.getPackageName() + ".R$layout");
            int layout = cls2.getField("airsdk_notify").getInt(cls2);
            return layout;
        }
        catch (NoSuchFieldException exception) {
            String err = "Required airsdk_notify.xml file not found in layout folder. Please add.";
            Log.e((String)TAG, (String)err, (Throwable)exception);
            AirSDK.sendIntegrationError(err);
        }
        catch (Exception exception) {
            Log.e((String)TAG, (String)"Error while check airsdk_notify.xml", (Throwable)exception);
        }
        return 0;
    }

    static boolean validateFields(Context context) {
        try {
            Class<?> idClass = Class.forName(context.getPackageName() + ".R$id");
            int ntitle = idClass.getField("title").getInt(idClass);
            int tlayout = idClass.getField("notify").getInt(idClass);
            int bannerImage = idClass.getField("imageView").getInt(idClass);
            int bannerText = idClass.getField("textView").getInt(idClass);
            int ntext = idClass.getField("textView1").getInt(idClass);
            int nicon = idClass.getField("imageView1").getInt(idClass);
            return true;
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"Invalid airsdk_notify.xml file.", (Throwable)e);
            AirSDK.sendIntegrationError("Invalid airsdk_notify.xml file.");
            return false;
        }
    }

    static void startAirpush(final Context context) {
        try {
            PackageManager packageManager = context.getPackageManager();
            Intent intent = new Intent(context, PushService.class);
            List list = packageManager.queryIntentServices(intent, 65536);
            if (list.size() == 0) {
                Log.e((String)TAG, (String)"Required PushService class is not declared in Manifest. Please add.");
                AirSDK.sendIntegrationError("Required PushService class is not declared in Manifest. Please add.");
                new SendIntegrationError(context, 105);
                return;
            }
            Intent intent1 = new Intent(context, BootReceiver.class);
            List list1 = packageManager.queryBroadcastReceivers(intent1, 0);
            if (list1.size() == 0) {
                Log.i((String)TAG, (String)"BootReceiver is not declared in Manifest. Please add.");
                AirSDK.sendIntegrationError("BootReceiver is not declared in Manifest. Please add.");
            } else {
                boolean permissionReceiveBootCompleted;
                boolean bl = permissionReceiveBootCompleted = context.checkCallingOrSelfPermission("android.permission.RECEIVE_BOOT_COMPLETED") == 0;
                if (!permissionReceiveBootCompleted) {
                    Log.e((String)TAG, (String)"Required permission android.permission.RECEIVE_BOOT_COMPLETED not added in Manifest, Please add.");
                    AirSDK.sendIntegrationError("Required permission android.permission.RECEIVE_BOOT_COMPLETED not added in Manifest, Please add.");
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (!Util.isDoPush()) {
            Log.i((String)TAG, (String)"Push Notification is off.");
            return;
        }
        Log.i((String)TAG, (String)("Push Notification...." + Util.isDoPush()));
        if (PushService.getNotificationXML(context) == 0) {
            new SendIntegrationError(context, 106);
        } else if (!PushService.validateFields(context)) {
            new SendIntegrationError(context, 107);
        }
        try {
            if (!AirSDK.checkRequiredDetails(context)) {
                return;
            }
            if (Util.isTestmode()) {
                Log.i((String)TAG, (String)"Notification is running in test mode.");
            }
            if (!AirSDK.isSDKEnabled(context)) {
                Log.i((String)TAG, (String)"AirSDK is disabled, Please enable it to receive push ads.");
                AirSDK.sendAdError("AirSDK is disabled Please enable to recive ads.");
                return;
            }
            Log.i((String)TAG, (String)"Initialising push notification.....");
            try {
                Timer timer = new Timer(true);
                timer.schedule(new TimerTask(){

                    public void run() {
                        Util.printDebugLog("Timer scheduled.");
                        if (Util.checkInternetConnection(context)) {
                            long startTime = SetPreferences.getSDKStartTime(context);
                            if (startTime == 0L) {
                                Intent messageIntent = new Intent(context, PushService.class);
                                String action = PushService.INTENT_ACTION_SET_MESSAGE_RECEIVER + context.getPackageName();
                                messageIntent.setAction(action);
                                context.startService(messageIntent);
                            } else {
                                PushService.reStartSDK(context, true);
                            }
                        } else {
                            PushService.reStartSDK(context, false);
                        }
                    }
                }, 6000L);
            }
            catch (Exception e) {
                e.printStackTrace();
                PushService.reStartSDK(context, Util.checkInternetConnection(context));
            }
        }
        catch (Exception e) {
            Util.printLog("" + e.getMessage());
        }
    }

    static void reStartSDK(Context context, boolean connectivity) {
        long timeDifference = 0L;
        if (connectivity) {
            long startTime = 0L;
            long currentTime = 0L;
            startTime = SetPreferences.getSDKStartTime(context);
            if (startTime != 0L && (currentTime = System.currentTimeMillis()) < startTime) {
                long diff = startTime - currentTime;
                Log.i((String)TAG, (String)("SDK will restart after " + diff + " ms."));
                timeDifference = diff;
                Util.printDebugLog("time difference : " + diff + " minutes");
            }
        } else {
            timeDifference = PushService.random(gap_no_con);
            Log.i((String)TAG, (String)("SDK will start after " + timeDifference + " ms."));
        }
        try {
            Intent messageIntent = new Intent(context, PushService.class);
            String action = INTENT_ACTION_SET_MESSAGE_RECEIVER + context.getPackageName();
            messageIntent.setAction(action);
            PendingIntent pendingIntent = PendingIntent.getService((Context)context, (int)0, (Intent)messageIntent, (int)0);
            AlarmManager msgAlarmMgr = (AlarmManager)context.getSystemService("alarm");
            Calendar calendar = Calendar.getInstance();
            long triggerAtTime = calendar.getTimeInMillis() + timeDifference + (long)IConstants.INTERVAL_FIRST_TIME.intValue() + delay_after_boot;
            msgAlarmMgr.setInexactRepeating(0, triggerAtTime, Util.getMessageIntervalTime(), pendingIntent);
            if (SetPreferences.isDeviceBlackListed(context)) {
                msgAlarmMgr.cancel(pendingIntent);
                System.out.println("Device blacklisted canceling next calls.");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static long random(int[] array) {
        Random random = new Random();
        int i = random.nextInt(array.length - 1);
        return (long)array[i] * 1000L;
    }

    public IBinder onBind(Intent intent) {
        return null;
    }

    public boolean onUnbind(Intent intent) {
        return super.onUnbind(intent);
    }

    public void onLowMemory() {
        super.onLowMemory();
        Log.e((String)TAG, (String)"Low On Memory");
    }

    public void onDestroy() {
        super.onDestroy();
        Log.i((String)TAG, (String)"Service Finished");
    }
}

