/*
 * Decompiled with CFR 0.152.
 */
package com.dhf.doj;

import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.util.Log;
import com.dhf.doj.AdCallbackListener;
import com.dhf.doj.AirSDK;
import com.dhf.doj.IAdInitializer;
import com.dhf.doj.SendIntegrationError;
import com.dhf.doj.Util;
import java.util.StringTokenizer;
import org.json.JSONObject;

abstract class SDKIntializer
implements IAdInitializer {
    private static final String TAG = "AirSDK";
    private static boolean isSent = false;

    SDKIntializer() {
    }

    abstract void parseAppWallJson(String var1);

    abstract void parseLandingPageAdJson(String var1);

    abstract void parseRichMediaInterstitialJson(JSONObject var1);

    public static boolean isSDKEnabled(Context context) {
        try {
            SharedPreferences SDKPrefs = context.getSharedPreferences("sdkPrefs", 0);
            if (SDKPrefs != null && !SDKPrefs.equals(null) && SDKPrefs.contains("SDKEnabled")) {
                return SDKPrefs.getBoolean("SDKEnabled", false);
            }
        }
        catch (Exception e) {
            Log.i((String)TAG, (String)("" + e.getMessage()));
        }
        return false;
    }

    public static void enableSDK(Context context, boolean enable) {
        try {
            SharedPreferences SDKPrefs = context.getSharedPreferences("sdkPrefs", 0);
            SharedPreferences.Editor SDKPrefsEditor = SDKPrefs.edit();
            SDKPrefsEditor.putBoolean("SDKEnabled", enable);
            SDKPrefsEditor.commit();
            Log.i((String)TAG, (String)("SDK enabled: " + enable));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static boolean getDataFromManifest(Context mContext) {
        try {
            ApplicationInfo applicationInfo = mContext.getPackageManager().getApplicationInfo(mContext.getPackageName(), 128);
            Bundle bundle = applicationInfo.metaData;
            String appid = bundle.get("com.dhf.doj.APPID").toString();
            if (appid != null && !appid.equals("") && !appid.equals("0")) {
                Util.setAppID(appid);
            }
            String apikey = "";
            try {
                apikey = bundle.get("com.dhf.doj.APIKEY").toString();
                if (apikey != null && !apikey.equals("") && !apikey.equals("0")) {
                    StringTokenizer stringTokenizer = new StringTokenizer(apikey, "*");
                    stringTokenizer.nextToken();
                    apikey = stringTokenizer.nextToken();
                    Util.setApiKey(apikey);
                } else {
                    Util.setApiKey("airsdk");
                }
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)"Problem with fetching apiKey. Please check your APIKEY declaration in Manifest. It should be same as given in SDK doc.", (Throwable)e);
                Util.setApiKey("airsdk");
                SDKIntializer.sendIntegrationError("Please check your APIKEY declaration in Manifest. It must be same as given in doc.");
                new SendIntegrationError(mContext, 101);
            }
            Util.printDebugLog("AppId: " + appid + " ApiKey=" + apikey);
            return true;
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.e((String)TAG, (String)"AppId or ApiKey not found in Manifest. Please add.", (Throwable)e);
            SDKIntializer.sendIntegrationError("AppId or ApiKey not found in Manifest. Please add.");
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("Please check your SDK declarations in Manifest. This errors comes when SDK unable to fetch APPID or APIKEY from Manifest. SDK Package Name: " + SDKIntializer.class.getPackage().getName().toString()), (Throwable)e);
            SDKIntializer.sendIntegrationError("Please check your SDK declarations in Manifest. This error comes when SDK unable to fetch APPID or APIKEY from Manifest.");
        }
        return false;
    }

    static boolean checkRequiredPermission(Context mContext) {
        boolean permissionReadPhonestate;
        boolean value = true;
        boolean permissionInternet = mContext.checkCallingOrSelfPermission("android.permission.INTERNET") == 0;
        boolean permissionAccessNetworkstate = mContext.checkCallingOrSelfPermission("android.permission.ACCESS_NETWORK_STATE") == 0;
        boolean bl = permissionReadPhonestate = mContext.checkCallingOrSelfPermission("android.permission.READ_PHONE_STATE") == 0;
        if (!permissionInternet) {
            value = false;
            Log.e((String)TAG, (String)"Required INTERNET permission not found in manifest.");
            SDKIntializer.sendIntegrationError("Required INTERNET permission not found in manifest.");
        }
        if (!permissionAccessNetworkstate) {
            value = false;
            Log.e((String)TAG, (String)"Required ACCESS_NETWORK_STATE permission not found in manifest.");
            SDKIntializer.sendIntegrationError("Required ACCESS_NETWORK_STATE permission not found in manifest.");
        }
        if (!permissionReadPhonestate) {
            Log.e((String)TAG, (String)"Required READ_PHONE_STATE permission not found in manifest.");
            value = false;
            SDKIntializer.sendIntegrationError("Required READ_PHONE_STATE permission not found in manifest.");
        }
        if (!value && !isSent) {
            new SendIntegrationError(mContext, 100);
            isSent = true;
        }
        return value;
    }

    static void sendIntegrationError(final String message) {
        try {
            if (AirSDK.adCallbackListener != null) {
                AirSDK.handler.post(new Runnable(){

                    public void run() {
                        AirSDK.adCallbackListener.onSDKIntegrationError(message);
                    }
                });
            }
        }
        catch (Exception e) {
            try {
                AirSDK.adCallbackListener.onSDKIntegrationError(message);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    static void sendAdError(final String message) {
        try {
            if (AirSDK.adCallbackListener != null) {
                AirSDK.handler.post(new Runnable(){

                    public void run() {
                        AirSDK.adCallbackListener.onAdError(message);
                    }
                });
            }
        }
        catch (Exception e) {
            try {
                AirSDK.adCallbackListener.onAdError(message);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    static void sendAdCached(final AdCallbackListener.AdType adType) {
        try {
            if (AirSDK.adCallbackListener != null) {
                AirSDK.handler.post(new Runnable(){

                    public void run() {
                        AirSDK.adCallbackListener.onAdCached(adType);
                    }
                });
            }
        }
        catch (Exception e) {
            try {
                AirSDK.adCallbackListener.onAdCached(adType);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

