/*
 * Decompiled with CFR 0.152.
 */
package com.dhf.doj;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.util.Log;
import com.dhf.doj.Util;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.util.EntityUtils;

class SendIntegrationError {
    static final int REQUIRED_PERMISSIONS_NOT_FOUND = 100;
    static final int INVALID_APIKEY = 101;
    static final int VIDEO_AD_ACTIVITY_NOT_FOUND = 102;
    static final int SMARTWALL_ACTIVITY_NOT_FOUND = 103;
    static final int SMARTWALL_BROWSER_ACTITY_NOT_FOUND = 104;
    static final int PUSH_SERVICE_NOT_FOUND = 105;
    static final int AIRSDK_NOTIFY_XML_NOT_FOUND = 106;
    static final int INVALID_AIRSDK_NOTIFY_XML = 107;
    static final int INSTALL_SHORT_CUT_NOT_FOUND = 108;
    static final int BANNER_AD_BROWSER_ACTIVTY_NOT_FOUND = 109;
    static final int REQUIRED_VIDEO_AD_PERMISSIONS_NOT_FOUND = 110;
    private Context context;

    public SendIntegrationError(Context context, int code) {
        if (context == null) {
            return;
        }
        this.context = context;
        if (Util.checkInternetConnection(context)) {
            this.sendIntegartionError(code);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendIntegartionError(final int code) {
        SendIntegrationError sendIntegrationError = this;
        synchronized (sendIntegrationError) {
            try {
                if (Util.getAppID() == null || Util.getAppID().equals("0")) {
                    Log.i((String)"AirSDK", (String)"Appid is invalid. Sending report aborted.");
                    return;
                }
                new Thread(new Runnable(){

                    public void run() {
                        try {
                            PackageInfo pInfo = SendIntegrationError.this.context.getPackageManager().getPackageInfo(SendIntegrationError.this.context.getPackageName(), 0);
                            String version = "" + pInfo.versionCode;
                            ArrayList<BasicNameValuePair> list = new ArrayList<BasicNameValuePair>();
                            list.add(new BasicNameValuePair("appVersion", version));
                            list.add(new BasicNameValuePair("appId", Util.getAppID()));
                            list.add(new BasicNameValuePair("errorCode", "" + code));
                            list.add(new BasicNameValuePair("packageName", SendIntegrationError.this.context.getPackageName()));
                            CharSequence app = SendIntegrationError.this.context.getPackageManager().getApplicationLabel(pInfo.applicationInfo);
                            list.add(new BasicNameValuePair("appName", ((Object)app).toString()));
                            Log.i((String)"AirSDK", (String)("Error values: " + list));
                            DefaultHttpClient httpclient = new DefaultHttpClient();
                            HttpPost httpPost = new HttpPost("https://api.airpush.com/integrationerror/error.php");
                            httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(list));
                            BasicHttpParams basicHttpParams = new BasicHttpParams();
                            httpPost.setParams((HttpParams)basicHttpParams);
                            HttpConnectionParams.setConnectionTimeout((HttpParams)basicHttpParams, (int)7000);
                            HttpConnectionParams.setSoTimeout((HttpParams)basicHttpParams, (int)7000);
                            HttpResponse response = httpclient.execute((HttpUriRequest)httpPost);
                            int code2 = response == null ? 0 : response.getStatusLine().getStatusCode();
                            Log.i((String)"AirSDK", (String)("Status code: " + code2));
                            if (code2 == 200) {
                                String string = EntityUtils.toString((HttpEntity)response.getEntity());
                                Log.i((String)"AirSDK", (String)("Error sent: " + string));
                            } else {
                                Log.i((String)"AirSDK", (String)("Status Code: " + code2 + ", Reason: " + response.getStatusLine().getReasonPhrase()));
                            }
                        }
                        catch (PackageManager.NameNotFoundException e) {
                            e.printStackTrace();
                        }
                        catch (UnsupportedEncodingException e) {
                            e.printStackTrace();
                        }
                        catch (ClientProtocolException e) {
                            e.printStackTrace();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }).start();
            }
            catch (Exception e) {
                Log.e((String)"AirSDK", (String)"Sending integration error failed.", (Throwable)e);
            }
        }
    }
}

