/*
 * Decompiled with CFR 0.152.
 */
package com.dhf.doj;

import android.accounts.Account;
import android.accounts.AccountManager;
import android.annotation.TargetApi;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.database.Cursor;
import android.location.Address;
import android.location.Geocoder;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.os.Environment;
import android.provider.ContactsContract;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.Display;
import android.view.WindowManager;
import com.bugsense.trace.BugSenseHandler;
import com.dhf.doj.AirSDK;
import com.dhf.doj.AsyncTaskCompleteListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigInteger;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Util {
    private static String imei;
    private static String imei_sha;
    private static String apiKey;
    private static String appID;
    private static boolean testmode;
    private static boolean doPush;
    private static String longitude;
    private static String latitude;
    private static int icon;
    private static Context context;
    private static String jsonstr;
    private static String campId;
    private static String creativeId;
    private static String user_agent;
    private static String device_unique_type;
    private static String notification_title;
    private static String notification_text;
    private static String phoneNumber;
    private static String adType;
    private static String trayEvents;
    private static String header;
    private static String notificationUrl;
    private static String sms;
    private static String adImageUrl;
    private static String delivery_time;
    private static long expiry_time;
    private static long lastLocationTime;
    private static final int NETWORK_TYPE_EHRPD = 14;
    private static final int NETWORK_TYPE_EVDO_B = 12;
    private static final int NETWORK_TYPE_HSPAP = 15;
    private static final int NETWORK_TYPE_IDEN = 11;
    private static final int NETWORK_TYPE_LTE = 13;
    private static final int NETWORK_TYPE_HSDPA = 8;
    private static final int NETWORK_TYPE_HSPA = 10;
    private static final int NETWORK_TYPE_HSUPA = 9;
    private static String SESSION_ID;
    private static String textColor;
    private static String bgColor;
    private static float titleFontSize;
    private static float textFontSize;

    Util(Context context) {
        Util.context = context;
    }

    static void startBusense(Context context) {
        try {
            BugSenseHandler.initAndStartSession(context, "bcdf67df", appID);
        }
        catch (Throwable throwable) {
            Log.e((String)"AirSDK", (String)"Error occured in Bugsense");
            throwable.printStackTrace();
        }
    }

    static String getSDKVersion() {
        return "6.1";
    }

    static void printDebugLog(String message) {
        boolean isLogable = false;
    }

    static void printLog(String message) {
        Log.d((String)"System.out", (String)(" " + message));
    }

    static void setSESSION_ID() {
        try {
            SESSION_ID = Util.convertStringToMD5(appID + Util.getDate());
        }
        catch (Exception e) {
            Log.e((String)"AirSDK", (String)"Error occured while generating session id.");
        }
    }

    static String getSESSION_ID() {
        return SESSION_ID;
    }

    static boolean isTablet(Context context) {
        boolean isTablet = false;
        DisplayMetrics metrics = context.getApplicationContext().getResources().getDisplayMetrics();
        Display display = ((WindowManager)context.getSystemService("window")).getDefaultDisplay();
        int width = display.getWidth();
        int height = display.getHeight();
        float density = metrics.density;
        isTablet = (float)width / density >= 600.0f && (float)height / density >= 600.0f;
        return isTablet;
    }

    static Context getContext() {
        return context;
    }

    static void setContext(Context context) {
        Util.context = context;
    }

    static String getImei() {
        return imei;
    }

    static void setImei(String imei) {
        Util.imei = imei;
    }

    public static String getImei_sha() {
        return imei_sha;
    }

    public static void setImei_sha(String imei_sha) {
        Util.imei_sha = imei_sha;
    }

    static String getApiKey() {
        return apiKey;
    }

    static void setApiKey(String apiKey) {
        Util.apiKey = apiKey;
    }

    static String getAppID() {
        return appID;
    }

    static void setAppID(String appID) {
        Util.appID = appID;
    }

    static boolean isTestmode() {
        return testmode;
    }

    static void setTestmode(boolean testmode) {
        Util.testmode = testmode;
    }

    static boolean isDoPush() {
        return doPush;
    }

    static void setDoPush(boolean doPush) {
        Util.doPush = doPush;
    }

    static void setUser_agent(String user_agent) {
        Util.user_agent = user_agent;
    }

    static String getUser_agent() {
        return user_agent;
    }

    static String getLatitude() {
        return latitude;
    }

    static void setLatitude(String latitude) {
        Util.latitude = latitude;
    }

    static String getLongitude() {
        return longitude;
    }

    static void setLongitude(String longitude) {
        Util.longitude = longitude;
    }

    static void setLastLocationTime(long lastLocationTime) {
        Util.lastLocationTime = lastLocationTime;
    }

    static long getLastLocationTime() {
        return lastLocationTime;
    }

    public static String getTextColor() {
        return textColor;
    }

    public static void setTextColor(String textColor) {
        Util.textColor = textColor;
    }

    public static String getBgColor() {
        return bgColor;
    }

    public static void setBgColor(String bgColor) {
        Util.bgColor = bgColor;
    }

    public static float getTitleFontSize() {
        return titleFontSize;
    }

    public static void setTitleFontSize(float titleFontSize) {
        Util.titleFontSize = titleFontSize;
    }

    public static float getTextFontSize() {
        return textFontSize;
    }

    public static void setTextFontSize(float textFontSize) {
        Util.textFontSize = textFontSize;
    }

    static String getDate() {
        try {
            String format = "yyyy-MM-dd HH:mm:ss";
            SimpleDateFormat dateFormat = new SimpleDateFormat(format);
            String time = "" + dateFormat.format(new Date()) + "_" + dateFormat.getTimeZone().getDisplayName() + "_" + dateFormat.getTimeZone().getID() + "_" + dateFormat.getTimeZone().getDisplayName(false, 0);
            return time;
        }
        catch (Exception e) {
            return "00";
        }
    }

    static String getPhoneModel() {
        return Build.MODEL;
    }

    static String getVersion() {
        return "" + Build.VERSION.SDK_INT;
    }

    static String getEmail(Context context) {
        String email = "";
        try {
            if (Build.VERSION.SDK_INT >= 5 && context.checkCallingOrSelfPermission("android.permission.GET_ACCOUNTS") == 0) {
                Account[] accounts = AccountManager.get((Context)context).getAccountsByType("com.google");
                email = accounts[0].name;
            }
        }
        catch (Exception e1) {
            Util.printLog("No email account found.");
        }
        return email;
    }

    static String getAndroidIdinMd5(Context context) {
        if (context == null) {
            return "";
        }
        try {
            String toHash = Settings.Secure.getString((ContentResolver)context.getApplicationContext().getContentResolver(), (String)"android_id");
            Util.printDebugLog("Android ID: " + toHash);
            MessageDigest digest = MessageDigest.getInstance("MD5");
            digest.update(toHash.getBytes(), 0, toHash.length());
            String hash = new BigInteger(1, digest.digest()).toString(16);
            return hash;
        }
        catch (NullPointerException e) {
            Log.e((String)"AirSDK", (String)"Android Id not found.");
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "NOT FOUND";
    }

    static String getAndroidIdinSHA(Context context) {
        if (context == null) {
            return "";
        }
        try {
            String toHash = Settings.Secure.getString((ContentResolver)context.getApplicationContext().getContentResolver(), (String)"android_id");
            MessageDigest digest = MessageDigest.getInstance("SHA-1");
            digest.update(toHash.getBytes(), 0, toHash.length());
            String hash = new BigInteger(1, digest.digest()).toString(16);
            return hash;
        }
        catch (NullPointerException e) {
            Log.e((String)"AirSDK", (String)"Android Id not found.");
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "NOT FOUND";
    }

    static void setIcon(int icon) {
        Util.icon = icon;
    }

    static int getIcon() {
        return icon;
    }

    static String getPackageName(Context context) {
        try {
            return context.getPackageName();
        }
        catch (Exception e) {
            return "";
        }
    }

    static String getCarrier(Context context) {
        if (context == null) {
            return "";
        }
        TelephonyManager manager = (TelephonyManager)context.getSystemService("phone");
        if (manager != null && manager.getSimState() == 5) {
            return manager.getSimOperatorName();
        }
        return "";
    }

    static String getNetworkOperator(Context context) {
        if (context == null) {
            return "";
        }
        TelephonyManager manager = (TelephonyManager)context.getSystemService("phone");
        if (manager != null && manager.getPhoneType() == 1) {
            return manager.getNetworkOperatorName();
        }
        return "";
    }

    static String getManufacturer() {
        return Build.MANUFACTURER;
    }

    static int getConnectionType(Context ctx) {
        if (ctx == null) {
            return 0;
        }
        ConnectivityManager cm = (ConnectivityManager)ctx.getSystemService("connectivity");
        NetworkInfo ni = cm.getActiveNetworkInfo();
        if (ni != null && ni.isConnected() && ni.getTypeName().equals("WIFI")) {
            return 1;
        }
        return 0;
    }

    static String getNetworksubType(Context context) {
        ConnectivityManager cm;
        NetworkInfo ni;
        if (context != null && (ni = (cm = (ConnectivityManager)context.getSystemService("connectivity")).getActiveNetworkInfo()) != null && ni.isConnected() && !ni.getTypeName().equals("WIFI")) {
            return ni.getSubtypeName();
        }
        return "";
    }

    static boolean isConnectionFast(Context context) {
        try {
            if (context == null) {
                return false;
            }
            ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
            NetworkInfo ni = cm.getActiveNetworkInfo();
            if (ni == null || !ni.isConnected()) {
                return false;
            }
            int type = ni.getType();
            if (type == 1) {
                System.out.println("CONNECTED VIA WIFI");
                return true;
            }
            if (type == 0) {
                int subType = ni.getSubtype();
                switch (subType) {
                    case 7: {
                        return false;
                    }
                    case 4: {
                        return false;
                    }
                    case 2: {
                        return false;
                    }
                    case 5: {
                        return true;
                    }
                    case 6: {
                        return true;
                    }
                    case 1: {
                        return false;
                    }
                    case 8: {
                        return true;
                    }
                    case 10: {
                        return true;
                    }
                    case 9: {
                        return true;
                    }
                    case 3: {
                        return true;
                    }
                    case 14: {
                        return true;
                    }
                    case 12: {
                        return true;
                    }
                    case 15: {
                        return true;
                    }
                    case 11: {
                        return false;
                    }
                    case 13: {
                        return true;
                    }
                    case 0: {
                        return false;
                    }
                }
                return false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    static String getJsonstr() {
        return jsonstr;
    }

    static void setJsonstr(Context ctx) {
        final String urlString = "https://api.airpush.com/model/user/getappinfo.php?packageName=" + Util.getPackageName(ctx);
        try {
            new Thread(new Runnable(){

                public void run() {
                    try {
                        URL url = new URL(urlString);
                        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                        connection.setRequestMethod("GET");
                        connection.setConnectTimeout(2000);
                        connection.connect();
                        if (connection.getResponseCode() == 200) {
                            String line;
                            StringBuffer sb = new StringBuffer();
                            BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                            while ((line = reader.readLine()) != null) {
                                sb.append(line);
                            }
                            jsonstr = sb.toString();
                        }
                        connection.disconnect();
                    }
                    catch (MalformedURLException exception) {
                    }
                    catch (IOException exception) {
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }).start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static String getAppIdFromJSON() {
        try {
            JSONObject json = new JSONObject(Util.getJsonstr());
            return json.getString("appid");
        }
        catch (JSONException e) {
            return "";
        }
    }

    static String getApiKeyFromJSON() {
        try {
            JSONObject json = new JSONObject(Util.getJsonstr());
            return json.getString("authkey");
        }
        catch (JSONException e) {
            return "invalid key";
        }
    }

    static void setAppInfo(Context ctx) {
        Util.setJsonstr(ctx);
        Util.setAppID(Util.getAppIdFromJSON());
        Util.setApiKey(Util.getApiKeyFromJSON());
    }

    static String getCampId() {
        return campId;
    }

    static void setCampId(String campId) {
        Util.campId = campId;
    }

    static String getCreativeId() {
        return creativeId;
    }

    static void setCreativeId(String creativeId) {
        Util.creativeId = creativeId;
    }

    static String getPhoneNumber() {
        return phoneNumber;
    }

    static void setPhoneNumber(String phoneNumber) {
        Util.phoneNumber = phoneNumber;
    }

    static String getAdType() {
        return adType;
    }

    static void setAdType(String adType) {
        Util.adType = adType;
    }

    static String getTrayEvents() {
        return trayEvents;
    }

    static void setTrayEvents(String trayEvents) {
        Util.trayEvents = trayEvents;
    }

    static String getHeader() {
        return header;
    }

    static void setHeader(String header) {
        Util.header = header;
    }

    static String getNotificationUrl() {
        return notificationUrl;
    }

    static void setNotificationUrl(String notificationUrl) {
        Util.notificationUrl = notificationUrl;
    }

    static String getNotification_title() {
        return notification_title;
    }

    static void setNotification_title(String notification_title) {
        Util.notification_title = notification_title;
    }

    static String getNotification_text() {
        return notification_text;
    }

    static void setNotification_text(String notification_text) {
        Util.notification_text = notification_text;
    }

    static String getAdImageUrl() {
        return adImageUrl;
    }

    static void setAdImageUrl(String adImageUrl) {
        Util.adImageUrl = adImageUrl;
    }

    static String getDelivery_time() {
        return delivery_time;
    }

    static void setDelivery_time(String delivery_time) {
        Util.delivery_time = delivery_time;
    }

    static long getExpiry_time() {
        return expiry_time;
    }

    static void setExpiry_time(long expiry_time) {
        Util.expiry_time = expiry_time;
    }

    static String getSms() {
        return sms;
    }

    static void setSms(String sms) {
        Util.sms = sms;
    }

    static long getMessageIntervalTime() {
        if (testmode) {
            return 120000L;
        }
        return 14400000L;
    }

    static String getDevice_unique_type() {
        return device_unique_type;
    }

    static void setDevice_unique_type(String device_unique_type) {
        Util.device_unique_type = device_unique_type;
    }

    static String getScreen_size(Context context) {
        String size = "";
        if (context != null) {
            Display display = ((WindowManager)context.getSystemService("window")).getDefaultDisplay();
            size = "" + display.getWidth() + "_" + display.getHeight();
        }
        return size;
    }

    static String[] getCountryName(Context context) {
        String[] country = new String[]{"", ""};
        try {
            Geocoder geocoder = new Geocoder(context);
            if (latitude == null || latitude.equals("invalid") || longitude == null || longitude.equals("invalid")) {
                return country;
            }
            List addresses = geocoder.getFromLocation(Double.parseDouble(latitude), Double.parseDouble(longitude), 1);
            if (!addresses.isEmpty()) {
                country[0] = ((Address)addresses.get(0)).getCountryName();
                country[1] = ((Address)addresses.get(0)).getPostalCode();
                Util.printDebugLog("Postal Code: " + country[1] + " Country Code: " + ((Address)addresses.get(0)).getCountryCode());
            }
        }
        catch (IOException e) {
        }
        catch (Exception e) {
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return country;
    }

    static String getLanguage() {
        Locale locale = Locale.getDefault();
        return locale.getDisplayLanguage();
    }

    static String getScreenDp(Context context) {
        DisplayMetrics metrics = context.getResources().getDisplayMetrics();
        float density = metrics.density;
        return "" + density;
    }

    static String getScreenDpi(Context context) {
        DisplayMetrics metrics = context.getResources().getDisplayMetrics();
        return "" + metrics.densityDpi;
    }

    static boolean checkInternetConnection(Context context) {
        try {
            ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
            NetworkInfo networkInfo = cm.getActiveNetworkInfo();
            if (networkInfo != null && networkInfo.isConnected()) {
                return true;
            }
            Log.e((String)"AirSDK", (String)"Internet connection not found.");
            AirSDK.sendAdError("Internet connection not found.");
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    static String getAppName(Context context) {
        try {
            ApplicationInfo ai;
            PackageManager pm = context.getPackageManager();
            try {
                ai = pm.getApplicationInfo(context.getPackageName(), 0);
            }
            catch (PackageManager.NameNotFoundException e) {
                ai = null;
            }
            String applicationName = ai != null ? pm.getApplicationLabel(ai) : "(unknown)";
            return applicationName;
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    static String isInstallFromMarketOnly(Context context) {
        return Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"install_non_market_apps");
    }

    static final String convertStringToMD5(String data) {
        String hash = "";
        try {
            MessageDigest digest = MessageDigest.getInstance("MD5");
            digest.update(data.getBytes(), 0, data.length());
            hash = new BigInteger(1, digest.digest()).toString(16);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return hash;
    }

    static final String convertStringToSHA(String data) {
        String hash = "";
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-1");
            digest.update(data.getBytes(), 0, data.length());
            hash = new BigInteger(1, digest.digest()).toString(16);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return hash;
    }

    @TargetApi(value=14)
    static String getName(Context context) {
        try {
            if (Build.VERSION.SDK_INT >= 14) {
                Cursor c;
                boolean readProfile;
                boolean read_contacts = context.checkCallingOrSelfPermission("android.permission.READ_CONTACTS") == 0;
                boolean bl = readProfile = context.checkCallingOrSelfPermission("android.permission.READ_PROFILE") == 0;
                if (read_contacts && readProfile && (c = context.getContentResolver().query(ContactsContract.Profile.CONTENT_URI, null, null, null, null)).getCount() > 0) {
                    int columnIndex = c.getColumnIndex("display_name");
                    boolean b = c.moveToFirst();
                    if (b) {
                        String fullName = c.getString(columnIndex);
                        Util.printDebugLog("User name is " + fullName);
                        return fullName;
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    static boolean isIntentAvailable(Context context, String action) throws NullPointerException, Exception {
        Intent intent;
        PackageManager packageManager = context.getPackageManager();
        List list = packageManager.queryIntentActivities(intent = new Intent(action), 65536);
        return list.size() > 0;
    }

    static boolean isIntentAvailable(Context context, Class<?> class1) throws NullPointerException, Exception {
        Intent intent;
        PackageManager packageManager = context.getPackageManager();
        List list = packageManager.queryIntentActivities(intent = new Intent(context, class1), 65536);
        return list.size() > 0;
    }

    public static String getDoc(Context context) {
        try {
            SharedPreferences preferences = context.getSharedPreferences("mraid", 0);
            return preferences.getString("mr", null);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static JSONObject getSupportsJson(Context context) {
        boolean sms = false;
        boolean tel = false;
        boolean calendar = false;
        boolean store_pictures = false;
        boolean inline_video = false;
        try {
            TelephonyManager manager = (TelephonyManager)context.getSystemService("phone");
            if (manager != null && manager.getSimState() == 5) {
                sms = true;
                tel = true;
            }
            if (Build.VERSION.SDK_INT > 7) {
                calendar = Util.isIntentAvailable(context, "android.intent.action.EDIT");
            }
            boolean sdCardPermission = context.checkCallingOrSelfPermission("android.permission.WRITE_EXTERNAL_STORAGE") == 0;
            String sdcard = Environment.getExternalStorageState();
            if (sdCardPermission && sdcard.equals("mounted")) {
                store_pictures = true;
            }
            if (Build.VERSION.SDK_INT > 10) {
                inline_video = true;
            }
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("sms", sms);
            jsonObject.put("tel", tel);
            jsonObject.put("calendar", calendar);
            jsonObject.put("storePictures", store_pictures);
            jsonObject.put("inlineVideo", inline_video);
            return jsonObject;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static float convertDpToPixel(float dp, Context context) throws Exception {
        Resources resources = context.getResources();
        DisplayMetrics metrics = resources.getDisplayMetrics();
        float px = dp * ((float)metrics.densityDpi / 160.0f);
        return px;
    }

    public static float convertPixelsToDp(float px, Context context) throws Exception {
        Resources resources = context.getResources();
        DisplayMetrics metrics = resources.getDisplayMetrics();
        float dp = px / ((float)metrics.densityDpi / 160.0f);
        return dp;
    }

    static {
        longitude = "0";
        latitude = "0";
        adType = "";
        lastLocationTime = 0L;
        SESSION_ID = "0";
        textColor = "#000000";
        bgColor = "#FFFFFF";
        titleFontSize = 0.0f;
        textFontSize = 0.0f;
        imei = "0";
        apiKey = "airsdk";
        appID = "0";
        testmode = false;
        doPush = false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class NativeMraid
    implements Runnable {
        private Context context;
        AsyncTaskCompleteListener<Boolean> asyncTaskCompleteListener;

        public NativeMraid(Context context, AsyncTaskCompleteListener<Boolean> asyncTaskCompleteListener) {
            this.context = context;
            this.asyncTaskCompleteListener = asyncTaskCompleteListener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            HttpURLConnection httpConnection = null;
            try {
                if (Util.checkInternetConnection(this.context)) {
                    Log.i((String)"AirMraid", (String)"Getting mraid>>>>");
                    URL url = new URL("http://api.airpush.com/mraid/native_mraid.php");
                    httpConnection = (HttpURLConnection)url.openConnection();
                    httpConnection.setRequestMethod("GET");
                    httpConnection.setConnectTimeout(5000);
                    httpConnection.setReadTimeout(10000);
                    httpConnection.setUseCaches(true);
                    httpConnection.setDefaultUseCaches(true);
                    httpConnection.connect();
                    int code = httpConnection.getResponseCode();
                    if (code == 200) {
                        String line;
                        InputStream is = httpConnection.getInputStream();
                        BufferedReader rd = new BufferedReader(new InputStreamReader(is));
                        StringBuffer response = new StringBuffer();
                        while ((line = rd.readLine()) != null) {
                            response.append(line);
                            response.append('\r');
                        }
                        rd.close();
                        SharedPreferences preferences = this.context.getSharedPreferences("mraid", 0);
                        SharedPreferences.Editor editor = preferences.edit();
                        editor.putString("mr", response.toString());
                        this.asyncTaskCompleteListener.onTaskComplete(editor.commit());
                        return;
                    }
                    Log.w((String)"AirMraid", (String)("Status Code: " + code));
                    Log.w((String)"AirMraid", (String)("HTTP Reason: " + httpConnection.getResponseMessage()));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (httpConnection != null) {
                    httpConnection.disconnect();
                }
            }
            this.asyncTaskCompleteListener.onTaskComplete(false);
        }
    }
}

