/*
 * Decompiled with CFR 0.152.
 */
package com.dhf.doj;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Environment;
import android.util.Log;
import com.dhf.doj.AdCallbackListener;
import com.dhf.doj.AirSDK;
import com.dhf.doj.AsyncTaskCompleteListener;
import com.dhf.doj.Caching;
import com.dhf.doj.NetworkThread;
import com.dhf.doj.SendIntegrationError;
import com.dhf.doj.SetPreferences;
import com.dhf.doj.Util;
import com.dhf.doj.VastUtils;
import com.dhf.doj.VastXmlParser;
import com.dhf.doj.VideoAdActivity;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.http.NameValuePair;
import org.xmlpull.v1.XmlPullParserException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class VideoAd
implements AsyncTaskCompleteListener<String> {
    private static final String TAG = "AirVast";
    private static VastXmlParser vastXmlParser;
    private Context context;

    static VastXmlParser getVastXmlParser() {
        return vastXmlParser;
    }

    public VideoAd(Context context) {
        this.context = context;
    }

    @Override
    public void launchNewHttpTask() {
        try {
            ArrayList<NameValuePair> list = new ArrayList<NameValuePair>();
            NetworkThread networkThread = new NetworkThread(this.context, this, list, "https://api.airpush.com/Vast/vastadcall.php", 0L, true);
            new Thread((Runnable)networkThread, "vast").start();
        }
        catch (NullPointerException e) {
            Log.e((String)TAG, (String)"Video ad", (Throwable)e);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"Error occurred while fetching Video ad", (Throwable)e);
        }
    }

    @Override
    public void onTaskComplete(String result) {
        Log.i((String)TAG, (String)("Video Ad: " + result));
        if (result == null || result.equals("")) {
            Log.w((String)TAG, (String)"Video ad response is null");
            return;
        }
        this.parseVideoAd(result);
    }

    void parseVideoAd(String result) {
        try {
            SetPreferences.setNextVideoAdCall(this.context);
            StringReader reader = new StringReader(result);
            vastXmlParser = new VastXmlParser(reader);
            List<VastXmlParser.Creative> creatives = vastXmlParser.getCreativesList();
            VastXmlParser.Creative creative = creatives.get(0);
            List<HashMap<String, Object>> mediaFiles = creative.getMediaFiles();
            HashMap<String, Object> media = mediaFiles.get(0);
            String url = media.get("MediaFile").toString();
            String delivery = media.get("delivery").toString();
            if (url != null && !url.equals("")) {
                if (delivery != null && delivery.equals("progressive")) {
                    this.downloadVideo(url);
                } else if (AirSDK.enableCaching) {
                    Caching caching = new Caching(this.context);
                    caching.saveVideoJson(AdCallbackListener.AdType.video, result, url);
                    AirSDK.sendAdCached(AdCallbackListener.AdType.video);
                } else {
                    Log.e((String)TAG, (String)("deleviery type streaming " + url));
                    Intent intent = new Intent(this.context, VideoAdActivity.class);
                    intent.setAction("play_video");
                    intent.setFlags(0x10000000);
                    intent.addFlags(0x800000);
                    intent.addFlags(0x20000000);
                    intent.setData(Uri.parse((String)url));
                    this.context.startActivity(intent);
                    SetPreferences.setNextVideoAdCall(this.context);
                }
            } else {
                Log.e((String)TAG, (String)("Ad url is invalid: " + url));
            }
        }
        catch (VastXmlParser.VastException e) {
            Log.e((String)TAG, (String)e.getMessage());
            AirSDK.validateStatusCode(e.getCode(), e.getMessage());
        }
        catch (VastXmlParser.InvalidVastXML e) {
        }
        catch (XmlPullParserException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    void starVideoAdActivity() {
        try {
            Caching caching = new Caching(this.context);
            String[] ad = caching.getVideoAdJson(AdCallbackListener.AdType.video);
            if (ad != null && ad[1] != null) {
                Log.i((String)TAG, (String)("deleviery type streaming " + ad[1]));
                Intent intent = new Intent(this.context, VideoAdActivity.class);
                intent.setAction("play_video");
                intent.setFlags(0x10000000);
                intent.addFlags(0x800000);
                intent.addFlags(0x20000000);
                intent.setData(Uri.parse((String)ad[1]));
                this.context.startActivity(intent);
                SetPreferences.setNextVideoAdCall(this.context);
            } else {
                AirSDK.validateStatusCode(204, "Video ad is not available in cache");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void downloadVideo(final String video_url) {
        try {
            String state = Environment.getExternalStorageState();
            Boolean isSDCardPresent = state.equals("mounted") && !state.equals("mounted_ro");
            if (!isSDCardPresent.booleanValue()) {
                String message = "SD Card  is not available for caching video. SD Card storage state: " + state;
                Log.e((String)TAG, (String)message);
                AirSDK.sendAdError(message);
                return;
            }
            AsyncTaskCompleteListener<String> downlaodVideoTask = new AsyncTaskCompleteListener<String>(){
                String local_file_url = "";

                @Override
                public void onTaskComplete(String result) {
                    Util.printDebugLog("Video file: " + result);
                    try {
                        if (result != null && !result.equals("")) {
                            if (AirSDK.enableCaching) {
                                Caching caching = new Caching(VideoAd.this.context);
                                if (caching.saveVideoJson(AdCallbackListener.AdType.video, result, result)) {
                                    AirSDK.sendAdCached(AdCallbackListener.AdType.video);
                                } else if (AirSDK.adCallbackListener != null) {
                                    AirSDK.sendAdError("Video ad not cached.");
                                }
                            } else {
                                Intent intent = new Intent(VideoAd.this.context, VideoAdActivity.class);
                                intent.setAction("play_video");
                                intent.setFlags(0x10000000);
                                intent.addFlags(0x800000);
                                intent.addFlags(0x20000000);
                                intent.setData(Uri.parse((String)result));
                                VideoAd.this.context.startActivity(intent);
                                SetPreferences.setNextVideoAdCall(VideoAd.this.context);
                            }
                        } else {
                            Log.e((String)VideoAd.TAG, (String)"Not able to download video");
                        }
                    }
                    catch (Exception e) {
                        Log.e((String)VideoAd.TAG, (String)"Error occured while download video", (Throwable)e);
                    }
                }

                @Override
                public void launchNewHttpTask() {
                    try {
                        File path = Environment.getExternalStorageDirectory();
                        File file = new File(path, "ap_video");
                        if (file.exists() && file.isDirectory()) {
                            VastUtils.deleteRecursive(file);
                            file.mkdirs();
                            this.local_file_url = file.getAbsolutePath();
                        } else if (file.mkdirs()) {
                            this.local_file_url = file.getAbsolutePath();
                        }
                        new Thread(new Runnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public void run() {
                                URLConnection connection = null;
                                try {
                                    URL url = new URL(video_url);
                                    connection = url.openConnection();
                                    connection.setConnectTimeout(7000);
                                    connection.setReadTimeout(7000);
                                    connection.connect();
                                    Log.i((String)VideoAd.TAG, (String)("Content-length: " + connection.getContentLength()));
                                    InputStream stream = connection.getInputStream();
                                    File file = new File(local_file_url, "ad_video.mp4");
                                    try {
                                        if (file.exists()) {
                                            file.delete();
                                        }
                                    }
                                    catch (Exception e) {
                                        e.printStackTrace();
                                    }
                                    FileOutputStream fileOutputStream = new FileOutputStream(file);
                                    byte[] buffer = new byte[1024];
                                    int sz = 0;
                                    while ((sz = stream.read(buffer)) > 0) {
                                        fileOutputStream.write(buffer, 0, sz);
                                    }
                                    fileOutputStream.close();
                                    this.onTaskComplete(file.getAbsolutePath());
                                    return;
                                }
                                catch (SocketTimeoutException e) {
                                    e.printStackTrace();
                                }
                                catch (MalformedURLException e) {
                                    e.printStackTrace();
                                }
                                catch (IOException e) {
                                    e.printStackTrace();
                                }
                                finally {
                                    connection = null;
                                }
                                this.onTaskComplete(null);
                            }
                        }, "dwn_video").start();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            };
            if (Util.checkInternetConnection(this.context)) {
                downlaodVideoTask.launchNewHttpTask();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static boolean checkVideoAdPermission(Context context) {
        try {
            String msg;
            boolean access;
            boolean val = true;
            boolean external = context.checkCallingOrSelfPermission("android.permission.WRITE_EXTERNAL_STORAGE") == 0;
            boolean bl = access = context.checkCallingOrSelfPermission("android.permission.ACCESS_WIFI_STATE") == 0;
            if (!external) {
                val = false;
                msg = "Required permission WRITE_EXTERNAL_STORAGE not found in Manifest. Please add.";
                Log.e((String)"AirSDK", (String)msg);
                AirSDK.sendIntegrationError(msg);
            }
            if (!access) {
                val = false;
                msg = "Required permission ACCESS_WIFI_STATE not found in Manifest. Please add.";
                Log.e((String)"AirSDK", (String)msg);
                AirSDK.sendIntegrationError(msg);
            }
            if (!val) {
                new SendIntegrationError(context, 110);
            }
            return val;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}

